/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.metainject;

import org.apache.hop.core.exception.HopPluginException;
import org.apache.hop.core.exception.HopValueException;
import org.apache.hop.core.injection.Injection;
import org.apache.hop.core.injection.InjectionTypeConverter;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.value.ValueMetaBase;
import org.apache.hop.core.row.value.ValueMetaFactory;

public class MetaInjectOutputField {
    @Injection(name="SOURCE_OUTPUT_NAME", group="SOURCE_OUTPUT_FIELDS")
    private String name;
    @Injection(name="SOURCE_OUTPUT_TYPE", group="SOURCE_OUTPUT_FIELDS", converter=DataTypeConverter.class)
    private int type;
    @Injection(name="SOURCE_OUTPUT_LENGTH", group="SOURCE_OUTPUT_FIELDS")
    private int length;
    @Injection(name="SOURCE_OUTPUT_PRECISION", group="SOURCE_OUTPUT_FIELDS")
    private int precision;

    public MetaInjectOutputField() {
    }

    public MetaInjectOutputField(String name, int type, int length, int precision) {
        this.name = name;
        this.type = type;
        this.length = length;
        this.precision = precision;
    }

    public String getTypeDescription() {
        return ValueMetaFactory.getValueMetaName((int)this.type);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public int getPrecision() {
        return this.precision;
    }

    public void setPrecision(int precision) {
        this.precision = precision;
    }

    public IValueMeta createValueMeta() throws HopPluginException {
        return ValueMetaFactory.createValueMeta((String)this.name, (int)this.type, (int)this.length, (int)this.precision);
    }

    public static class DataTypeConverter
    extends InjectionTypeConverter {
        public int string2intPrimitive(String v) throws HopValueException {
            return ValueMetaBase.getType((String)v);
        }
    }
}

