/*
 * Decompiled with CFR 0.152.
 */
package io.github.spannm.jackcess.impl.complex;

import io.github.spannm.jackcess.Column;
import io.github.spannm.jackcess.Row;
import io.github.spannm.jackcess.Table;
import io.github.spannm.jackcess.complex.ComplexDataType;
import io.github.spannm.jackcess.complex.ComplexValue;
import io.github.spannm.jackcess.complex.ComplexValueForeignKey;
import io.github.spannm.jackcess.complex.MultiValueColumnInfo;
import io.github.spannm.jackcess.complex.SingleValue;
import io.github.spannm.jackcess.impl.complex.ComplexColumnInfoImpl;
import java.io.IOException;

public class MultiValueColumnInfoImpl
extends ComplexColumnInfoImpl<SingleValue>
implements MultiValueColumnInfo {
    private final Column valueCol = this.getTypeColumns().get(0);

    public MultiValueColumnInfoImpl(Column column, int complexId, Table typeObjTable, Table flatTable) throws IOException {
        super(column, complexId, typeObjTable, flatTable);
    }

    @Override
    public ComplexDataType getType() {
        return ComplexDataType.MULTI_VALUE;
    }

    public Column getValueColumn() {
        return this.valueCol;
    }

    @Override
    protected SingleValueImpl toValue(ComplexValueForeignKey complexValueFk, Row rawValue) {
        ComplexColumnInfoImpl.ComplexValueIdImpl id = this.getValueId(rawValue);
        Object value = this.getValueColumn().getRowValue(rawValue);
        return new SingleValueImpl(id, complexValueFk, value);
    }

    @Override
    protected Object[] asRow(Object[] row, SingleValue value) throws IOException {
        super.asRow(row, value);
        this.getValueColumn().setRowValue(row, value.get());
        return row;
    }

    public static SingleValue newSingleValue(Object value) {
        return MultiValueColumnInfoImpl.newSingleValue(INVALID_FK, value);
    }

    public static SingleValue newSingleValue(ComplexValueForeignKey complexValueFk, Object value) {
        return new SingleValueImpl(INVALID_ID, complexValueFk, value);
    }

    private static class SingleValueImpl
    extends ComplexColumnInfoImpl.ComplexValueImpl
    implements SingleValue {
        private Object _value;

        private SingleValueImpl(ComplexValue.Id id, ComplexValueForeignKey complexValueFk, Object value) {
            super(id, complexValueFk);
            this._value = value;
        }

        @Override
        public Object get() {
            return this._value;
        }

        @Override
        public void set(Object value) {
            this._value = value;
        }

        @Override
        public void update() throws IOException {
            this.getComplexValueForeignKey().updateMultiValue(this);
        }

        @Override
        public void delete() throws IOException {
            this.getComplexValueForeignKey().deleteMultiValue(this);
        }

        public String toString() {
            return "SingleValue(" + this.getComplexValueForeignKey() + "," + this.getId() + ") " + this.get();
        }
    }
}

