/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire.internal;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0003J\u0010\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u0003H\u0002J\u0006\u0010\r\u001a\u00020\u000eJ\u0006\u0010\u000f\u001a\u00020\u0006J\b\u0010\u0010\u001a\u00020\u0011H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/squareup/wire/internal/IntArrayList;", "", "initialCapacity", "", "(I)V", "data", "", "size", "add", "", "int", "ensureCapacity", "minCapacity", "isNotEmpty", "", "toArray", "toString", "", "Companion", "wire-runtime"})
public final class IntArrayList {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private int[] data;
    private int size;

    public IntArrayList(int initialCapacity) {
        this.data = new int[initialCapacity];
    }

    @NotNull
    public final int[] toArray() {
        if (this.size < this.data.length) {
            int[] nArray = Arrays.copyOf(this.data, this.size);
            Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"copyOf(this, newSize)");
            this.data = nArray;
        }
        return this.data;
    }

    public final void add(int n) {
        this.ensureCapacity(this.size + 1);
        int n2 = this.size;
        this.size = n2 + 1;
        this.data[n2] = n;
    }

    public final boolean isNotEmpty() {
        return this.size > 0;
    }

    private final void ensureCapacity(int minCapacity) {
        if (minCapacity > this.data.length) {
            int[] nArray = Arrays.copyOf(this.data, Math.max(this.data.length * 3 / 2 + 1, minCapacity));
            Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"copyOf(this, newSize)");
            this.data = nArray;
        }
    }

    @NotNull
    public String toString() {
        int[] nArray = Arrays.copyOf(this.data, this.size);
        Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"copyOf(this, newSize)");
        String string = Arrays.toString(nArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(this)");
        return string;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006\u00a8\u0006\b"}, d2={"Lcom/squareup/wire/internal/IntArrayList$Companion;", "", "()V", "forDecoding", "Lcom/squareup/wire/internal/IntArrayList;", "minLengthInBytes", "", "minimumElementByteSize", "wire-runtime"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final IntArrayList forDecoding(long minLengthInBytes, long minimumElementByteSize) {
            int minElements = (int)RangesKt.coerceAtMost((long)(minLengthInBytes / minimumElementByteSize), (long)Integer.MAX_VALUE);
            return new IntArrayList(minElements);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

