/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2.internal;

import com.google.api.core.InternalApi;
import com.google.cloud.bigtable.data.v2.models.sql.ColumnMetadata;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@InternalApi
public abstract class ColumnToIndexMapper {
    private static final int AMBIGUOUS_FIELD_MARKER = -1;
    private Map<String, Integer> columnNameMapping;

    protected ColumnToIndexMapper(List<? extends ColumnMetadata> columns) {
        this.columnNameMapping = this.buildColumnNameMapping(columns);
    }

    public int getColumnIndex(String columnName) {
        Integer index = this.columnNameMapping.get(columnName);
        if (index == null) {
            throw new IllegalArgumentException("Column name not found: " + columnName);
        }
        int unboxedIndex = index;
        if (unboxedIndex == -1) {
            throw new IllegalArgumentException("Ambiguous column name: " + columnName + ". Same name is used for multiple columns.");
        }
        return unboxedIndex;
    }

    private Map<String, Integer> buildColumnNameMapping(List<? extends ColumnMetadata> columns) {
        HashMap<String, Integer> mapping = new HashMap<String, Integer>(columns.size());
        for (int i = 0; i < columns.size(); ++i) {
            String columnName = columns.get(i).name();
            if (mapping.containsKey(columnName)) {
                mapping.put(columnName, -1);
                continue;
            }
            mapping.put(columnName, i);
        }
        return ImmutableMap.copyOf(mapping);
    }
}

