/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.hcatalog;

import com.google.auto.value.AutoValue;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.io.BoundedSource;
import org.apache.beam.sdk.io.hadoop.WritableCoder;
import org.apache.beam.sdk.io.hcatalog.AutoValue_HCatalogIO_Read;
import org.apache.beam.sdk.io.hcatalog.AutoValue_HCatalogIO_Write;
import org.apache.beam.sdk.io.hcatalog.HCatalogUtils;
import org.apache.beam.sdk.io.hcatalog.PartitionPollerFn;
import org.apache.beam.sdk.io.hcatalog.PartitionReaderFn;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.Watch;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.util.SerializableUtils;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PDone;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.stats.StatsUtils;
import org.apache.hive.hcatalog.common.HCatException;
import org.apache.hive.hcatalog.common.HCatUtil;
import org.apache.hive.hcatalog.data.DefaultHCatRecord;
import org.apache.hive.hcatalog.data.HCatRecord;
import org.apache.hive.hcatalog.data.transfer.DataTransferFactory;
import org.apache.hive.hcatalog.data.transfer.HCatReader;
import org.apache.hive.hcatalog.data.transfer.HCatWriter;
import org.apache.hive.hcatalog.data.transfer.ReadEntity;
import org.apache.hive.hcatalog.data.transfer.ReaderContext;
import org.apache.hive.hcatalog.data.transfer.WriteEntity;
import org.apache.hive.hcatalog.data.transfer.WriterContext;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HCatalogIO {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(HCatalogIO.class);
    private static final @UnknownKeyFor @NonNull @Initialized long BATCH_SIZE = 1024L;
    private static final @UnknownKeyFor @NonNull @Initialized String DEFAULT_DATABASE = "default";

    public static @UnknownKeyFor @NonNull @Initialized Write write() {
        return new AutoValue_HCatalogIO_Write.Builder().setBatchSize(1024L).build();
    }

    public static @UnknownKeyFor @NonNull @Initialized Read read() {
        return new AutoValue_HCatalogIO_Read.Builder().setDatabase(DEFAULT_DATABASE).setPartitionCols(new ArrayList<String>()).build();
    }

    private HCatalogIO() {
    }

    @AutoValue
    public static abstract class Write
    extends PTransform<PCollection<HCatRecord>, PDone> {
        abstract @Nullable @UnknownKeyFor @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> getConfigProperties();

        abstract @Nullable @UnknownKeyFor @Initialized String getDatabase();

        abstract @Nullable @UnknownKeyFor @Initialized String getTable();

        abstract @Nullable @UnknownKeyFor @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> getPartition();

        abstract @UnknownKeyFor @NonNull @Initialized long getBatchSize();

        abstract @UnknownKeyFor @NonNull @Initialized Builder toBuilder();

        public @UnknownKeyFor @NonNull @Initialized Write withConfigProperties(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> configProperties) {
            return this.toBuilder().setConfigProperties(new HashMap<String, String>(configProperties)).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write withDatabase(@UnknownKeyFor @NonNull @Initialized String database) {
            return this.toBuilder().setDatabase(database).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write withTable(@UnknownKeyFor @NonNull @Initialized String table) {
            return this.toBuilder().setTable(table).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write withPartition(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> partition) {
            return this.toBuilder().setPartition(partition).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write withBatchSize(@UnknownKeyFor @NonNull @Initialized long batchSize) {
            return this.toBuilder().setBatchSize(batchSize).build();
        }

        public @UnknownKeyFor @NonNull @Initialized PDone expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized HCatRecord> input) {
            Preconditions.checkArgument((this.getConfigProperties() != null ? 1 : 0) != 0, (Object)"withConfigProperties() is required");
            Preconditions.checkArgument((this.getTable() != null ? 1 : 0) != 0, (Object)"withTable() is required");
            input.apply((PTransform)ParDo.of((DoFn)new WriteFn(this)));
            return PDone.in((Pipeline)input.getPipeline());
        }

        private static class WriteFn
        extends DoFn<HCatRecord, Void> {
            private final @UnknownKeyFor @NonNull @Initialized Write spec;
            private @UnknownKeyFor @NonNull @Initialized WriterContext writerContext;
            private @UnknownKeyFor @NonNull @Initialized HCatWriter slaveWriter;
            private @UnknownKeyFor @NonNull @Initialized HCatWriter masterWriter;
            private @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized HCatRecord> hCatRecordsBatch;

            WriteFn(@UnknownKeyFor @NonNull @Initialized Write spec) {
                this.spec = spec;
            }

            public void populateDisplayData(// Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @NonNull @Initialized DisplayData.Builder builder) {
                super.populateDisplayData(builder);
                builder.addIfNotNull(DisplayData.item((String)"database", (String)this.spec.getDatabase()));
                builder.add(DisplayData.item((String)"table", (String)this.spec.getTable()));
                builder.addIfNotNull(DisplayData.item((String)"partition", (String)String.valueOf(this.spec.getPartition())));
                builder.add(DisplayData.item((String)"configProperties", (String)this.spec.getConfigProperties().toString()));
                builder.add(DisplayData.item((String)"batchSize", (Long)this.spec.getBatchSize()));
            }

            @DoFn.Setup
            public void initiateWrite() throws @UnknownKeyFor @NonNull @Initialized HCatException {
                WriteEntity entity = new WriteEntity.Builder().withDatabase(this.spec.getDatabase()).withTable(this.spec.getTable()).withPartition(this.spec.getPartition()).build();
                this.masterWriter = DataTransferFactory.getHCatWriter((WriteEntity)entity, this.spec.getConfigProperties());
                this.writerContext = this.masterWriter.prepareWrite();
                this.slaveWriter = DataTransferFactory.getHCatWriter((WriterContext)this.writerContext);
            }

            @DoFn.StartBundle
            public void startBundle() {
                this.hCatRecordsBatch = new ArrayList<HCatRecord>();
            }

            @DoFn.ProcessElement
            public void processElement(/*
             * Issues handling annotations - annotations may be inaccurate
             */
            // Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext ctx) throws @UnknownKeyFor @NonNull @Initialized HCatException {
                this.hCatRecordsBatch.add((HCatRecord)ctx.element());
                if ((long)this.hCatRecordsBatch.size() >= this.spec.getBatchSize()) {
                    this.flush();
                }
            }

            @DoFn.FinishBundle
            public void finishBundle() throws @UnknownKeyFor @NonNull @Initialized HCatException {
                this.flush();
            }

            private void flush() throws @UnknownKeyFor @NonNull @Initialized HCatException {
                if (this.hCatRecordsBatch.isEmpty()) {
                    return;
                }
                try {
                    this.slaveWriter.write(this.hCatRecordsBatch.iterator());
                    this.masterWriter.commit(this.writerContext);
                }
                catch (HCatException e) {
                    LOG.error("Exception in flush - write/commit data to Hive", (Throwable)e);
                    this.masterWriter.abort(this.writerContext);
                    throw e;
                }
                finally {
                    this.hCatRecordsBatch.clear();
                }
            }

            @DoFn.Teardown
            public void tearDown() {
                if (this.slaveWriter != null) {
                    this.slaveWriter = null;
                }
                if (this.masterWriter != null) {
                    this.masterWriter = null;
                }
                if (this.writerContext != null) {
                    this.writerContext = null;
                }
            }
        }

        @AutoValue.Builder
        static abstract class Builder {
            Builder() {
            }

            abstract @UnknownKeyFor @NonNull @Initialized Builder setConfigProperties(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setDatabase(@UnknownKeyFor @NonNull @Initialized String var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setTable(@UnknownKeyFor @NonNull @Initialized String var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setPartition(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setBatchSize(@UnknownKeyFor @NonNull @Initialized long var1);

            abstract @UnknownKeyFor @NonNull @Initialized Write build();
        }
    }

    @VisibleForTesting
    static class BoundedHCatalogSource
    extends BoundedSource<HCatRecord> {
        private final @UnknownKeyFor @NonNull @Initialized Read spec;

        BoundedHCatalogSource(@UnknownKeyFor @NonNull @Initialized Read spec) {
            this.spec = spec;
        }

        public @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized HCatRecord> getOutputCoder() {
            return WritableCoder.of(DefaultHCatRecord.class);
        }

        public void populateDisplayData(// Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized DisplayData.Builder builder) {
            this.spec.populateDisplayData(builder);
        }

        public // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized BoundedSource.BoundedReader<@UnknownKeyFor @NonNull @Initialized HCatRecord> createReader(@UnknownKeyFor @NonNull @Initialized PipelineOptions options) {
            return new BoundedHCatalogReader(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public @UnknownKeyFor @NonNull @Initialized long getEstimatedSizeBytes(@UnknownKeyFor @NonNull @Initialized PipelineOptions pipelineOptions) throws @UnknownKeyFor @NonNull @Initialized Exception {
            try (IMetaStoreClient client = null;){
                HiveConf hiveConf = HCatalogUtils.createHiveConf(this.spec);
                client = HCatalogUtils.createMetaStoreClient((Configuration)hiveConf);
                Table table = HCatUtil.getTable((IMetaStoreClient)client, (String)this.spec.getDatabase(), (String)this.spec.getTable());
                long l = StatsUtils.getFileSizeForTable((HiveConf)hiveConf, (Table)table);
                return l;
            }
        }

        public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized BoundedSource<@UnknownKeyFor @NonNull @Initialized HCatRecord>> split(@UnknownKeyFor @NonNull @Initialized long desiredBundleSizeBytes, @UnknownKeyFor @NonNull @Initialized PipelineOptions options) throws @UnknownKeyFor @NonNull @Initialized Exception {
            int desiredSplitCount = 1;
            long estimatedSizeBytes = this.getEstimatedSizeBytes(options);
            if (desiredBundleSizeBytes > 0L && estimatedSizeBytes > 0L) {
                desiredSplitCount = (int)Math.ceil((double)estimatedSizeBytes / (double)desiredBundleSizeBytes);
            }
            ReaderContext readerContext = this.getReaderContext(desiredSplitCount);
            LOG.info("Splitting into bundles of {} bytes: estimated size {}, desired split count {}, actual split count {}", new Object[]{desiredBundleSizeBytes, estimatedSizeBytes, desiredSplitCount, readerContext.numSplits()});
            ArrayList<BoundedSource<HCatRecord>> res = new ArrayList<BoundedSource<HCatRecord>>();
            for (int split = 0; split < readerContext.numSplits(); ++split) {
                res.add(new BoundedHCatalogSource(this.spec.withContext(readerContext).withSplitId(split)));
            }
            return res;
        }

        private @UnknownKeyFor @NonNull @Initialized ReaderContext getReaderContext(@UnknownKeyFor @NonNull @Initialized long desiredSplitCount) throws @UnknownKeyFor @NonNull @Initialized HCatException {
            ReadEntity entity = new ReadEntity.Builder().withDatabase(this.spec.getDatabase()).withTable(this.spec.getTable()).withFilter(this.spec.getFilter()).build();
            HashMap<String, String> configProps = new HashMap<String, String>(this.spec.getConfigProperties());
            configProps.put("hcat.desired.partition.num.splits", String.valueOf(desiredSplitCount));
            return DataTransferFactory.getHCatReader((ReadEntity)entity, configProps).prepareRead();
        }

        static class BoundedHCatalogReader
        extends BoundedSource.BoundedReader<HCatRecord> {
            private final @UnknownKeyFor @NonNull @Initialized BoundedHCatalogSource source;
            private @UnknownKeyFor @NonNull @Initialized HCatRecord current;
            private @UnknownKeyFor @NonNull @Initialized Iterator<@UnknownKeyFor @NonNull @Initialized HCatRecord> hcatIterator;

            BoundedHCatalogReader(@UnknownKeyFor @NonNull @Initialized BoundedHCatalogSource source) {
                this.source = source;
            }

            public @UnknownKeyFor @NonNull @Initialized boolean start() throws @UnknownKeyFor @NonNull @Initialized HCatException {
                HCatReader reader = DataTransferFactory.getHCatReader((ReaderContext)this.source.spec.getContext(), (int)this.source.spec.getSplitId());
                this.hcatIterator = reader.read();
                return this.advance();
            }

            public @UnknownKeyFor @NonNull @Initialized boolean advance() {
                if (this.hcatIterator.hasNext()) {
                    this.current = this.hcatIterator.next();
                    return true;
                }
                this.current = null;
                return false;
            }

            public @UnknownKeyFor @NonNull @Initialized BoundedHCatalogSource getCurrentSource() {
                return this.source;
            }

            public @UnknownKeyFor @NonNull @Initialized HCatRecord getCurrent() {
                if (this.current == null) {
                    throw new NoSuchElementException("Current element is null");
                }
                return this.current;
            }

            public void close() {
            }
        }
    }

    @VisibleForTesting
    @AutoValue
    public static abstract class Read
    extends PTransform<PBegin, PCollection<HCatRecord>> {
        abstract @Nullable @UnknownKeyFor @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> getConfigProperties();

        abstract @Nullable @UnknownKeyFor @Initialized String getDatabase();

        abstract @Nullable @UnknownKeyFor @Initialized String getTable();

        abstract @Nullable @UnknownKeyFor @Initialized String getFilter();

        @Nullable @UnknownKeyFor @Initialized ReaderContext getContext() {
            if (this.getContextHolder() == null) {
                return null;
            }
            return this.getContextHolder().get();
        }

        abstract @Nullable @UnknownKeyFor @Initialized ReaderContextHolder getContextHolder();

        abstract @Nullable @UnknownKeyFor @Initialized Integer getSplitId();

        abstract @Nullable @UnknownKeyFor @Initialized Duration getPollingInterval();

        abstract @Nullable @UnknownKeyFor @Initialized List<@UnknownKeyFor @NonNull @Initialized String> getPartitionCols();

        abstract /*
         * Issues handling annotations - annotations may be inaccurate
         */
        // Could not load outer class - annotation placement on inner may be incorrect
        @Nullable @UnknownKeyFor @Initialized Watch.Growth.TerminationCondition<@UnknownKeyFor @NonNull @Initialized Read, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> getTerminationCondition();

        abstract @UnknownKeyFor @NonNull @Initialized Builder toBuilder();

        public @UnknownKeyFor @NonNull @Initialized Read withConfigProperties(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> configProperties) {
            return this.toBuilder().setConfigProperties(new HashMap<String, String>(configProperties)).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read withDatabase(@UnknownKeyFor @NonNull @Initialized String database) {
            return this.toBuilder().setDatabase(database).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read withTable(@UnknownKeyFor @NonNull @Initialized String table) {
            return this.toBuilder().setTable(table).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read withFilter(@UnknownKeyFor @NonNull @Initialized String filter) {
            return this.toBuilder().setFilter(filter).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read withPollingInterval(@UnknownKeyFor @NonNull @Initialized Duration pollingInterval) {
            return this.toBuilder().setPollingInterval(pollingInterval).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read withPartitionCols(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> partitionCols) {
            return this.toBuilder().setPartitionCols(partitionCols).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read withTerminationCondition(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized Watch.Growth.TerminationCondition<@UnknownKeyFor @NonNull @Initialized Read, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> terminationCondition) {
            return this.toBuilder().setTerminationCondition(terminationCondition).build();
        }

        @UnknownKeyFor @NonNull @Initialized Read withSplitId(@UnknownKeyFor @NonNull @Initialized int splitId) {
            Preconditions.checkArgument((splitId >= 0 ? 1 : 0) != 0, (Object)("Invalid split id-" + splitId));
            return this.toBuilder().setSplitId(splitId).build();
        }

        @UnknownKeyFor @NonNull @Initialized Read withContext(@UnknownKeyFor @NonNull @Initialized ReaderContext context) {
            return this.toBuilder().setContext(context).build();
        }

        public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized HCatRecord> expand(@UnknownKeyFor @NonNull @Initialized PBegin input) {
            Preconditions.checkArgument((this.getTable() != null ? 1 : 0) != 0, (Object)"withTable() is required");
            Preconditions.checkArgument((this.getConfigProperties() != null ? 1 : 0) != 0, (Object)"withConfigProperties() is required");
            if (this.getPollingInterval() != null) {
                Watch.Growth growthFn = Watch.growthOf((Watch.Growth.PollFn)new PartitionPollerFn()).withPollInterval(this.getPollingInterval());
                if (this.getTerminationCondition() != null) {
                    growthFn = growthFn.withTerminationPerInput(this.getTerminationCondition());
                }
                return (PCollection)((PCollection)((PCollection)input.apply("ConvertToReadRequest", (PTransform)Create.of((Object)((Object)this), (Object[])new Read[0]))).apply("WatchForNewPartitions", (PTransform)growthFn)).apply("PartitionReader", (PTransform)ParDo.of((DoFn)new PartitionReaderFn(this.getConfigProperties())));
            }
            Preconditions.checkArgument((this.getTerminationCondition() == null ? 1 : 0) != 0, (Object)"withTerminationCondition() is not required when using in bounded reads mode");
            return (PCollection)input.apply((PTransform)org.apache.beam.sdk.io.Read.from((BoundedSource)new BoundedHCatalogSource(this)));
        }

        public void populateDisplayData(// Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized DisplayData.Builder builder) {
            super.populateDisplayData(builder);
            builder.add(DisplayData.item((String)"configProperties", (String)this.getConfigProperties().toString()));
            builder.add(DisplayData.item((String)"table", (String)this.getTable()));
            builder.addIfNotNull(DisplayData.item((String)"database", (String)this.getDatabase()));
            builder.addIfNotNull(DisplayData.item((String)"filter", (String)this.getFilter()));
        }

        static class ReaderContextHolder
        implements Serializable {
            private final @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] serializedReaderContext;
            private transient @UnknownKeyFor @NonNull @Initialized ReaderContext readerContext;

            public ReaderContextHolder(@UnknownKeyFor @NonNull @Initialized ReaderContext readerContext) {
                this.serializedReaderContext = SerializableUtils.serializeToByteArray((Serializable)readerContext);
                this.readerContext = readerContext;
            }

            private @UnknownKeyFor @NonNull @Initialized ReaderContext get() {
                return this.readerContext;
            }

            private void readObject(@UnknownKeyFor @NonNull @Initialized ObjectInputStream in) throws @UnknownKeyFor @NonNull @Initialized IOException, @UnknownKeyFor @NonNull @Initialized ClassNotFoundException {
                in.defaultReadObject();
                this.readerContext = (ReaderContext)SerializableUtils.deserializeFromByteArray((byte[])this.serializedReaderContext, (String)"ReaderContext");
            }
        }

        @AutoValue.Builder
        static abstract class Builder {
            Builder() {
            }

            abstract @UnknownKeyFor @NonNull @Initialized Builder setConfigProperties(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setDatabase(@UnknownKeyFor @NonNull @Initialized String var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setTable(@UnknownKeyFor @NonNull @Initialized String var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setFilter(@UnknownKeyFor @NonNull @Initialized String var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setSplitId(@UnknownKeyFor @NonNull @Initialized Integer var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setContextHolder(@UnknownKeyFor @NonNull @Initialized ReaderContextHolder var1);

            @UnknownKeyFor @NonNull @Initialized Builder setContext(@UnknownKeyFor @NonNull @Initialized ReaderContext context) {
                return this.setContextHolder(new ReaderContextHolder(context));
            }

            abstract @UnknownKeyFor @NonNull @Initialized Builder setPollingInterval(@UnknownKeyFor @NonNull @Initialized Duration var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setPartitionCols(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setTerminationCondition(/*
             * Issues handling annotations - annotations may be inaccurate
             */
            // Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @NonNull @Initialized Watch.Growth.TerminationCondition<@UnknownKeyFor @NonNull @Initialized Read, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Read build();
        }
    }
}

