/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.api.client.util.BackOff;
import com.google.api.client.util.BackOffUtils;
import com.google.api.client.util.Sleeper;
import com.google.api.gax.rpc.ApiException;
import com.google.api.services.bigquery.model.BigLakeConfiguration;
import com.google.api.services.bigquery.model.Clustering;
import com.google.api.services.bigquery.model.EncryptionConfiguration;
import com.google.api.services.bigquery.model.Table;
import com.google.api.services.bigquery.model.TableConstraints;
import com.google.api.services.bigquery.model.TableReference;
import com.google.api.services.bigquery.model.TableSchema;
import com.google.api.services.bigquery.model.TimePartitioning;
import io.grpc.StatusRuntimeException;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.extensions.gcp.util.BackOffAdapter;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryHelpers;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryIO;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryOptions;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryServices;
import org.apache.beam.sdk.io.gcp.bigquery.TableDestination;
import org.apache.beam.sdk.io.gcp.bigquery.TableDestinationCoderV2;
import org.apache.beam.sdk.util.FluentBackoff;
import org.apache.beam.sdk.util.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.MoreObjects;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Strings;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Supplier;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Duration;

public class CreateTableHelpers {
    private static @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> createdTables = Collections.newSetFromMap(new ConcurrentHashMap());
    private static final @UnknownKeyFor @NonNull @Initialized Duration INITIAL_RPC_BACKOFF = Duration.millis((long)500L);
    private static final @UnknownKeyFor @NonNull @Initialized FluentBackoff DEFAULT_BACKOFF_FACTORY = FluentBackoff.DEFAULT.withMaxRetries(4).withInitialBackoff(INITIAL_RPC_BACKOFF);

    static void createTableWrapper(@UnknownKeyFor @NonNull @Initialized Callable<@UnknownKeyFor @Nullable @Initialized Void> action, @UnknownKeyFor @NonNull @Initialized Callable<@UnknownKeyFor @NonNull @Initialized Boolean> tryCreateTable) throws @UnknownKeyFor @NonNull @Initialized Exception {
        BackOff backoff = BackOffAdapter.toGcpBackOff((org.apache.beam.sdk.util.BackOff)DEFAULT_BACKOFF_FACTORY.backoff());
        Throwable lastException = null;
        while (true) {
            try {
                action.call();
                return;
            }
            catch (ApiException | StatusRuntimeException e) {
                lastException = e;
                boolean created = tryCreateTable.call();
                if (created) continue;
                throw e;
                if (BackOffUtils.next((Sleeper)Sleeper.DEFAULT, (BackOff)backoff)) continue;
                throw (RuntimeException)Preconditions.checkStateNotNull((Object)lastException);
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static @UnknownKeyFor @NonNull @Initialized TableDestination possiblyCreateTable(@UnknownKeyFor @NonNull @Initialized BigQueryOptions bigQueryOptions, @UnknownKeyFor @NonNull @Initialized TableDestination tableDestination, @UnknownKeyFor @NonNull @Initialized Supplier<@Nullable @UnknownKeyFor @Initialized TableSchema> schemaSupplier, @UnknownKeyFor @NonNull @Initialized Supplier<@Nullable @UnknownKeyFor @Initialized TableConstraints> tableConstraintsSupplier,  @UnknownKeyFor @NonNull @Initialized BigQueryIO.Write.CreateDisposition createDisposition, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Nullable @UnknownKeyFor @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> tableDestinationCoder, @Nullable @UnknownKeyFor @Initialized String kmsKey, @UnknownKeyFor @NonNull @Initialized BigQueryServices bqServices, @Nullable @UnknownKeyFor @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> bigLakeConfiguration) {
        org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkArgument((tableDestination.getTableSpec() != null ? 1 : 0) != 0, (String)"DynamicDestinations.getTable() must return a TableDestination with a non-null table spec, but %s has a null table spec", (Object)tableDestination);
        boolean destinationCoderSupportsClustering = !(tableDestinationCoder instanceof TableDestinationCoderV2);
        org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkArgument((tableDestination.getClustering() == null || destinationCoderSupportsClustering ? 1 : 0) != 0, (String)"DynamicDestinations.getTable() may only return destinations with clustering configured if a destination coder is supplied that supports clustering, but %s is configured to use TableDestinationCoderV2. Set withClustering() on BigQueryIO.write() and,  if you provided a custom DynamicDestinations instance, override getDestinationCoder() to return TableDestinationCoderV3.", (Object)tableDestination);
        TableReference tableReference = tableDestination.getTableReference().clone();
        if (Strings.isNullOrEmpty((String)tableReference.getProjectId())) {
            tableReference.setProjectId(bigQueryOptions.getProject());
            tableDestination = tableDestination.withTableReference(tableReference);
        }
        if (createDisposition == BigQueryIO.Write.CreateDisposition.CREATE_NEVER) {
            return tableDestination;
        }
        String tableSpec = BigQueryHelpers.stripPartitionDecorator(tableDestination.getTableSpec());
        if (!createdTables.contains(tableSpec)) {
            Set<String> set = createdTables;
            synchronized (set) {
                if (!createdTables.contains(tableSpec)) {
                    CreateTableHelpers.tryCreateTable(bigQueryOptions, schemaSupplier, tableConstraintsSupplier, tableDestination, createDisposition, tableSpec, kmsKey, bqServices, bigLakeConfiguration);
                }
            }
        }
        return tableDestination;
    }

    private static void tryCreateTable(@UnknownKeyFor @NonNull @Initialized BigQueryOptions options, @UnknownKeyFor @NonNull @Initialized Supplier<@Nullable @UnknownKeyFor @Initialized TableSchema> schemaSupplier, @UnknownKeyFor @NonNull @Initialized Supplier<@Nullable @UnknownKeyFor @Initialized TableConstraints> tableConstraintsSupplier, @UnknownKeyFor @NonNull @Initialized TableDestination tableDestination,  @UnknownKeyFor @NonNull @Initialized BigQueryIO.Write.CreateDisposition createDisposition, @UnknownKeyFor @NonNull @Initialized String tableSpec, @Nullable @UnknownKeyFor @Initialized String kmsKey, @UnknownKeyFor @NonNull @Initialized BigQueryServices bqServices, @Nullable @UnknownKeyFor @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> bigLakeConfiguration) {
        TableReference tableReference = tableDestination.getTableReference().clone();
        tableReference.setTableId(BigQueryHelpers.stripPartitionDecorator(tableReference.getTableId()));
        try (BigQueryServices.DatasetService datasetService = bqServices.getDatasetService(options);){
            if (datasetService.getTable(tableReference, Collections.emptyList(), BigQueryServices.DatasetService.TableMetadataView.BASIC) == null) {
                Clustering clustering;
                TimePartitioning timePartitioning;
                String tableDescription;
                TableSchema tableSchema = (TableSchema)schemaSupplier.get();
                @Nullable TableConstraints tableConstraints = (TableConstraints)tableConstraintsSupplier.get();
                Preconditions.checkArgumentNotNull((Object)tableSchema, (String)"Unless create disposition is %s, a schema must be specified, i.e. DynamicDestinations.getSchema() may not return null. However, create disposition is %s, and  %s returned null for destination %s", (Object)((Object)BigQueryIO.Write.CreateDisposition.CREATE_NEVER), (Object)((Object)createDisposition), (Object)tableDestination);
                Table table = new Table().setTableReference(tableReference).setSchema(tableSchema);
                if (tableConstraints != null) {
                    table = table.setTableConstraints(tableConstraints);
                }
                if ((tableDescription = tableDestination.getTableDescription()) != null) {
                    table = table.setDescription(tableDescription);
                }
                if ((timePartitioning = tableDestination.getTimePartitioning()) != null) {
                    table.setTimePartitioning(timePartitioning);
                }
                if ((clustering = tableDestination.getClustering()) != null) {
                    table.setClustering(clustering);
                }
                if (kmsKey != null) {
                    table.setEncryptionConfiguration(new EncryptionConfiguration().setKmsKeyName(kmsKey));
                }
                if (bigLakeConfiguration != null) {
                    TableReference ref = table.getTableReference();
                    table.setBiglakeConfiguration(new BigLakeConfiguration().setTableFormat((String)MoreObjects.firstNonNull((Object)bigLakeConfiguration.get("tableFormat"), (Object)"iceberg")).setFileFormat((String)MoreObjects.firstNonNull((Object)bigLakeConfiguration.get("fileFormat"), (Object)"parquet")).setConnectionId((String)Preconditions.checkArgumentNotNull((Object)bigLakeConfiguration.get("connectionId"))).setStorageUri(String.format("%s/%s/%s/%s", Preconditions.checkArgumentNotNull((Object)bigLakeConfiguration.get("storageUri")), ref.getProjectId(), ref.getDatasetId(), ref.getTableId())));
                }
                datasetService.createTable(table);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        createdTables.add(tableSpec);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    static void clearCreatedTables() {
        Set<String> set = createdTables;
        synchronized (set) {
            createdTables.clear();
        }
    }
}

