/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigtable.changestreams.action;

import com.google.cloud.bigtable.data.v2.models.Range;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.io.gcp.bigtable.changestreams.ChangeStreamMetrics;
import org.apache.beam.sdk.io.gcp.bigtable.changestreams.UniqueIdGenerator;
import org.apache.beam.sdk.io.gcp.bigtable.changestreams.dao.ChangeStreamDao;
import org.apache.beam.sdk.io.gcp.bigtable.changestreams.model.PartitionRecord;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Instant;

@Internal
public class GenerateInitialPartitionsAction {
    private final @UnknownKeyFor @NonNull @Initialized ChangeStreamMetrics metrics;
    private final @UnknownKeyFor @NonNull @Initialized ChangeStreamDao changeStreamDao;
    @Nullable
    private final @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Instant endTime;

    public GenerateInitialPartitionsAction(@UnknownKeyFor @NonNull @Initialized ChangeStreamMetrics metrics, @UnknownKeyFor @NonNull @Initialized ChangeStreamDao changeStreamDao, @Nullable @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Instant endTime) {
        this.metrics = metrics;
        this.changeStreamDao = changeStreamDao;
        this.endTime = endTime;
    }

    public void run(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized DoFn.OutputReceiver<@UnknownKeyFor @NonNull @Initialized PartitionRecord> receiver, @UnknownKeyFor @NonNull @Initialized Instant startTime) {
        List<Range.ByteStringRange> streamPartitions = this.changeStreamDao.generateInitialChangeStreamPartitions();
        for (Range.ByteStringRange partition : streamPartitions) {
            this.metrics.incListPartitionsCount();
            String uid = UniqueIdGenerator.getNextId();
            PartitionRecord partitionRecord = new PartitionRecord(partition, startTime, uid, startTime, Collections.emptyList(), this.endTime);
            receiver.outputWithTimestamp((Object)partitionRecord, Instant.EPOCH);
        }
    }
}

