/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigtable.changestreams.restriction;

import com.google.cloud.bigtable.data.v2.models.ChangeStreamContinuationToken;
import com.google.cloud.bigtable.data.v2.models.CloseStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Objects;
import org.apache.beam.sdk.annotations.Internal;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.joda.time.Instant;

@Internal
public class StreamProgress
implements Serializable {
    private static final @UnknownKeyFor @NonNull @Initialized long serialVersionUID = -5384329262726188695L;
    private @Nullable @UnknownKeyFor @Initialized ChangeStreamContinuationToken currentToken;
    private @Nullable @UnknownKeyFor @Initialized Instant estimatedLowWatermark;
    private @Nullable @UnknownKeyFor @Initialized BigDecimal throughputEstimate;
    private @Nullable @UnknownKeyFor @Initialized Instant lastRunTimestamp;
    private @Nullable @UnknownKeyFor @Initialized CloseStream closeStream;
    private @UnknownKeyFor @NonNull @Initialized boolean failToLock;
    private @UnknownKeyFor @NonNull @Initialized boolean isHeartbeat;

    public StreamProgress() {
    }

    public StreamProgress(@Nullable @UnknownKeyFor @Initialized ChangeStreamContinuationToken token, @UnknownKeyFor @NonNull @Initialized Instant estimatedLowWatermark, @UnknownKeyFor @NonNull @Initialized BigDecimal throughputEstimate, @UnknownKeyFor @NonNull @Initialized Instant lastRunTimestamp, @UnknownKeyFor @NonNull @Initialized boolean isHeartbeat) {
        this.currentToken = token;
        this.estimatedLowWatermark = estimatedLowWatermark;
        this.throughputEstimate = throughputEstimate;
        this.lastRunTimestamp = lastRunTimestamp;
        this.isHeartbeat = isHeartbeat;
    }

    public StreamProgress(@Nullable @UnknownKeyFor @Initialized CloseStream closeStream) {
        this.closeStream = closeStream;
    }

    public @Nullable @UnknownKeyFor @Initialized ChangeStreamContinuationToken getCurrentToken() {
        return this.currentToken;
    }

    public @Nullable @UnknownKeyFor @Initialized Instant getEstimatedLowWatermark() {
        return this.estimatedLowWatermark;
    }

    public @Nullable @UnknownKeyFor @Initialized BigDecimal getThroughputEstimate() {
        return this.throughputEstimate;
    }

    public @Nullable @UnknownKeyFor @Initialized Instant getLastRunTimestamp() {
        return this.lastRunTimestamp;
    }

    public @Nullable @UnknownKeyFor @Initialized CloseStream getCloseStream() {
        return this.closeStream;
    }

    public @UnknownKeyFor @NonNull @Initialized boolean isFailToLock() {
        return this.failToLock;
    }

    public void setFailToLock(@UnknownKeyFor @NonNull @Initialized boolean failToLock) {
        this.failToLock = failToLock;
    }

    public @UnknownKeyFor @NonNull @Initialized boolean isHeartbeat() {
        return this.isHeartbeat;
    }

    public @UnknownKeyFor @NonNull @Initialized boolean isEmpty() {
        return this.closeStream == null && this.currentToken == null;
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof StreamProgress)) {
            return false;
        }
        StreamProgress that = (StreamProgress)o;
        return Objects.equals(this.getCurrentToken(), that.getCurrentToken()) && Objects.equals(this.getEstimatedLowWatermark(), that.getEstimatedLowWatermark()) && Objects.equals(this.getCloseStream(), that.getCloseStream()) && this.isFailToLock() == that.isFailToLock() && Objects.equals(this.getThroughputEstimate(), that.getThroughputEstimate()) && Objects.equals(this.getLastRunTimestamp(), that.getLastRunTimestamp()) && this.isHeartbeat() == that.isHeartbeat();
    }

    @Pure
    public @UnknownKeyFor @NonNull @Initialized int hashCode() {
        return Objects.hash(this.getCurrentToken(), this.getCloseStream());
    }

    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        return "StreamProgress{currentToken=" + this.currentToken + ", estimatedLowWatermark=" + this.estimatedLowWatermark + ", closeStream=" + this.closeStream + ", failToLock=" + this.failToLock + ", throughputEstimate=" + this.throughputEstimate + ", lastRunTimestamp=" + this.lastRunTimestamp + ", isHeartbeat=" + this.isHeartbeat + '}';
    }
}

