/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.pubsub;

import com.google.api.client.util.Clock;
import com.google.auto.value.AutoValue;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.beam.sdk.io.gcp.pubsub.AutoValue_PubsubReadSchemaTransformConfiguration;
import org.apache.beam.sdk.io.gcp.pubsub.AutoValue_PubsubReadSchemaTransformConfiguration_ErrorHandling;
import org.apache.beam.sdk.schemas.AutoValueSchema;
import org.apache.beam.sdk.schemas.annotations.DefaultSchema;
import org.apache.beam.sdk.schemas.annotations.SchemaFieldDescription;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

@DefaultSchema(value=AutoValueSchema.class)
@AutoValue
public abstract class PubsubReadSchemaTransformConfiguration {
    @SchemaFieldDescription(value="The name of the topic to consume data from. If a topic is specified,  will create a new subscription for that topic and start consuming from that point. Either a topic or a subscription must be provided. Format: projects/${PROJECT}/topics/${TOPIC}")
    @Nullable
    public abstract @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized String getTopic();

    @SchemaFieldDescription(value="The name of the subscription to consume data. Either a topic or subscription must be provided. Format: projects/${PROJECT}/subscriptions/${SUBSCRIPTION}")
    @Nullable
    public abstract @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized String getSubscription();

    @SchemaFieldDescription(value="The encoding format for the data stored in Pubsub. Valid options are: RAW,AVRO,JSON")
    public abstract @UnknownKeyFor @NonNull @Initialized String getFormat();

    @SchemaFieldDescription(value="The schema in which the data is encoded in the Pubsub topic. For AVRO data, this is a schema defined with AVRO schema syntax (https://avro.apache.org/docs/1.10.2/spec.html#schemas). For JSON data, this is a schema defined with JSON-schema syntax (https://json-schema.org/).")
    public abstract @UnknownKeyFor @NonNull @Initialized String getSchema();

    @SchemaFieldDescription(value="Any additional pubsub attributes that should be populated as String fields in the ouptut rows.")
    @Nullable
    public abstract @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized List<@UnknownKeyFor @NonNull @Initialized String> getAttributes();

    @SchemaFieldDescription(value="Any additional field that should be populated with the full set of PubSub attributes.")
    @Nullable
    public abstract @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized String getAttributesMap();

    @SchemaFieldDescription(value="When reading from Cloud Pub/Sub where unique record identifiers are provided as Pub/Sub message attributes, specifies the name of the attribute containing the unique identifier. The value of the attribute can be any string that uniquely identifies this record. Pub/Sub cannot guarantee that no duplicate data will be delivered on the Pub/Sub stream. If idAttribute is not provided, Beam cannot guarantee that no duplicate data will be delivered, and deduplication of the stream will be strictly best effort.")
    @Nullable
    public abstract @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized String getIdAttribute();

    @SchemaFieldDescription(value="Specifies the name of the attribute that contains the timestamp, if any. The timestamp value is expected to be represented in the attribute as either (1) a numerical value representing the number of milliseconds since the Unix epoch. For example, if using the Joda time classes, Instant.getMillis() returns the correct value for this attribute. or (2) a String in RFC 3339 format. For example, 2015-10-29T23:41:41.123Z. The sub-second component of the timestamp is optional, and digits beyond the first three (i.e., time units smaller than milliseconds) will be ignored.")
    @Nullable
    public abstract @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized String getTimestampAttribute();

    @SchemaFieldDescription(value="Specifies how to handle errors.")
    @Nullable
    public abstract @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized ErrorHandling getErrorHandling();

    @Nullable
    public abstract  @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized PubsubTestClient.PubsubTestClientFactory getClientFactory();

    @Nullable
    public abstract @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Clock getClock();

    public static @UnknownKeyFor @NonNull @Initialized Builder builder() {
        return new AutoValue_PubsubReadSchemaTransformConfiguration.Builder();
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract @UnknownKeyFor @NonNull @Initialized Builder setTopic(@Nullable @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized String var1);

        public abstract @UnknownKeyFor @NonNull @Initialized Builder setSubscription(@Nullable @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized String var1);

        public abstract @UnknownKeyFor @NonNull @Initialized Builder setFormat(@UnknownKeyFor @NonNull @Initialized String var1);

        public abstract @UnknownKeyFor @NonNull @Initialized Builder setSchema(@UnknownKeyFor @NonNull @Initialized String var1);

        public abstract @UnknownKeyFor @NonNull @Initialized Builder setAttributes(@Nullable @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized List<@UnknownKeyFor @NonNull @Initialized String> var1);

        public abstract @UnknownKeyFor @NonNull @Initialized Builder setAttributesMap(@Nullable @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized String var1);

        public abstract @UnknownKeyFor @NonNull @Initialized Builder setIdAttribute(@Nullable @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized String var1);

        public abstract @UnknownKeyFor @NonNull @Initialized Builder setTimestampAttribute(@Nullable @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized String var1);

        public abstract @UnknownKeyFor @NonNull @Initialized Builder setErrorHandling(@Nullable @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized ErrorHandling var1);

        public abstract @UnknownKeyFor @NonNull @Initialized Builder setClientFactory(@Nullable  @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized PubsubTestClient.PubsubTestClientFactory var1);

        public abstract @UnknownKeyFor @NonNull @Initialized Builder setClock(@Nullable @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Clock var1);

        public abstract @UnknownKeyFor @NonNull @Initialized PubsubReadSchemaTransformConfiguration build();
    }

    @AutoValue
    public static abstract class ErrorHandling {
        @SchemaFieldDescription(value="The name of the output PCollection containing failed reads.")
        public abstract @UnknownKeyFor @NonNull @Initialized String getOutput();

        public static @UnknownKeyFor @NonNull @Initialized Builder builder() {
            return new AutoValue_PubsubReadSchemaTransformConfiguration_ErrorHandling.Builder();
        }

        @AutoValue.Builder
        public static abstract class Builder {
            public abstract @UnknownKeyFor @NonNull @Initialized Builder setOutput(@UnknownKeyFor @NonNull @Initialized String var1);

            public abstract @UnknownKeyFor @NonNull @Initialized ErrorHandling build();
        }
    }
}

