/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.pubsublite.internal;

import com.google.api.gax.rpc.ApiException;
import com.google.cloud.pubsublite.Offset;
import com.google.cloud.pubsublite.Partition;
import com.google.cloud.pubsublite.TopicPath;
import com.google.cloud.pubsublite.internal.ExtractStatus;
import com.google.cloud.pubsublite.internal.TopicStatsClient;
import com.google.cloud.pubsublite.proto.ComputeMessageStatsResponse;
import java.util.concurrent.TimeUnit;
import org.apache.beam.sdk.io.gcp.pubsublite.internal.TopicBacklogReader;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

final class TopicBacklogReaderImpl
implements TopicBacklogReader {
    private final @UnknownKeyFor @NonNull @Initialized TopicStatsClient client;
    private final @UnknownKeyFor @NonNull @Initialized TopicPath topicPath;
    private final @UnknownKeyFor @NonNull @Initialized Partition partition;

    public TopicBacklogReaderImpl(@UnknownKeyFor @NonNull @Initialized TopicStatsClient client, @UnknownKeyFor @NonNull @Initialized TopicPath topicPath, @UnknownKeyFor @NonNull @Initialized Partition partition) {
        this.client = client;
        this.topicPath = topicPath;
        this.partition = partition;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized ComputeMessageStatsResponse computeMessageStats(@UnknownKeyFor @NonNull @Initialized Offset offset) throws @UnknownKeyFor @NonNull @Initialized ApiException {
        try {
            return (ComputeMessageStatsResponse)this.client.computeMessageStats(this.topicPath, this.partition, offset, Offset.of((long)Long.MAX_VALUE)).get(1L, TimeUnit.MINUTES);
        }
        catch (Throwable t) {
            throw ExtractStatus.toCanonical((Throwable)t).underlying;
        }
    }

    @Override
    public void close() {
        this.client.close();
    }
}

