/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.workflow.actions.tableexists;

import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.Const;
import org.apache.hop.core.database.Database;
import org.apache.hop.core.database.DatabaseMeta;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.database.dialog.DatabaseExplorerDialog;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.EnterSelectionDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.dialog.MessageBox;
import org.apache.hop.ui.core.widget.MetaSelectionLine;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.apache.hop.ui.workflow.action.ActionDialog;
import org.apache.hop.ui.workflow.dialog.WorkflowDialog;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.action.IAction;
import org.apache.hop.workflow.actions.tableexists.ActionTableExists;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class ActionTableExistsDialog
extends ActionDialog {
    private static final Class<?> PKG = ActionTableExists.class;
    private Text wName;
    private MetaSelectionLine<DatabaseMeta> wConnection;
    private TextVar wTablename;
    private TextVar wSchemaname;
    private ActionTableExists action;
    private boolean changed;

    public ActionTableExistsDialog(Shell parent, ActionTableExists action, WorkflowMeta workflowMeta, IVariables variables) {
        super(parent, workflowMeta, variables);
        this.action = action;
        if (this.action.getName() == null) {
            this.action.setName(BaseMessages.getString(PKG, (String)"ActionTableExists.Name.Default", (String[])new String[0]));
        }
    }

    public IAction open() {
        this.shell = new Shell(this.getParent(), 3312);
        PropsUi.setLook((Widget)this.shell);
        WorkflowDialog.setShellImage((Shell)this.shell, (IAction)this.action);
        ModifyListener lsMod = e -> this.action.setChanged();
        this.changed = this.action.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = PropsUi.getFormMargin();
        formLayout.marginHeight = PropsUi.getFormMargin();
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"ActionTableExists.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = PropsUi.getMargin();
        Label wlName = new Label((Composite)this.shell, 131072);
        wlName.setText(BaseMessages.getString(PKG, (String)"ActionTableExists.Name.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlName);
        FormData fdlName = new FormData();
        fdlName.left = new FormAttachment(0, 0);
        fdlName.right = new FormAttachment(middle, -margin);
        fdlName.top = new FormAttachment(0, margin);
        wlName.setLayoutData((Object)fdlName);
        this.wName = new Text((Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wName);
        this.wName.addModifyListener(lsMod);
        FormData fdName = new FormData();
        fdName.left = new FormAttachment(middle, 0);
        fdName.top = new FormAttachment(0, margin);
        fdName.right = new FormAttachment(100, 0);
        this.wName.setLayoutData((Object)fdName);
        DatabaseMeta databaseMeta = this.workflowMeta.findDatabase(this.action.getConnection(), this.variables);
        this.wConnection = this.addConnectionLine((Composite)this.shell, (Control)this.wName, databaseMeta, lsMod);
        Label wlSchemaName = new Label((Composite)this.shell, 131072);
        wlSchemaName.setText(BaseMessages.getString(PKG, (String)"ActionTableExists.Schemaname.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlSchemaName);
        FormData fdlSchemaName = new FormData();
        fdlSchemaName.left = new FormAttachment(0, 0);
        fdlSchemaName.right = new FormAttachment(middle, -margin);
        fdlSchemaName.top = new FormAttachment(this.wConnection, 2 * margin);
        wlSchemaName.setLayoutData((Object)fdlSchemaName);
        Button wbSchema = new Button((Composite)this.shell, 0x1000008);
        PropsUi.setLook((Widget)wbSchema);
        wbSchema.setText(BaseMessages.getString(PKG, (String)"System.Button.Browse", (String[])new String[0]));
        FormData fdbSchema = new FormData();
        fdbSchema.top = new FormAttachment(this.wConnection, 2 * margin);
        fdbSchema.right = new FormAttachment(100, 0);
        wbSchema.setLayoutData((Object)fdbSchema);
        wbSchema.addListener(13, e -> this.getSchemaNames());
        this.wSchemaname = new TextVar(this.variables, (Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wSchemaname);
        this.wSchemaname.addModifyListener(lsMod);
        FormData fdSchemaname = new FormData();
        fdSchemaname.left = new FormAttachment(middle, 0);
        fdSchemaname.top = new FormAttachment(this.wConnection, 2 * margin);
        fdSchemaname.right = new FormAttachment((Control)wbSchema, -margin);
        this.wSchemaname.setLayoutData((Object)fdSchemaname);
        Label wlTablename = new Label((Composite)this.shell, 131072);
        wlTablename.setText(BaseMessages.getString(PKG, (String)"ActionTableExists.Tablename.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlTablename);
        FormData fdlTablename = new FormData();
        fdlTablename.left = new FormAttachment(0, 0);
        fdlTablename.right = new FormAttachment(middle, -margin);
        fdlTablename.top = new FormAttachment((Control)wbSchema, margin);
        wlTablename.setLayoutData((Object)fdlTablename);
        Button wbTable = new Button((Composite)this.shell, 0x1000008);
        PropsUi.setLook((Widget)wbTable);
        wbTable.setText(BaseMessages.getString(PKG, (String)"System.Button.Browse", (String[])new String[0]));
        FormData fdbTable = new FormData();
        fdbTable.right = new FormAttachment(100, 0);
        fdbTable.top = new FormAttachment((Control)wbSchema, margin);
        wbTable.setLayoutData((Object)fdbTable);
        wbTable.addListener(13, e -> this.getTableName());
        this.wTablename = new TextVar(this.variables, (Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wTablename);
        this.wTablename.addModifyListener(lsMod);
        FormData fdTablename = new FormData();
        fdTablename.left = new FormAttachment(middle, 0);
        fdTablename.top = new FormAttachment((Control)wbSchema, margin);
        fdTablename.right = new FormAttachment((Control)wbTable, -margin);
        this.wTablename.setLayoutData((Object)fdTablename);
        Button wOk = new Button((Composite)this.shell, 8);
        wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        wOk.addListener(13, e -> this.ok());
        Button wCancel = new Button((Composite)this.shell, 8);
        wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        wCancel.addListener(13, e -> this.cancel());
        BaseTransformDialog.positionBottomButtons((Composite)this.shell, (Button[])new Button[]{wOk, wCancel}, (int)margin, (Control)this.wTablename);
        this.getData();
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.action;
    }

    public void getData() {
        this.wName.setText(Const.nullToEmpty((String)this.action.getName()));
        this.wTablename.setText(Const.nullToEmpty((String)this.action.getTableName()));
        this.wSchemaname.setText(Const.nullToEmpty((String)this.action.getSchemaName()));
        if (this.action.getConnection() != null) {
            this.wConnection.setText(this.action.getConnection());
        }
        this.wName.selectAll();
        this.wName.setFocus();
    }

    private void cancel() {
        this.action.setChanged(this.changed);
        this.action = null;
        this.dispose();
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wName.getText())) {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setText(BaseMessages.getString(PKG, (String)"System.TransformActionNameMissing.Title", (String[])new String[0]));
            mb.setMessage(BaseMessages.getString(PKG, (String)"System.ActionNameMissing.Msg", (String[])new String[0]));
            mb.open();
            return;
        }
        this.action.setName(this.wName.getText());
        this.action.setConnection(this.wConnection.getText());
        this.action.setTableName(this.wTablename.getText());
        this.action.setSchemaName(this.wSchemaname.getText());
        this.dispose();
    }

    private void getSchemaNames() {
        if (this.wSchemaname.isDisposed()) {
            return;
        }
        DatabaseMeta databaseMeta = this.getWorkflowMeta().findDatabase(this.wConnection.getText(), this.variables);
        if (databaseMeta != null) {
            try (Database database = new Database(loggingObject, this.variables, databaseMeta);){
                database.connect();
                String[] schemas = database.getSchemas();
                if (null != schemas && schemas.length > 0) {
                    EnterSelectionDialog dialog = new EnterSelectionDialog(this.shell, schemas = Const.sortStrings((String[])schemas), BaseMessages.getString(PKG, (String)"System.Dialog.AvailableSchemas.Title", (String[])new String[]{this.wConnection.getText()}), BaseMessages.getString(PKG, (String)"System.Dialog.AvailableSchemas.Message", (String[])new String[0]));
                    String d = dialog.open();
                    if (d != null) {
                        this.wSchemaname.setText(Const.NVL((String)d.toString(), (String)""));
                    }
                } else {
                    MessageBox mb = new MessageBox(this.shell, 33);
                    mb.setMessage(BaseMessages.getString(PKG, (String)"System.Dialog.AvailableSchemas.Empty.Message", (String[])new String[0]));
                    mb.setText(BaseMessages.getString(PKG, (String)"System.Dialog.AvailableSchemas.Empty.Title", (String[])new String[0]));
                    mb.open();
                }
            }
            catch (Exception e) {
                new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"System.Dialog.Error.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.Dialog.AvailableSchemas.ConnectionError", (String[])new String[0]), e);
            }
        }
    }

    private void getTableName() {
        String databaseName = this.wConnection.getText();
        if (StringUtils.isNotEmpty((String)databaseName)) {
            DatabaseMeta databaseMeta = this.getWorkflowMeta().findDatabase(databaseName, this.variables);
            if (databaseMeta != null) {
                DatabaseExplorerDialog std = new DatabaseExplorerDialog(this.shell, 0, this.variables, databaseMeta, this.getWorkflowMeta().getDatabases());
                std.setSelectedSchemaAndTable(this.wSchemaname.getText(), this.wTablename.getText());
                if (std.open()) {
                    this.wSchemaname.setText(Const.NVL((String)std.getSchemaName(), (String)""));
                    this.wTablename.setText(Const.NVL((String)std.getTableName(), (String)""));
                }
            } else {
                MessageBox mb = new MessageBox(this.shell, 33);
                mb.setMessage(BaseMessages.getString(PKG, (String)"System.Dialog.ConnectionError.DialogMessage", (String[])new String[0]));
                mb.setText(BaseMessages.getString(PKG, (String)"System.Dialog.Error.Title", (String[])new String[0]));
                mb.open();
            }
        }
    }
}

