/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.beam.core;

import java.io.Serializable;

public class HopRow
implements Serializable {
    private Object[] row;
    private int optionalSize;

    public HopRow() {
        this(null, -1);
    }

    public HopRow(Object[] row) {
        this(row, -1);
    }

    public HopRow(Object[] row, int optionalSize) {
        assert (optionalSize <= row.length) : "optionalSize needs to be <= row length";
        this.row = row;
        this.optionalSize = optionalSize;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof HopRow)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        HopRow otherHopRow = (HopRow)obj;
        Object[] thisRow = this.row;
        Object[] otherRow = otherHopRow.getRow();
        if (thisRow == null && otherRow == null) {
            return true;
        }
        if (thisRow == null || otherRow == null) {
            return false;
        }
        if (thisRow.length != otherRow.length) {
            return false;
        }
        for (int i = 0; i < this.length(); ++i) {
            Object thisValue = thisRow[i];
            Object otherValue = otherRow[i];
            if (thisValue == null && otherValue != null || thisValue != null && otherValue == null) {
                return false;
            }
            if (thisValue == null || thisValue.equals(otherValue)) continue;
            return false;
        }
        return true;
    }

    public int length() {
        return this.optionalSize < 0 ? (this.row == null ? 0 : this.row.length) : this.optionalSize;
    }

    public int hashCode() {
        if (this.row == null) {
            return 0;
        }
        int hashValue = 0;
        for (int i = 0; i < this.length(); ++i) {
            if (this.row[i] == null) continue;
            hashValue ^= this.row[i].hashCode();
        }
        return hashValue;
    }

    public boolean isNotEmpty() {
        if (this.row == null) {
            return false;
        }
        if (this.row.length == 0) {
            return false;
        }
        for (int i = 0; i < this.row.length; ++i) {
            if (this.row[i] == null) continue;
            return true;
        }
        return false;
    }

    public Object[] getRow() {
        return this.row;
    }

    public void setRow(Object[] row) {
        this.row = row;
    }

    public int getOptionalSize() {
        return this.optionalSize;
    }

    public void setOptionalSize(int optionalSize) {
        this.optionalSize = optionalSize;
    }
}

