/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.java;

import java.util.List;
import org.drools.core.rule.JavaDialectRuntimeData;
import org.drools.mvel.java.JavaDialectError;
import org.kie.internal.builder.KnowledgeBuilderResult;
import org.kie.memorycompiler.resources.ResourceStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PackageStore
implements ResourceStore {
    private static final Logger LOG = LoggerFactory.getLogger(PackageStore.class);
    private JavaDialectRuntimeData javaDialectRuntimeData;
    private List<KnowledgeBuilderResult> errors;

    public PackageStore() {
    }

    public PackageStore(JavaDialectRuntimeData javaDialectRuntimeData, List<KnowledgeBuilderResult> errors) {
        this.javaDialectRuntimeData = javaDialectRuntimeData;
        this.errors = errors;
    }

    public void setPackageCompilationData(JavaDialectRuntimeData javaDialectRuntimeData) {
        this.javaDialectRuntimeData = javaDialectRuntimeData;
    }

    public void write(String resourceName, byte[] clazzData) {
        try {
            this.javaDialectRuntimeData.write(resourceName, clazzData);
        }
        catch (Exception e) {
            LOG.error("Exception", (Throwable)e);
            this.errors.add((KnowledgeBuilderResult)new JavaDialectError("PackageStore was unable to write resourceName='" + resourceName + "'"));
        }
    }

    public void write(String resourceName, byte[] clazzData, boolean createFolder) {
        this.write(resourceName, clazzData);
    }

    public byte[] read(String resourceName) {
        byte[] clazz = null;
        try {
            clazz = this.javaDialectRuntimeData.read(resourceName);
        }
        catch (Exception e) {
            this.errors.add((KnowledgeBuilderResult)new JavaDialectError("PackageStore was unable to read resourceName='" + resourceName + "'"));
        }
        return clazz;
    }

    public void remove(String resourceName) {
        try {
            this.javaDialectRuntimeData.remove(resourceName);
        }
        catch (Exception e) {
            this.errors.add((KnowledgeBuilderResult)new JavaDialectError("PackageStore was unable to remove resourceName='" + resourceName + "'"));
        }
    }
}

