/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.parquet.transforms.input;

import java.util.ArrayList;
import java.util.List;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.parquet.transforms.input.ParquetField;
import org.apache.hop.parquet.transforms.input.ParquetInput;
import org.apache.hop.parquet.transforms.input.ParquetInputData;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;

@Transform(id="ParquetFileInput", image="parquet_input.svg", name="i18n::ParquetInput.Name", description="i18n::ParquetInput.Description", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Input", documentationUrl="/pipeline/transforms/parquet-file-input.html", keywords={"i18n::ParquetInputMeta.keyword"})
public class ParquetInputMeta
extends BaseTransformMeta<ParquetInput, ParquetInputData> {
    @HopMetadataProperty(key="filename_field")
    private String filenameField;
    @HopMetadataProperty(groupKey="fields", key="field")
    private List<ParquetField> fields = new ArrayList<ParquetField>();

    public void getFields(IRowMeta inputRowMeta, String name, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) throws HopTransformException {
        for (ParquetField field : this.fields) {
            try {
                IValueMeta valueMeta = field.createValueMeta();
                valueMeta.setOrigin(name);
                inputRowMeta.addValueMeta(valueMeta);
            }
            catch (HopException e) {
                throw new HopTransformException("Unable to create value metadata of type '" + field.getTargetType() + "'", (Throwable)e);
            }
        }
    }

    public String getFilenameField() {
        return this.filenameField;
    }

    public void setFilenameField(String filenameField) {
        this.filenameField = filenameField;
    }

    public List<ParquetField> getFields() {
        return this.fields;
    }

    public void setFields(List<ParquetField> fields) {
        this.fields = fields;
    }
}

