/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.getsubfolders;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.vfs2.FileObject;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.fileinput.FileInputList;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.value.ValueMetaBoolean;
import org.apache.hop.core.row.value.ValueMetaDate;
import org.apache.hop.core.row.value.ValueMetaInteger;
import org.apache.hop.core.row.value.ValueMetaString;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.getsubfolders.GetSubFolders;
import org.apache.hop.pipeline.transforms.getsubfolders.GetSubFoldersData;
import org.apache.hop.resource.IResourceNaming;
import org.apache.hop.resource.ResourceDefinition;

@Transform(id="GetSubFolders", image="getsubfolders.svg", name="i18n::GetSubFolders.Name", description="i18n::GetSubFolders.Description", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Input", keywords={"i18n::GetSubFoldersMeta.keyword"}, documentationUrl="/pipeline/transforms/getsubfolders.html")
public class GetSubFoldersMeta
extends BaseTransformMeta<GetSubFolders, GetSubFoldersData> {
    private static final Class<?> PKG = GetSubFoldersMeta.class;
    @HopMetadataProperty(key="file")
    private List<GSFile> files = new ArrayList<GSFile>();
    @HopMetadataProperty(key="rownum")
    private boolean includeRowNumber;
    @HopMetadataProperty(key="rownum_field")
    private String rowNumberField;
    @HopMetadataProperty(key="foldername_field")
    private String dynamicFolderNameField;
    @HopMetadataProperty(key="foldername_dynamic")
    private boolean folderNameDynamic;
    @HopMetadataProperty(key="limit")
    private long rowLimit;

    public GetSubFoldersMeta() {
    }

    public GetSubFoldersMeta(GetSubFoldersMeta m) {
        this();
        this.includeRowNumber = m.includeRowNumber;
        this.rowNumberField = m.rowNumberField;
        this.dynamicFolderNameField = m.dynamicFolderNameField;
        this.folderNameDynamic = m.folderNameDynamic;
        this.rowLimit = m.rowLimit;
        m.files.forEach(f -> this.files.add(new GSFile((GSFile)f)));
    }

    public GetSubFoldersMeta clone() {
        return new GetSubFoldersMeta(this);
    }

    public void setDefault() {
        this.folderNameDynamic = false;
        this.includeRowNumber = false;
        this.rowNumberField = "";
        this.dynamicFolderNameField = "";
    }

    public void getFields(IRowMeta row, String name, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) {
        ValueMetaString folderNameValueMeta = new ValueMetaString("folderName");
        folderNameValueMeta.setLength(500);
        folderNameValueMeta.setPrecision(-1);
        folderNameValueMeta.setOrigin(name);
        row.addValueMeta((IValueMeta)folderNameValueMeta);
        ValueMetaString shortFolderNameValueMeta = new ValueMetaString("short_folderName");
        shortFolderNameValueMeta.setLength(500);
        shortFolderNameValueMeta.setPrecision(-1);
        shortFolderNameValueMeta.setOrigin(name);
        row.addValueMeta((IValueMeta)shortFolderNameValueMeta);
        ValueMetaString pathValueMeta = new ValueMetaString("path");
        pathValueMeta.setLength(500);
        pathValueMeta.setPrecision(-1);
        pathValueMeta.setOrigin(name);
        row.addValueMeta((IValueMeta)pathValueMeta);
        ValueMetaBoolean isHiddenValueMeta = new ValueMetaBoolean("ishidden");
        isHiddenValueMeta.setOrigin(name);
        row.addValueMeta((IValueMeta)isHiddenValueMeta);
        ValueMetaBoolean isReadableValueMeta = new ValueMetaBoolean("isreadable");
        isReadableValueMeta.setOrigin(name);
        row.addValueMeta((IValueMeta)isReadableValueMeta);
        ValueMetaBoolean isWriteableValueMeta = new ValueMetaBoolean("iswriteable");
        isWriteableValueMeta.setOrigin(name);
        row.addValueMeta((IValueMeta)isWriteableValueMeta);
        ValueMetaDate lastModifiedTimeValueMeta = new ValueMetaDate("lastmodifiedtime");
        lastModifiedTimeValueMeta.setOrigin(name);
        row.addValueMeta((IValueMeta)lastModifiedTimeValueMeta);
        ValueMetaString uriValueMeta = new ValueMetaString("uri");
        uriValueMeta.setOrigin(name);
        row.addValueMeta((IValueMeta)uriValueMeta);
        ValueMetaString rootUriValueMeta = new ValueMetaString("rooturi");
        rootUriValueMeta.setOrigin(name);
        row.addValueMeta((IValueMeta)rootUriValueMeta);
        ValueMetaInteger childrenValueMeta = new ValueMetaInteger(variables.resolve("childrens"));
        childrenValueMeta.setLength(10, 0);
        childrenValueMeta.setOrigin(name);
        row.addValueMeta((IValueMeta)childrenValueMeta);
        if (this.includeRowNumber) {
            ValueMetaInteger v = new ValueMetaInteger(variables.resolve(this.rowNumberField));
            v.setLength(10, 0);
            v.setOrigin(name);
            row.addValueMeta((IValueMeta)v);
        }
    }

    public String[] getFilesNames() {
        String[] names = new String[this.files.size()];
        for (int i = 0; i < names.length; ++i) {
            names[i] = this.files.get(i).getName();
        }
        return names;
    }

    public String[] getFilesRequired() {
        String[] required = new String[this.files.size()];
        for (int i = 0; i < required.length; ++i) {
            required[i] = this.files.get(i).isRequired() ? "Y" : "N";
        }
        return required;
    }

    public FileInputList getFolderList(IVariables variables) {
        return FileInputList.createFolderList((IVariables)variables, (String[])this.getFilesNames(), (String[])this.getFilesRequired());
    }

    public FileInputList getDynamicFolderList(IVariables variables, String[] folderName, String[] folderRequired) {
        return FileInputList.createFolderList((IVariables)variables, (String[])folderName, (String[])folderRequired);
    }

    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        if (this.folderNameDynamic) {
            CheckResult cr = input.length > 0 ? new CheckResult(1, BaseMessages.getString(PKG, (String)"GetSubFoldersMeta.CheckResult.InputOk", (String[])new String[0]), (ICheckResultSource)transformMeta) : new CheckResult(4, BaseMessages.getString(PKG, (String)"GetSubFoldersMeta.CheckResult.InputErrorKo", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
            cr = Utils.isEmpty((CharSequence)this.dynamicFolderNameField) ? new CheckResult(4, BaseMessages.getString(PKG, (String)"GetSubFoldersMeta.CheckResult.FolderFieldnameMissing", (String[])new String[0]), (ICheckResultSource)transformMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"GetSubFoldersMeta.CheckResult.FolderFieldnameOk", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            CheckResult cr = input.length > 0 ? new CheckResult(4, BaseMessages.getString(PKG, (String)"GetSubFoldersMeta.CheckResult.NoInputError", (String[])new String[0]), (ICheckResultSource)transformMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"GetSubFoldersMeta.CheckResult.NoInputOk", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
            FileInputList fileList = this.getFolderList(variables);
            if (fileList.nrOfFiles() == 0) {
                cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"GetSubFoldersMeta.CheckResult.ExpectedFoldersError", (String[])new String[0]), (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            } else {
                cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"GetSubFoldersMeta.CheckResult.ExpectedFilesOk", (String[])new String[]{"" + fileList.nrOfFiles()}), (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            }
        }
    }

    public String exportResources(IVariables variables, Map<String, ResourceDefinition> definitions, IResourceNaming iResourceNaming, IHopMetadataProvider metadataProvider) throws HopException {
        try {
            if (!this.folderNameDynamic) {
                for (GSFile file : this.files) {
                    FileObject fileObject = HopVfs.getFileObject((String)variables.resolve(file.getName()));
                    file.setName(iResourceNaming.nameResource(fileObject, variables, true));
                }
            }
            return null;
        }
        catch (Exception e) {
            throw new HopException((Throwable)e);
        }
    }

    public List<GSFile> getFiles() {
        return this.files;
    }

    public void setFiles(List<GSFile> files) {
        this.files = files;
    }

    public boolean isIncludeRowNumber() {
        return this.includeRowNumber;
    }

    public void setIncludeRowNumber(boolean includeRowNumber) {
        this.includeRowNumber = includeRowNumber;
    }

    public String getRowNumberField() {
        return this.rowNumberField;
    }

    public void setRowNumberField(String rowNumberField) {
        this.rowNumberField = rowNumberField;
    }

    public String getDynamicFolderNameField() {
        return this.dynamicFolderNameField;
    }

    public void setDynamicFolderNameField(String dynamicFolderNameField) {
        this.dynamicFolderNameField = dynamicFolderNameField;
    }

    public boolean isFolderNameDynamic() {
        return this.folderNameDynamic;
    }

    public void setFolderNameDynamic(boolean folderNameDynamic) {
        this.folderNameDynamic = folderNameDynamic;
    }

    public long getRowLimit() {
        return this.rowLimit;
    }

    public void setRowLimit(long rowLimit) {
        this.rowLimit = rowLimit;
    }

    public static final class GSFile {
        @HopMetadataProperty(key="name")
        private String name;
        @HopMetadataProperty(key="file_required")
        private boolean required;

        public GSFile() {
        }

        public GSFile(GSFile f) {
            this.name = f.name;
            this.required = f.required;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public boolean isRequired() {
            return this.required;
        }

        public void setRequired(boolean required) {
            this.required = required;
        }
    }
}

