/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark;

import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.beam.model.jobmanagement.v1.JobApi;
import org.apache.beam.runners.core.metrics.MetricsContainerStepMap;
import org.apache.beam.runners.jobsubmission.PortablePipelineResult;
import org.apache.beam.runners.spark.metrics.MetricsAccumulator;
import org.apache.beam.runners.spark.translation.SparkContextFactory;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.PipelineResult;
import org.apache.beam.sdk.metrics.MetricResults;
import org.apache.beam.sdk.util.UserCodeException;
import org.apache.spark.SparkException;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.streaming.api.java.JavaStreamingContext;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Duration;

public abstract class SparkPipelineResult
implements PipelineResult {
    final @UnknownKeyFor @NonNull @Initialized Future pipelineExecution;
    final @UnknownKeyFor @NonNull @Initialized JavaSparkContext javaSparkContext;
    // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized PipelineResult.State state;

    SparkPipelineResult(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Future<@UnknownKeyFor @KeyForBottom @Nullable @Initialized @NonNull @Initialized ?> pipelineExecution, @UnknownKeyFor @NonNull @Initialized JavaSparkContext javaSparkContext) {
        this.pipelineExecution = pipelineExecution;
        this.javaSparkContext = javaSparkContext;
        this.state = PipelineResult.State.RUNNING;
    }

    private static @UnknownKeyFor @NonNull @Initialized RuntimeException runtimeExceptionFrom(@UnknownKeyFor @NonNull @Initialized Throwable e) {
        return e instanceof RuntimeException ? (RuntimeException)e : new RuntimeException(e);
    }

    private static @UnknownKeyFor @NonNull @Initialized RuntimeException beamExceptionFrom(@UnknownKeyFor @NonNull @Initialized Throwable e) {
        if (e instanceof SparkException) {
            if (e.getCause() != null && e.getCause() instanceof UserCodeException) {
                UserCodeException userException = (UserCodeException)e.getCause();
                return new Pipeline.PipelineExecutionException(userException.getCause());
            }
            if (e.getCause() != null) {
                return new Pipeline.PipelineExecutionException(e.getCause());
            }
        }
        return SparkPipelineResult.runtimeExceptionFrom(e);
    }

    protected abstract void stop();

    protected abstract // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized PipelineResult.State awaitTermination(@UnknownKeyFor @NonNull @Initialized Duration var1) throws @UnknownKeyFor @NonNull @Initialized TimeoutException, @UnknownKeyFor @NonNull @Initialized ExecutionException, @UnknownKeyFor @NonNull @Initialized InterruptedException;

    public // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized PipelineResult.State getState() {
        return this.state;
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized PipelineResult.State waitUntilFinish() {
        return this.waitUntilFinish(Duration.millis((long)-1L));
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized PipelineResult.State waitUntilFinish(@UnknownKeyFor @NonNull @Initialized Duration duration) {
        try {
            PipelineResult.State finishState = this.awaitTermination(duration);
            this.offerNewState(finishState);
        }
        catch (TimeoutException finishState) {
        }
        catch (ExecutionException e) {
            this.offerNewState(PipelineResult.State.FAILED);
            throw SparkPipelineResult.beamExceptionFrom(e.getCause());
        }
        catch (Exception e) {
            this.offerNewState(PipelineResult.State.FAILED);
            throw SparkPipelineResult.beamExceptionFrom(e);
        }
        return this.state;
    }

    public @UnknownKeyFor @NonNull @Initialized MetricResults metrics() {
        return MetricsContainerStepMap.asAttemptedOnlyMetricResults((MetricsContainerStepMap)MetricsAccumulator.getInstance().value());
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized PipelineResult.State cancel() throws @UnknownKeyFor @NonNull @Initialized IOException {
        this.offerNewState(PipelineResult.State.CANCELLED);
        return this.state;
    }

    private void offerNewState(// Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized PipelineResult.State newState) {
        PipelineResult.State oldState = this.state;
        this.state = newState;
        if (!oldState.isTerminal() && newState.isTerminal()) {
            this.stop();
        }
    }

    static class PortableStreamingMode
    extends StreamingMode
    implements PortablePipelineResult {
        PortableStreamingMode(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Future<@UnknownKeyFor @KeyForBottom @Nullable @Initialized @NonNull @Initialized ?> pipelineExecution, @UnknownKeyFor @NonNull @Initialized JavaStreamingContext javaStreamingContext) {
            super(pipelineExecution, javaStreamingContext);
        }

        public // Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized JobApi.MetricResults portableMetrics() {
            return JobApi.MetricResults.newBuilder().addAllAttempted(MetricsAccumulator.getInstance().value().getMonitoringInfos()).build();
        }
    }

    static class StreamingMode
    extends SparkPipelineResult {
        private final @UnknownKeyFor @NonNull @Initialized JavaStreamingContext javaStreamingContext;

        StreamingMode(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Future<@UnknownKeyFor @KeyForBottom @Nullable @Initialized @NonNull @Initialized ?> pipelineExecution, @UnknownKeyFor @NonNull @Initialized JavaStreamingContext javaStreamingContext) {
            super(pipelineExecution, javaStreamingContext.sparkContext());
            this.javaStreamingContext = javaStreamingContext;
        }

        @Override
        protected void stop() {
            this.javaStreamingContext.stop(false, true);
            try {
                this.javaStreamingContext.awaitTerminationOrTimeout(0L);
            }
            catch (Exception e) {
                throw SparkPipelineResult.beamExceptionFrom(e);
            }
            finally {
                SparkContextFactory.stopSparkContext(this.javaSparkContext);
                if (Objects.equals(this.state, PipelineResult.State.RUNNING)) {
                    this.state = PipelineResult.State.STOPPED;
                }
            }
        }

        @Override
        protected // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized PipelineResult.State awaitTermination(@UnknownKeyFor @NonNull @Initialized Duration duration) throws @UnknownKeyFor @NonNull @Initialized ExecutionException, @UnknownKeyFor @NonNull @Initialized InterruptedException {
            PipelineResult.State terminationState;
            this.pipelineExecution.get();
            this.javaStreamingContext.awaitTerminationOrTimeout(duration.getMillis());
            switch (this.javaStreamingContext.getState()) {
                case ACTIVE: {
                    terminationState = PipelineResult.State.RUNNING;
                    break;
                }
                case STOPPED: {
                    terminationState = PipelineResult.State.DONE;
                    break;
                }
                default: {
                    terminationState = PipelineResult.State.UNKNOWN;
                }
            }
            return terminationState;
        }
    }

    static class PortableBatchMode
    extends BatchMode
    implements PortablePipelineResult {
        PortableBatchMode(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Future<@UnknownKeyFor @KeyForBottom @Nullable @Initialized @NonNull @Initialized ?> pipelineExecution, @UnknownKeyFor @NonNull @Initialized JavaSparkContext javaSparkContext) {
            super(pipelineExecution, javaSparkContext);
        }

        public // Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized JobApi.MetricResults portableMetrics() {
            return JobApi.MetricResults.newBuilder().addAllAttempted(MetricsAccumulator.getInstance().value().getMonitoringInfos()).build();
        }
    }

    static class BatchMode
    extends SparkPipelineResult {
        BatchMode(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Future<@UnknownKeyFor @KeyForBottom @Nullable @Initialized @NonNull @Initialized ?> pipelineExecution, @UnknownKeyFor @NonNull @Initialized JavaSparkContext javaSparkContext) {
            super(pipelineExecution, javaSparkContext);
        }

        @Override
        protected void stop() {
            SparkContextFactory.stopSparkContext(this.javaSparkContext);
            if (Objects.equals(this.state, PipelineResult.State.RUNNING)) {
                this.state = PipelineResult.State.STOPPED;
            }
        }

        @Override
        protected // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized PipelineResult.State awaitTermination(@UnknownKeyFor @NonNull @Initialized Duration duration) throws @UnknownKeyFor @NonNull @Initialized TimeoutException, @UnknownKeyFor @NonNull @Initialized ExecutionException, @UnknownKeyFor @NonNull @Initialized InterruptedException {
            if (duration.getMillis() > 0L) {
                this.pipelineExecution.get(duration.getMillis(), TimeUnit.MILLISECONDS);
            } else {
                this.pipelineExecution.get();
            }
            return PipelineResult.State.DONE;
        }
    }
}

