/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.git;

import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.extension.ExtensionPoint;
import org.apache.hop.core.extension.IExtensionPoint;
import org.apache.hop.core.gui.DPoint;
import org.apache.hop.core.gui.IGc;
import org.apache.hop.core.gui.Point;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.svg.SvgFile;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.WorkflowPainter;

@ExtensionPoint(id="DrawDiffOnActionExtensionPoint", description="Draws a marker on top of an action if it has some change", extensionPointId="WorkflowPainterEnd")
public class DrawDiffOnActionExtensionPoint
implements IExtensionPoint {
    public void callExtensionPoint(ILogChannel log, IVariables variables, Object object) throws HopException {
        if (!(object instanceof WorkflowPainter)) {
            return;
        }
        WorkflowPainter painter = (WorkflowPainter)object;
        DPoint offset = painter.getOffset();
        IGc gc = painter.getGc();
        WorkflowMeta workflowMeta = painter.getWorkflowMeta();
        try {
            workflowMeta.getActions().stream().filter(je -> je.getAttribute("Git", "Status") != null).forEach(je -> {
                if (workflowMeta.getWorkflowVersion() != null && workflowMeta.getWorkflowVersion().startsWith("git")) {
                    String location;
                    String status = je.getAttribute("Git", "Status");
                    Point n = je.getLocation();
                    if (status.equals("REMOVED")) {
                        location = "removed.svg";
                    } else if (status.equals("CHANGED")) {
                        location = "changed.svg";
                    } else if (status.equals("ADDED")) {
                        location = "added.svg";
                    } else {
                        return;
                    }
                    int iconSize = 32;
                    try {
                        iconSize = PropsUi.getInstance().getIconSize();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    double x = (double)(n.x + iconSize) + offset.x - (double)(iconSize / 4);
                    double y = (double)n.y + offset.y - (double)(iconSize / 4);
                    try {
                        gc.drawImage(new SvgFile(location, this.getClass().getClassLoader()), (int)x, (int)y, iconSize / 4, iconSize / 4, gc.getMagnification(), 0.0);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
                je.getAttributesMap().remove("Git");
            });
        }
        catch (Exception e) {
            throw new HopException("Error drawing status icon on action", (Throwable)e);
        }
    }
}

