/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.vfs.gs;

import com.google.cloud.WriteChannel;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;

public class WriteChannelOutputStream
extends OutputStream {
    WriteChannel channel;
    ByteBuffer bytes = ByteBuffer.allocate(65536);

    public WriteChannelOutputStream(WriteChannel channel) {
        this.channel = channel;
    }

    @Override
    public void write(int b) throws IOException {
        if (this.channel == null) {
            throw new ClosedChannelException();
        }
        this.bytes.put((byte)b);
        this.bytes.flip();
        this.channel.write(this.bytes);
        this.bytes.compact();
    }

    @Override
    public synchronized void write(byte[] buf, int off, int len) throws IOException {
        int c;
        if (this.channel == null) {
            throw new ClosedChannelException();
        }
        for (int count = 0; count < len; count += c) {
            c = Math.min(len - count, this.bytes.remaining());
            this.bytes.put(buf, off + count, c);
            this.bytes.flip();
            while (this.bytes.hasRemaining()) {
                this.channel.write(this.bytes);
            }
            this.bytes.compact();
        }
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.channel != null) {
            this.channel.close();
            this.channel = null;
        }
    }
}

