/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms;

import java.util.Iterator;
import org.apache.beam.sdk.coders.CannotProvideCoderException;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderRegistry;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.coders.NullableCoder;
import org.apache.beam.sdk.transforms.Combine;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.Reify;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.TimestampedValue;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.ReadableInstant;

public class Latest {
    private Latest() {
    }

    public static <T> /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Combine.CombineFn<@UnknownKeyFor @NonNull @Initialized TimestampedValue<T>, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, T> combineFn() {
        return new LatestFn();
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PCollection<T>, @UnknownKeyFor @NonNull @Initialized PCollection<T>> globally() {
        return new Globally();
    }

    public static <K, V> @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<K, V>>, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<K, V>>> perKey() {
        return new PerKey();
    }

    private static class PerKey<@UnknownKeyFor K, @UnknownKeyFor V>
    extends PTransform<PCollection<KV<K, V>>, PCollection<KV<K, V>>> {
        private PerKey() {
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<K, V>> expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<K, V>> input) {
            Preconditions.checkNotNull(input);
            Preconditions.checkArgument((boolean)(input.getCoder() instanceof KvCoder), (String)"Input specifiedCoder must be an instance of KvCoder, but was %s", input.getCoder());
            KvCoder inputCoder = (KvCoder)input.getCoder();
            return ((PCollection)input.apply("Reify Timestamps", Reify.timestampsInValue()).apply("Latest Value", Combine.perKey(new LatestFn()))).setCoder(inputCoder);
        }
    }

    private static class Globally<@UnknownKeyFor T>
    extends PTransform<PCollection<T>, PCollection<T>> {
        private Globally() {
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized PCollection<T> expand(@UnknownKeyFor @NonNull @Initialized PCollection<T> input) {
            Coder<T> inputCoder = input.getCoder();
            return ((PCollection)input.apply("Reify Timestamps", Reify.timestamps()).apply("Latest Value", Combine.globally(new LatestFn()))).setCoder(NullableCoder.of(inputCoder));
        }
    }

    @VisibleForTesting
    static class LatestFn<@UnknownKeyFor T>
    extends Combine.CombineFn<TimestampedValue<T>, TimestampedValue<T>, T> {
        @Override
        public @UnknownKeyFor @NonNull @Initialized TimestampedValue<T> createAccumulator() {
            return TimestampedValue.atMinimumTimestamp(null);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized TimestampedValue<T> addInput(@UnknownKeyFor @NonNull @Initialized TimestampedValue<T> accumulator, @UnknownKeyFor @NonNull @Initialized TimestampedValue<T> input) {
            Preconditions.checkNotNull(accumulator, (Object)"accumulator must be non-null");
            Preconditions.checkNotNull(input, (Object)"input must be non-null");
            if (input.getTimestamp().isBefore((ReadableInstant)accumulator.getTimestamp())) {
                return accumulator;
            }
            if (input.getTimestamp().isAfter((ReadableInstant)accumulator.getTimestamp())) {
                return input;
            }
            return accumulator.getValue() != null ? accumulator : input;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized TimestampedValue<T>> getAccumulatorCoder(@UnknownKeyFor @NonNull @Initialized CoderRegistry registry, @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized TimestampedValue<T>> inputCoder) throws @UnknownKeyFor @NonNull @Initialized CannotProvideCoderException {
            return NullableCoder.of(inputCoder);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Coder<T> getDefaultOutputCoder(@UnknownKeyFor @NonNull @Initialized CoderRegistry registry, @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized TimestampedValue<T>> inputCoder) throws @UnknownKeyFor @NonNull @Initialized CannotProvideCoderException {
            Preconditions.checkState((boolean)(inputCoder instanceof TimestampedValue.TimestampedValueCoder), (String)"inputCoder must be a TimestampedValueCoder, but was %s", inputCoder);
            TimestampedValue.TimestampedValueCoder inputTVCoder = (TimestampedValue.TimestampedValueCoder)inputCoder;
            return NullableCoder.of(inputTVCoder.getValueCoder());
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized TimestampedValue<T> mergeAccumulators(@UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized TimestampedValue<T>> accumulators) {
            Preconditions.checkNotNull(accumulators, (Object)"accumulators must be non-null");
            Iterator<TimestampedValue<T>> iter = accumulators.iterator();
            if (!iter.hasNext()) {
                return this.createAccumulator();
            }
            TimestampedValue<T> merged = iter.next();
            while (iter.hasNext()) {
                merged = this.addInput(merged, iter.next());
            }
            return merged;
        }

        @Override
        public T extractOutput(@UnknownKeyFor @NonNull @Initialized TimestampedValue<T> accumulator) {
            return accumulator.getValue();
        }
    }
}

