/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms;

import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.beam.sdk.coders.CannotProvideCoderException;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.display.HasDisplayData;
import org.apache.beam.sdk.transforms.resourcehints.ResourceHints;
import org.apache.beam.sdk.util.NameUtils;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PInput;
import org.apache.beam.sdk.values.POutput;
import org.apache.beam.sdk.values.PValue;
import org.apache.beam.sdk.values.TupleTag;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.SideEffectFree;

public abstract class PTransform<@UnknownKeyFor InputT extends @UnknownKeyFor @NonNull @Initialized PInput, @UnknownKeyFor OutputT extends @UnknownKeyFor @NonNull @Initialized POutput>
implements Serializable,
HasDisplayData {
    private static final @UnknownKeyFor @NonNull @Initialized long serialVersionUID = 3383862966597863311L;
    protected final transient @Nullable @UnknownKeyFor @Initialized String name;
    protected transient @NonNull @UnknownKeyFor @Initialized ResourceHints resourceHints = ResourceHints.create();
    protected transient @NonNull @UnknownKeyFor @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized byte @NonNull @UnknownKeyFor @Initialized []> annotations = new HashMap<String, byte[]>();
    protected transient /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @NonNull @UnknownKeyFor @Initialized List< @UnknownKeyFor @NonNull @Initialized DisplayData.ItemSpec<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> displayData = new ArrayList();

    public abstract OutputT expand(InputT var1);

    public void validate(@Nullable @UnknownKeyFor @Initialized PipelineOptions options) {
    }

    public void validate(@Nullable @UnknownKeyFor @Initialized PipelineOptions options, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> inputs, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> outputs) {
        this.validate(options);
    }

    public /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized PValue> getAdditionalInputs() {
        return Collections.emptyMap();
    }

    public @UnknownKeyFor @NonNull @Initialized String getName() {
        return this.name != null ? this.name : this.getKindString();
    }

    public @UnknownKeyFor @NonNull @Initialized PTransform<InputT, OutputT> setResourceHints(@NonNull @UnknownKeyFor @Initialized ResourceHints resourceHints) {
        this.resourceHints = resourceHints;
        return this;
    }

    public @UnknownKeyFor @NonNull @Initialized ResourceHints getResourceHints() {
        return this.resourceHints;
    }

    public @UnknownKeyFor @NonNull @Initialized PTransform<InputT, OutputT> setDisplayData(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @NonNull @UnknownKeyFor @Initialized List< @UnknownKeyFor @NonNull @Initialized DisplayData.ItemSpec<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> displayData) {
        this.displayData = displayData;
        return this;
    }

    public @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []> getAnnotations() {
        return this.annotations;
    }

    public @UnknownKeyFor @NonNull @Initialized PTransform<InputT, OutputT> addAnnotation(@NonNull @UnknownKeyFor @Initialized String annotationType, @UnknownKeyFor @NonNull @Initialized byte @NonNull @UnknownKeyFor @Initialized [] annotation) {
        this.annotations.put(annotationType, annotation);
        return this;
    }

    protected PTransform() {
        this.name = null;
    }

    protected PTransform(@Nullable @UnknownKeyFor @Initialized String name) {
        this.name = name;
    }

    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        if (this.name == null) {
            return this.getKindString();
        }
        return this.getName() + " [" + this.getKindString() + "]";
    }

    protected @UnknownKeyFor @NonNull @Initialized String getKindString() {
        if (this.getClass().isAnonymousClass()) {
            return "AnonymousTransform";
        }
        return NameUtils.approximatePTransformName(this.getClass());
    }

    private void writeObject(@UnknownKeyFor @NonNull @Initialized ObjectOutputStream oos) {
    }

    private void readObject(@UnknownKeyFor @NonNull @Initialized ObjectInputStream oos) {
    }

    @Deprecated
    protected /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> getDefaultOutputCoder() throws @UnknownKeyFor @NonNull @Initialized CannotProvideCoderException {
        throw new CannotProvideCoderException("PTransform.getOutputCoder called.");
    }

    @Deprecated
    protected /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> getDefaultOutputCoder(InputT input) throws @UnknownKeyFor @NonNull @Initialized CannotProvideCoderException {
        return this.getDefaultOutputCoder();
    }

    @Deprecated
    public <T> @UnknownKeyFor @NonNull @Initialized Coder<T> getDefaultOutputCoder(InputT input, @UnknownKeyFor @NonNull @Initialized PCollection<T> output) throws @UnknownKeyFor @NonNull @Initialized CannotProvideCoderException {
        Coder<?> defaultOutputCoder = this.getDefaultOutputCoder(input);
        return defaultOutputCoder;
    }

    @Override
    public void populateDisplayData( @UnknownKeyFor @NonNull @Initialized DisplayData.Builder builder) {
        if (this.displayData != null) {
            this.displayData.forEach(builder::add);
        }
    }

    public static <InputT extends PInput, OutputT extends POutput> @UnknownKeyFor @NonNull @Initialized PTransform<InputT, OutputT> compose(final @UnknownKeyFor @NonNull @Initialized SerializableFunction<InputT, OutputT> fn) {
        return new PTransform<InputT, OutputT>(){

            @Override
            public OutputT expand(InputT input) {
                return (POutput)fn.apply(input);
            }
        };
    }

    public static <InputT extends PInput, OutputT extends POutput> @UnknownKeyFor @NonNull @Initialized PTransform<InputT, OutputT> compose(@UnknownKeyFor @NonNull @Initialized String name, final @UnknownKeyFor @NonNull @Initialized SerializableFunction<InputT, OutputT> fn) {
        return new PTransform<InputT, OutputT>(name){

            @Override
            public OutputT expand(InputT input) {
                return (POutput)fn.apply(input);
            }
        };
    }
}

