/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms.errorhandling;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.metrics.Counter;
import org.apache.beam.sdk.metrics.Metrics;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.Flatten;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.errorhandling.BadRecord;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionList;
import org.apache.beam.sdk.values.POutput;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface ErrorHandler<@UnknownKeyFor ErrorT, @UnknownKeyFor OutputT extends @UnknownKeyFor @NonNull @Initialized POutput>
extends AutoCloseable,
Serializable {
    public void addErrorCollection(@UnknownKeyFor @NonNull @Initialized PCollection<ErrorT> var1);

    public @UnknownKeyFor @NonNull @Initialized boolean isClosed();

    public @Nullable OutputT getOutput();

    @Internal
    public static class DefaultErrorHandler<@UnknownKeyFor ErrorT, @UnknownKeyFor OutputT extends @UnknownKeyFor @NonNull @Initialized POutput>
    implements ErrorHandler<ErrorT, OutputT> {
        @Override
        public void addErrorCollection(@UnknownKeyFor @NonNull @Initialized PCollection<ErrorT> errorCollection) {
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized boolean isClosed() {
            throw new IllegalArgumentException("No Op handler should not be closed. This implies this IO is misconfigured.");
        }

        @Override
        public @Nullable OutputT getOutput() {
            throw new IllegalArgumentException("No Op handler has no output. This implies this IO is misconfigured.");
        }

        @Override
        public void close() {
            throw new IllegalArgumentException("No Op handler should not be closed. This implies this IO is misconfigured.");
        }
    }

    public static class BadRecordErrorHandler<@UnknownKeyFor OutputT extends @UnknownKeyFor @NonNull @Initialized POutput>
    extends PTransformErrorHandler<BadRecord, OutputT> {
        @Internal
        public BadRecordErrorHandler(@UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized BadRecord>, OutputT> sinkTransform, @UnknownKeyFor @NonNull @Initialized Pipeline pipeline) {
            super(sinkTransform, pipeline, BadRecord.getCoder(pipeline));
        }
    }

    public static class PTransformErrorHandler<@UnknownKeyFor ErrorT, @UnknownKeyFor OutputT extends @UnknownKeyFor @NonNull @Initialized POutput>
    implements ErrorHandler<ErrorT, OutputT> {
        private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(PTransformErrorHandler.class);
        private final @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PCollection<ErrorT>, OutputT> sinkTransform;
        private final transient @UnknownKeyFor @NonNull @Initialized Pipeline pipeline;
        private final @UnknownKeyFor @NonNull @Initialized Coder<ErrorT> coder;
        private transient @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized PCollection<ErrorT>> errorCollections = new ArrayList<PCollection<ErrorT>>();
        private transient @Nullable OutputT sinkOutput = null;
        private @UnknownKeyFor @NonNull @Initialized boolean closed = false;

        @Internal
        public PTransformErrorHandler(@UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PCollection<ErrorT>, OutputT> sinkTransform, @UnknownKeyFor @NonNull @Initialized Pipeline pipeline, @UnknownKeyFor @NonNull @Initialized Coder<ErrorT> coder) {
            this.sinkTransform = sinkTransform;
            this.pipeline = pipeline;
            this.coder = coder;
        }

        private void readObject(@UnknownKeyFor @NonNull @Initialized ObjectInputStream aInputStream) throws @UnknownKeyFor @NonNull @Initialized ClassNotFoundException, @UnknownKeyFor @NonNull @Initialized IOException {
            aInputStream.defaultReadObject();
            this.errorCollections = new ArrayList<PCollection<ErrorT>>();
        }

        @Override
        public void addErrorCollection(@UnknownKeyFor @NonNull @Initialized PCollection<ErrorT> errorCollection) {
            if (this.isClosed()) {
                throw new IllegalStateException("Error collections cannot be added after Error Handler is closed");
            }
            this.errorCollections.add(errorCollection);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized boolean isClosed() {
            return this.closed;
        }

        @Override
        public @Nullable OutputT getOutput() {
            if (!this.isClosed()) {
                throw new IllegalStateException("ErrorHandler must be finalized before the output can be returned");
            }
            return this.sinkOutput;
        }

        @Override
        public void close() {
            PCollection flattened;
            if (this.closed) {
                throw new IllegalStateException("Error handler is already closed, and may not be closed twice");
            }
            this.closed = true;
            if (this.errorCollections.isEmpty()) {
                LOG.info("Empty list of error pcollections passed to ErrorHandler.");
                flattened = (PCollection)this.pipeline.apply(Create.empty(this.coder));
            } else {
                flattened = (PCollection)PCollectionList.of(this.errorCollections).apply(Flatten.pCollections());
            }
            LOG.debug("{} error collections are being sent to {}", (Object)this.errorCollections.size(), (Object)this.sinkTransform.getName());
            String sinkTransformName = this.sinkTransform.getName();
            this.sinkOutput = ((PCollection)flattened.apply("Record Error Metrics to " + sinkTransformName, new WriteErrorMetrics(sinkTransformName))).apply("Write to error Sink", this.sinkTransform.addAnnotation("FeatureMetric", "ErrorHandler".getBytes(StandardCharsets.UTF_8)));
        }

        public static class WriteErrorMetrics<@UnknownKeyFor ErrorT>
        extends PTransform<PCollection<ErrorT>, PCollection<ErrorT>> {
            private final @UnknownKeyFor @NonNull @Initialized Counter errorCounter;

            public WriteErrorMetrics(@UnknownKeyFor @NonNull @Initialized String sinkTransformName) {
                this.errorCounter = Metrics.counter("ErrorMetrics", sinkTransformName + "-input");
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized PCollection<ErrorT> expand(@UnknownKeyFor @NonNull @Initialized PCollection<ErrorT> input) {
                return (PCollection)input.apply(ParDo.of(new CountErrors(this.errorCounter)));
            }

            public static class CountErrors<@UnknownKeyFor ErrorT>
            extends DoFn<ErrorT, ErrorT> {
                private final @UnknownKeyFor @NonNull @Initialized Counter errorCounter;

                public CountErrors(@UnknownKeyFor @NonNull @Initialized Counter errorCounter) {
                    this.errorCounter = errorCounter;
                }

                @DoFn.ProcessElement
                public void processElement(@DoFn.Element ErrorT error, @UnknownKeyFor @NonNull @Initialized DoFn.OutputReceiver<ErrorT> receiver) {
                    this.errorCounter.inc();
                    receiver.output(error);
                }
            }
        }
    }
}

