/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.apache.beam.sdk.annotations.Internal;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

@Internal
public class ExposedByteArrayOutputStream
extends ByteArrayOutputStream {
    private @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] swappedBuffer;
    private @UnknownKeyFor @NonNull @Initialized boolean isFallback = false;

    private void fallback() {
        this.isFallback = true;
        if (this.swappedBuffer != null) {
            byte[] tempBuffer = this.buf;
            this.count = 0;
            this.buf = this.swappedBuffer;
            super.write(tempBuffer, 0, tempBuffer.length);
            this.swappedBuffer = null;
        }
    }

    public synchronized void writeAndOwn(@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] b) throws @UnknownKeyFor @NonNull @Initialized IOException {
        if (b.length == 0) {
            return;
        }
        if (this.count == 0) {
            this.swappedBuffer = this.buf;
            this.buf = b;
            this.count = b.length;
        } else {
            this.fallback();
            super.write(b);
        }
    }

    @Override
    public synchronized void write(@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] b, @UnknownKeyFor @NonNull @Initialized int off, @UnknownKeyFor @NonNull @Initialized int len) {
        this.fallback();
        super.write(b, off, len);
    }

    @Override
    public synchronized void write(@UnknownKeyFor @NonNull @Initialized int b) {
        this.fallback();
        super.write(b);
    }

    @Override
    public synchronized @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] toByteArray() {
        if (!this.isFallback && this.count > 0) {
            return this.buf;
        }
        return super.toByteArray();
    }

    @Override
    public synchronized void reset() {
        if (this.count == 0) {
            return;
        }
        this.count = 0;
        if (this.isFallback) {
            this.isFallback = false;
        } else {
            this.buf = this.swappedBuffer;
            this.swappedBuffer = null;
        }
    }
}

