/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.server;

import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.X509TrustManager;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;

public class ServerConnectionManager {
    private static final String SSL = "TLSv1.2";
    private static final String KEYSTORE_SYSTEM_PROPERTY = "javax.net.ssl.keyStore";
    private static ServerConnectionManager serverConnectionManager;
    private PoolingHttpClientConnectionManager manager;

    private ServerConnectionManager() {
        if (ServerConnectionManager.needToInitializeSSLContext()) {
            try {
                SSLContext context = SSLContext.getInstance(SSL);
                context.init(new KeyManager[0], new X509TrustManager[]{ServerConnectionManager.getDefaultTrustManager()}, new SecureRandom());
                SSLContext.setDefault(context);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.manager = new PoolingHttpClientConnectionManager();
        this.manager.setDefaultMaxPerRoute(100);
        this.manager.setMaxTotal(200);
    }

    private static boolean needToInitializeSSLContext() {
        return System.getProperty(KEYSTORE_SYSTEM_PROPERTY) == null;
    }

    public static ServerConnectionManager getInstance() {
        if (serverConnectionManager == null) {
            serverConnectionManager = new ServerConnectionManager();
        }
        return serverConnectionManager;
    }

    public HttpClient createHttpClient() {
        return HttpClients.custom().setConnectionManager((HttpClientConnectionManager)this.manager).build();
    }

    public void shutdown() {
        this.manager.shutdown();
    }

    private static X509TrustManager getDefaultTrustManager() {
        return new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String param) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String param) throws CertificateException {
                for (X509Certificate cert : certs) {
                    cert.checkValidity();
                }
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }
        };
    }

    static void reset() {
        serverConnectionManager = null;
    }
}

