/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.flattener;

import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.RowDataUtil;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.flattener.FlattenerData;
import org.apache.hop.pipeline.transforms.flattener.FlattenerMeta;

public class Flattener
extends BaseTransform<FlattenerMeta, FlattenerData> {
    private static final Class<?> PKG = FlattenerMeta.class;

    public Flattener(TransformMeta transformMeta, FlattenerMeta meta, FlattenerData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(transformMeta, (ITransformMeta)meta, (ITransformData)data, copyNr, pipelineMeta, pipeline);
    }

    public boolean processRow() throws HopException {
        Object[] r = this.getRow();
        if (r == null) {
            if (((FlattenerData)this.data).processed > 0) {
                Object[] outputRowData = this.createOutputRow(((FlattenerData)this.data).previousRow);
                this.putRow(((FlattenerData)this.data).outputRowMeta, outputRowData);
            }
            this.setOutputDone();
            return false;
        }
        if (this.first) {
            ((FlattenerData)this.data).inputRowMeta = this.getInputRowMeta();
            ((FlattenerData)this.data).outputRowMeta = ((FlattenerData)this.data).inputRowMeta.clone();
            ((FlattenerMeta)this.meta).getFields(((FlattenerData)this.data).outputRowMeta, this.getTransformName(), null, null, (IVariables)this, this.metadataProvider);
            ((FlattenerData)this.data).fieldNr = ((FlattenerData)this.data).inputRowMeta.indexOfValue(((FlattenerMeta)this.meta).getFieldName());
            if (((FlattenerData)this.data).fieldNr < 0) {
                this.logError(BaseMessages.getString(PKG, (String)"Flattener.Log.FieldCouldNotFound", (String[])new String[]{((FlattenerMeta)this.meta).getFieldName()}));
                this.setErrors(1L);
                this.stopAll();
                return false;
            }
            ((FlattenerData)this.data).targetResult = new Object[((FlattenerMeta)this.meta).getTargetFields().size()];
            this.first = false;
        }
        ((FlattenerData)this.data).targetResult[((FlattenerData)this.data).processed++] = r[((FlattenerData)this.data).fieldNr];
        if (((FlattenerData)this.data).processed >= ((FlattenerMeta)this.meta).getTargetFields().size()) {
            Object[] outputRowData = this.createOutputRow(r);
            this.putRow(((FlattenerData)this.data).outputRowMeta, outputRowData);
            ((FlattenerData)this.data).targetResult = new Object[((FlattenerMeta)this.meta).getTargetFields().size()];
            ((FlattenerData)this.data).processed = 0;
        }
        ((FlattenerData)this.data).previousRow = r;
        if (this.checkFeedback(this.getLinesRead())) {
            this.logBasic(BaseMessages.getString(PKG, (String)"Flattener.Log.LineNumber", (String[])new String[0]) + this.getLinesRead());
        }
        return true;
    }

    private Object[] createOutputRow(Object[] rowData) {
        int i;
        Object[] outputRowData = RowDataUtil.allocateRowData((int)((FlattenerData)this.data).outputRowMeta.size());
        int outputIndex = 0;
        for (i = 0; i < ((FlattenerData)this.data).inputRowMeta.size(); ++i) {
            if (i == ((FlattenerData)this.data).fieldNr) continue;
            outputRowData[outputIndex++] = rowData[i];
        }
        for (i = 0; i < ((FlattenerData)this.data).targetResult.length; ++i) {
            outputRowData[outputIndex++] = ((FlattenerData)this.data).targetResult[i];
        }
        return outputRowData;
    }
}

