/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.streamschemamerge;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.Const;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopPluginException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.exception.HopValueException;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transform.stream.IStream;
import org.apache.hop.pipeline.transform.stream.Stream;
import org.apache.hop.pipeline.transform.stream.StreamIcon;
import org.apache.hop.pipeline.transforms.streamschemamerge.SchemaMapper;
import org.apache.hop.pipeline.transforms.streamschemamerge.StreamSchema;
import org.apache.hop.pipeline.transforms.streamschemamerge.StreamSchemaData;
import org.w3c.dom.Node;

@Transform(id="StreamSchema", image="streamschemamerge.svg", name="i18n::StreamSchemaTransform.Name", description="i18n::StreamSchemaTransform.TooltipDesc", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Flow", keywords={"i18n::StreamSchemaMeta.keyword"}, documentationUrl="/pipeline/transforms/streamschemamerge.html")
public class StreamSchemaMeta
extends BaseTransformMeta<StreamSchema, StreamSchemaData> {
    private static final Class<?> PKG = StreamSchemaMeta.class;
    private ArrayList<String> transformsToMerge = new ArrayList();

    public boolean excludeFromRowLayoutVerification() {
        return true;
    }

    public void setDefault() {
    }

    public String[] getTransformsToMerge() {
        if (this.transformsToMerge == null) {
            return new String[0];
        }
        return this.transformsToMerge.toArray(new String[this.transformsToMerge.size()]);
    }

    public int getNumberOfTransforms() {
        if (this.transformsToMerge == null) {
            return 0;
        }
        return this.transformsToMerge.size();
    }

    public void setTransformsToMerge(String[] arrayOfTransforms) {
        this.transformsToMerge = new ArrayList();
        Collections.addAll(this.transformsToMerge, arrayOfTransforms);
    }

    public Object clone() {
        Object retval = super.clone();
        return retval;
    }

    public String getXml() throws HopValueException {
        StringBuilder xml = new StringBuilder();
        xml.append("    <transforms>" + Const.CR);
        for (String transformName : this.transformsToMerge) {
            xml.append("      <transform>" + Const.CR);
            xml.append("        " + XmlHandler.addTagValue((String)"name", (String)transformName));
            xml.append("        </transform>" + Const.CR);
        }
        xml.append("      </transforms>" + Const.CR);
        return xml.toString();
    }

    public void loadXml(Node transformNode, IHopMetadataProvider metadataProvider) throws HopXmlException {
        this.readData(transformNode);
    }

    private void readData(Node transformNode) throws HopXmlException {
        try {
            Node transforms = XmlHandler.getSubNode((Node)transformNode, (String)"transforms");
            int nrtransforms = XmlHandler.countNodes((Node)transforms, (String)"transform");
            this.transformsToMerge.clear();
            for (int i = 0; i < nrtransforms; ++i) {
                this.getTransformIOMeta().addStream((IStream)new Stream(IStream.StreamType.INFO, null, "Streams to Merge", StreamIcon.INFO, null));
            }
            List infoStreams = this.getTransformIOMeta().getInfoStreams();
            for (int i = 0; i < nrtransforms; ++i) {
                Node fnode = XmlHandler.getSubNodeByNr((Node)transforms, (String)"transform", (int)i);
                String name = XmlHandler.getTagValue((Node)fnode, (String)"name");
                this.transformsToMerge.add(name);
                ((IStream)infoStreams.get(i)).setSubject(name);
            }
        }
        catch (Exception e) {
            throw new HopXmlException("Unable to load transform info from XML", (Throwable)e);
        }
    }

    public void getFields(IRowMeta inputRowMeta, String name, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) throws HopTransformException {
        try {
            SchemaMapper schemaMapping = new SchemaMapper(info);
            IRowMeta base = schemaMapping.getRowMeta();
            for (int i = 0; i < base.size(); ++i) {
                base.getValueMeta(i).setOrigin(name);
            }
            inputRowMeta.mergeRowMeta(base);
        }
        catch (HopPluginException e) {
            throw new HopTransformException("Hop plugin exception trying to resolve fields");
        }
    }

    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        if (input.length > 0) {
            CheckResult cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"StreamSchemaTransform.CheckResult.ReceivingRows.OK", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            CheckResult cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"StreamSchemaTransform.CheckResult.ReceivingRows.ERROR", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
    }

    public void searchInfoAndTargetTransforms(List<TransformMeta> transforms) {
        for (IStream stream : this.getTransformIOMeta().getInfoStreams()) {
            stream.setTransformMeta(TransformMeta.findTransform(transforms, (String)stream.getSubject()));
        }
    }

    public void resetTransformIoMeta() {
    }
}

