/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.debug.pipeline;

import java.util.Date;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.extension.ExtensionPoint;
import org.apache.hop.core.extension.IExtensionPoint;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.engine.IPipelineEngine;

@ExtensionPoint(id="LogPipelineExecutionTimeExtensionPoint", description="Logs execution time of a transformation when it finishes", extensionPointId="PipelinePrepareExecution")
public class LogPipelineExecutionTimeExtensionPoint
implements IExtensionPoint<IPipelineEngine<PipelineMeta>> {
    public void callExtensionPoint(ILogChannel log, IVariables variables, IPipelineEngine<PipelineMeta> pipeline) throws HopException {
        String durationVariable = pipeline.getVariable("HOP_DEBUG_DURATION", "Y");
        if ("N".equalsIgnoreCase(durationVariable) || "FALSE".equalsIgnoreCase(durationVariable)) {
            return;
        }
        pipeline.addExecutionFinishedListener(engine -> {
            Date startDate = pipeline.getExecutionStartDate();
            Date endDate = pipeline.getExecutionEndDate();
            if (startDate != null && endDate != null) {
                long startTime = startDate.getTime();
                long endTime = endDate.getTime();
                double seconds = ((double)endTime - (double)startTime) / 1000.0;
                log.logBasic("Pipeline duration : " + seconds + " seconds [ " + Utils.getDurationHMS((double)seconds) + " ]");
            }
        });
    }
}

