/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.BidiFlag;
import com.ibm.as400.access.BidiText;
import com.ibm.as400.access.BidiTransform;
import java.util.Arrays;
import java.util.Collections;
import java.util.Vector;

class BidiOrder {
    private static final int UBAT_B = 0;
    private static final int UBAT_S = 1;
    private static final int UBAT_L = 2;
    private static final int UBAT_R = 3;
    private static final int UBAT_EN = 4;
    private static final int UBAT_AN = 5;
    private static final int UBAT_W = 6;
    private static final int UBAT_N = 7;
    private static final int UBAT_BD = 8;
    private static final int UBAT_AL = 9;
    private static final int UBAT_ET = 10;
    private static final int UBAT_ES = 11;
    private static final int UBAT_CS = 12;
    private static final int UBAT_NSM = 13;
    private static final int ITIL = 8;
    private static final int ITCOND = 9;
    private static final byte UBAT_N_SWAP = -7;
    private static final byte IMP_LTR = 4;
    private static final byte IMP_RTL = 8;
    private static final byte ORIG = 0;
    private static final byte FINAL = 1;
    private static final char LRM = '\u200e';
    private static final char RLM = '\u200f';
    private static final int BEFORE = 0;
    private static final int AFTER = 65536;
    private static final char NODELIM = '\uffff';
    private static final char[][] notSpacing = new char[][]{{'\u0300', '\u0385'}, {'\u0483', '\u0486'}, {'\u05b0', '\u05bd'}, {'\u05bf', '\u05bf'}, {'\u05c1', '\u05c2'}, {'\u05f5', '\u05f5'}, {'\u064b', '\u0652'}, {'\u0670', '\u0670'}, {'\u06d6', '\u06e4'}, {'\u06e7', '\u06e8'}, {'\u06ea', '\u06ed'}, {'\u0901', '\u0902'}, {'\u093c', '\u093c'}, {'\u0941', '\u0948'}, {'\u094d', '\u094d'}, {'\u0951', '\u0954'}, {'\u0962', '\u0963'}, {'\u0981', '\u0981'}, {'\u09bc', '\u09bc'}, {'\u09c1', '\u09c4'}, {'\u09cd', '\u09cd'}, {'\u09e2', '\u09e3'}, {'\u0a02', '\u0a02'}, {'\u0a3c', '\u0a3c'}, {'\u0a41', '\u0a4c'}, {'\u0a70', '\u0a71'}, {'\u0a81', '\u0a82'}, {'\u0abc', '\u0abc'}, {'\u0ac1', '\u0ac8'}, {'\u0acd', '\u0acd'}, {'\u0b01', '\u0b01'}, {'\u0b3c', '\u0b3c'}, {'\u0b3f', '\u0b3f'}, {'\u0b41', '\u0b43'}, {'\u0b4d', '\u0b4d'}, {'\u0bc0', '\u0bc0'}, {'\u0bcd', '\u0bcd'}, {'\u0c3e', '\u0c40'}, {'\u0c46', '\u0c56'}, {'\u0cbf', '\u0cbf'}, {'\u0cc6', '\u0cc6'}, {'\u0ccc', '\u0ccd'}, {'\u0d41', '\u0d43'}, {'\u0d4d', '\u0d4d'}, {'\u0e31', '\u0e31'}, {'\u0e34', '\u0e3a'}, {'\u0e47', '\u0e4d'}, {'\u0eb1', '\u0eb1'}, {'\u0eb4', '\u0ebc'}, {'\u0ec8', '\u0ecd'}, {'\u1026', '\u102a'}, {'\u102e', '\u102e'}, {'\u1030', '\u1030'}, {'\u1036', '\u1037'}, {'\u103b', '\u103b'}, {'\u103d', '\u103e'}, {'\u104b', '\u104c'}, {'\u20d0', '\u20ff'}, {'\u302a', '\u302f'}, {'\u3099', '\u309a'}};
    private static final char[][] symPairs = new char[][]{{'(', ')'}, {')', '('}, {'<', '>'}, {'>', '<'}, {'[', ']'}, {']', '['}, {'{', '}'}, {'}', '{'}, {'\u00ab', '\u00bb'}, {'\u00bb', '\u00ab'}, {'\u207d', '\u207e'}, {'\u207e', '\u207d'}, {'\u208d', '\u208e'}, {'\u208e', '\u208d'}, {'\u2329', '\u232a'}, {'\u232a', '\u2329'}, {'\ufe59', '\ufe5a'}, {'\ufe5a', '\ufe59'}, {'\ufe5b', '\ufe5c'}, {'\ufe5c', '\ufe5b'}, {'\ufe5d', '\ufe5e'}, {'\ufe5e', '\ufe5d'}, {'\ufe64', '\ufe65'}, {'\ufe65', '\ufe64'}};
    private static final short[][] impTab_LTR = new short[][]{{0, 0, 0, 3, 0, 1, 0, 0, 0, 0}, {0, 0, 0, 3, 0, 1, 2, 2, 2, 0}, {0, 0, 0, 3, 0, 17, 2, 2, 0, 1}, {0, 0, 0, 3, 5, 5, 4, 4, 1, 0}, {0, 0, 0, 3, 21, 21, 4, 4, 0, 1}, {0, 0, 0, 3, 5, 5, 4, 4, 2, 0}};
    private static final short[][] impTab_RTL = new short[][]{{0, 0, 2, 0, 1, 1, 0, 0, 0, 0}, {0, 0, 2, 0, 1, 1, 0, 0, 1, 0}, {0, 0, 2, 0, 2, 1, 3, 3, 1, 0}, {0, 0, 2, 0, 2, 33, 3, 3, 0, 1}};
    private static final short[][] impTab_LTR_r = new short[][]{{0, 0, 0, 2, 0, 1, 0, 0, 0, 0}, {0, 0, 0, 2, 0, 1, 3, 3, 2, 0}, {0, 0, 0, 2, 4, 1, 3, 3, 1, 0}, {0, 0, 0, 34, 4, 4, 3, 3, 1, 1}, {0, 0, 0, 34, 4, 4, 3, 3, 2, 1}};
    private static final short[][] impTab_RTL_r = new short[][]{{0, 0, 3, 0, 1, 2, 0, 0, 0, 0}, {32, 32, 3, 32, 1, 34, 5, 5, 1, 1}, {0, 0, 3, 0, 1, 2, 0, 0, 1, 0}, {0, 0, 3, 0, 3, 2, 4, 4, 1, 0}, {0, 0, 3, 0, 3, 34, 4, 4, 0, 1}, {32, 32, 3, 32, 1, 34, 5, 5, 0, 1}};
    private static final short[][] impTab_LTR_w = new short[][]{{0, 0, 0, 2, 1, 1, 0, 0, 0, 0}, {0, 0, 0, 2, 1, 1, 0, 0, 2, 0}, {0, 0, 0, 2, 4, 4, 3, 3, 1, 0}, {0, 0, 0, 2, 20, 20, 3, 3, 0, 1}, {0, 0, 0, 2, 4, 4, 3, 3, 2, 0}};
    private static final short[][] impTab_LTR_m = new short[][]{{0, 0, 0, 99, 0, 1, 0, 0, 0, 0}, {0, 0, 0, 99, 0, 1, 2, 2, 2, 0}, {0, 0, 0, 99, 0, 33, 2, 2, 1, 1}, {0, 0, 0, 99, 85, 86, 4, 4, 1, 0}, {48, 48, 48, 67, 85, 86, 4, 4, 1, 1}, {48, 48, 48, 67, 5, 86, 4, 4, 2, 0}, {48, 48, 48, 67, 85, 6, 4, 4, 2, 0}};
    private static final short[][] impTab_RTL_m = new short[][]{{0, 0, 3, 0, 1, 1, 0, 0, 0, 0}, {0, 0, 115, 0, 1, 1, 2, 2, 1, 0}, {0, 0, 115, 0, 1, 1, 2, 2, 0, 0}, {0, 0, 3, 0, 3, 134, 4, 4, 1, 0}, {144, 144, 163, 144, 5, 134, 4, 4, 0, 1}, {144, 144, 163, 144, 5, 134, 4, 4, 1, 1}, {144, 144, 163, 144, 6, 6, 4, 4, 1, 1}};
    private static final short[][] impTab_LTR_wm = new short[][]{{0, 0, 0, 98, 1, 1, 0, 0, 0, 0}, {0, 0, 0, 98, 1, 1, 0, 0, 2, 0}, {0, 0, 0, 98, 84, 84, 3, 3, 1, 0}, {48, 48, 48, 66, 84, 84, 3, 3, 1, 1}, {48, 48, 48, 66, 4, 4, 3, 3, 2, 0}};
    int ucb_ix;
    byte ucb_outLev;
    byte ucb_basLev;
    byte ucb_curLev;
    int ucb_impSta;
    int ucb_condPos;
    int ucb_xType;
    byte ucb_wTarget;
    BidiFlag ics_num_flag;
    boolean ics_symmetric;
    BidiFlag ics_orient_in;
    BidiFlag ics_orient_out;
    BidiFlag ics_type_in;
    BidiFlag ics_type_out;
    BidiTransform myBdx;
    int ics_size;
    char[] ics_buffer_in;
    char[] ics_buffer_out;
    boolean invertInput;
    boolean visToVis;
    short[][] impTab;
    byte[][] typeArray;
    boolean insertMarkers;
    int insertCnt;
    int removeCnt;
    int startL2EN;
    int lastStrongRTL;
    boolean reqImpToImp;
    int impToImpOrient;
    int impToImpPhase;
    char delim1;
    char delim2;

    BidiOrder() {
    }

    private static boolean odd(int n) {
        return (n & 1) == 1;
    }

    private static boolean even(int n) {
        return (n & 1) == 0;
    }

    private static void invertMap(int[] buffer, int lower_limit, int upper_limit) {
        while (lower_limit < upper_limit) {
            int temp = buffer[lower_limit];
            buffer[lower_limit] = buffer[upper_limit];
            buffer[upper_limit] = temp;
            ++lower_limit;
            --upper_limit;
        }
    }

    private static void invertMap(byte[] buffer, int lower_limit, int upper_limit) {
        while (lower_limit < upper_limit) {
            byte temp = buffer[lower_limit];
            buffer[lower_limit] = buffer[upper_limit];
            buffer[upper_limit] = temp;
            ++lower_limit;
            --upper_limit;
        }
    }

    private static boolean UCQSPAC(char x) {
        int low = 0;
        int high = notSpacing.length - 1;
        while (low <= high) {
            int mid = (low + high) / 2;
            if (x < notSpacing[mid][0]) {
                high = mid - 1;
                continue;
            }
            if (x > notSpacing[mid][1]) {
                low = mid + 1;
                continue;
            }
            return false;
        }
        return true;
    }

    private static char UCQSYMM(char x) {
        int low = 0;
        int high = 23;
        while (low <= high) {
            int mid = (low + high) / 2;
            char c = symPairs[mid][0];
            if (x < c) {
                high = mid - 1;
                continue;
            }
            if (x > c) {
                low = mid + 1;
                continue;
            }
            return symPairs[mid][1];
        }
        return x;
    }

    private void fillTypeArray() {
        boolean isArabic = false;
        byte[][] ta = this.typeArray;
        int delimState = 0;
        block12: for (int i = 0; i < this.ics_size; ++i) {
            byte cType;
            char c = this.ics_buffer_in[i];
            ta[i][0] = cType = BidiOrder.getChType(c, this.myBdx.wordBreak);
            ta[i][1] = 7;
            if (this.delim1 != '\uffff') {
                if (delimState == 0) {
                    if (c == this.delim1) {
                        delimState = 1;
                    }
                    cType = 0;
                } else if (delimState == 1) {
                    if (c == this.delim2) {
                        if (i + 1 < this.ics_size && this.ics_buffer_in[i + 1] == this.delim2) {
                            delimState = 2;
                        } else {
                            delimState = 0;
                            cType = 0;
                        }
                    }
                } else {
                    delimState = 1;
                }
            }
            if (this.visToVis) continue;
            switch (cType) {
                case 0: {
                    isArabic = false;
                    ta[i][1] = 0;
                    continue block12;
                }
                case 1: {
                    ta[i][1] = 1;
                    continue block12;
                }
                case 2: {
                    isArabic = false;
                    ta[i][1] = 2;
                    continue block12;
                }
                case 3: {
                    isArabic = false;
                    ta[i][1] = 3;
                    continue block12;
                }
                case 9: {
                    isArabic = true;
                    ta[i][1] = 3;
                    continue block12;
                }
                case 4: {
                    int wType;
                    if (isArabic) {
                        wType = 5;
                    } else {
                        wType = 4;
                        if (i >= 2 && ta[i - 1][0] == 11 && ta[i - 2][0] == 4) {
                            ta[i - 1][1] = 4;
                        }
                        int prev = i - 1;
                        while (prev >= 0 && ta[prev][0] == 10) {
                            ta[prev--][1] = 4;
                        }
                    }
                    if (i >= 2 && ta[i - 1][0] == 12 && ta[i - 2][0] == 4) {
                        ta[i - 1][1] = wType;
                    }
                    ta[i][1] = wType;
                    continue block12;
                }
                case 5: {
                    if (i >= 2 && ta[i - 1][0] == 12 && ta[i - 2][1] == 5) {
                        ta[i - 1][1] = 5;
                    }
                    ta[i][1] = 5;
                    continue block12;
                }
                case 6: {
                    ta[i][1] = 6;
                    continue block12;
                }
                case 10: {
                    if (i <= 0 || ta[i - 1][1] != 4) continue block12;
                    ta[i][1] = 4;
                    continue block12;
                }
                case 13: {
                    if (i <= 0) continue block12;
                    ta[i][1] = ta[i - 1][1];
                }
            }
        }
    }

    private void fillTypeArray2() {
        boolean isArabic = false;
        byte[][] ta = this.typeArray;
        block11: for (int i = 0; i < this.ics_size; ++i) {
            int k = this.myBdx.dstToSrcMap[i];
            byte cType = ta[k][0];
            if (this.delim1 != '\uffff' && ta[k][1] == 0) {
                cType = 0;
            } else {
                ta[k][1] = 7;
            }
            switch (cType) {
                case 0: {
                    isArabic = false;
                    ta[k][1] = 0;
                    continue block11;
                }
                case 1: {
                    ta[k][1] = 1;
                    continue block11;
                }
                case 2: {
                    isArabic = false;
                    ta[k][1] = 2;
                    continue block11;
                }
                case 3: {
                    isArabic = false;
                    ta[k][1] = 3;
                    continue block11;
                }
                case 9: {
                    isArabic = true;
                    ta[k][1] = 3;
                    continue block11;
                }
                case 4: {
                    int wType;
                    if (isArabic) {
                        wType = 5;
                    } else {
                        wType = 4;
                        if (i >= 2 && ta[this.myBdx.dstToSrcMap[i - 1]][0] == 11 && ta[this.myBdx.dstToSrcMap[i - 2]][0] == 4) {
                            ta[this.myBdx.dstToSrcMap[i - 1]][1] = 4;
                        }
                        int prev = i - 1;
                        while (prev >= 0 && ta[this.myBdx.dstToSrcMap[prev]][0] == 10) {
                            ta[this.myBdx.dstToSrcMap[prev--]][1] = 4;
                        }
                    }
                    if (i >= 2 && ta[this.myBdx.dstToSrcMap[i - 1]][0] == 12 && ta[this.myBdx.dstToSrcMap[i - 2]][0] == 4) {
                        ta[this.myBdx.dstToSrcMap[i - 1]][1] = wType;
                    }
                    ta[k][1] = wType;
                    continue block11;
                }
                case 5: {
                    if (i >= 2 && ta[this.myBdx.dstToSrcMap[i - 1]][0] == 12 && ta[this.myBdx.dstToSrcMap[i - 2]][0] == 5) {
                        ta[this.myBdx.dstToSrcMap[i - 1]][1] = 5;
                    }
                    ta[k][1] = 5;
                    continue block11;
                }
                case 6: {
                    ta[k][1] = 6;
                    continue block11;
                }
                case 10: {
                    if (i <= 0 || ta[this.myBdx.dstToSrcMap[i - 1]][1] != 4) continue block11;
                    ta[k][1] = 4;
                    continue block11;
                }
            }
        }
    }

    private void addPoint(int pos, int after, char insert) {
        if (this.myBdx.insertPoints == null) {
            this.myBdx.insertPoints = new Vector(10, 50);
        }
        this.myBdx.insertPoints.addElement(Long.valueOf((pos << 17) + after + insert));
    }

    private int afterAN(int i) {
        while (i < this.ics_size && this.typeArray[i][1] == 5) {
            ++i;
        }
        return i;
    }

    private int afterENAN(int i) {
        while (i < this.ics_size && (this.typeArray[i][1] == 4 || this.typeArray[i][1] == 5)) {
            ++i;
        }
        return i;
    }

    private int beforeENAN(int i) {
        while (i >= 0 && (this.typeArray[i][1] == 4 || this.typeArray[i][1] == 5)) {
            --i;
        }
        return i;
    }

    private void implicitProcessing() {
        short sCond;
        int pos;
        byte oldLevel;
        int i;
        int newIS = this.impTab[this.ucb_impSta][this.ucb_xType];
        short Special = (short)(newIS >> 4);
        newIS = (short)(newIS & 0xF);
        short newIL = this.impTab[newIS][8];
        byte newLevel = (byte)(this.ucb_curLev + newIL);
        if (Special > 0) {
            switch (Special) {
                case 1: {
                    byte level = (byte)(this.ucb_curLev + 1);
                    for (i = this.ucb_condPos; i < this.ucb_ix; ++i) {
                        oldLevel = this.myBdx.propertyMap[i];
                        this.myBdx.propertyMap[i] = level;
                        if (!this.ics_symmetric || !BidiOrder.odd(oldLevel ^ level)) continue;
                        pos = this.impToImpPhase == 2 ? this.myBdx.dstToSrcMap[i] : i;
                        if (this.typeArray[pos][0] == 7) {
                            this.typeArray[pos][0] = -7;
                            continue;
                        }
                        if (this.typeArray[pos][0] != -7) continue;
                        this.typeArray[pos][0] = 7;
                    }
                    this.ucb_condPos = -1;
                    break;
                }
                case 2: {
                    this.ucb_condPos = -1;
                    break;
                }
                case 3: {
                    if (this.startL2EN >= 0) {
                        this.addPoint(this.startL2EN, 0, '\u200e');
                    }
                    this.startL2EN = -1;
                    if (this.myBdx.insertPoints == null || this.myBdx.insertPoints.size() <= this.insertCnt) {
                        this.lastStrongRTL = -1;
                        break;
                    }
                    for (i = this.lastStrongRTL + 1; i < this.ucb_ix; ++i) {
                        this.myBdx.propertyMap[i] = newLevel;
                        this.typeArray[i][0] = (byte)Math.abs(this.typeArray[i][0]);
                    }
                    this.insertCnt = this.myBdx.insertPoints.size();
                    this.lastStrongRTL = -1;
                    break;
                }
                case 4: {
                    if (this.myBdx.insertPoints != null) {
                        this.myBdx.insertPoints.setSize(this.insertCnt);
                    }
                    this.startL2EN = -1;
                    this.lastStrongRTL = this.ucb_ix;
                    break;
                }
                case 5: {
                    this.ucb_condPos = -1;
                    if (this.ucb_xType == 5 && this.typeArray[this.ucb_ix][0] == 5 && !this.myBdx.winCompatible) {
                        if (this.startL2EN == -1) {
                            this.lastStrongRTL = this.afterAN(this.ucb_ix) - 1;
                            break;
                        }
                        if (this.startL2EN >= 0) {
                            this.addPoint(this.startL2EN, 0, '\u200e');
                            this.startL2EN = -2;
                        }
                        this.addPoint(this.ucb_ix, 0, '\u200e');
                        break;
                    }
                    if (this.startL2EN != -1) break;
                    this.startL2EN = this.ucb_ix;
                    break;
                }
                case 6: {
                    this.lastStrongRTL = this.ucb_ix;
                    break;
                }
                case 7: {
                    i = this.beforeENAN(this.ucb_ix - 1);
                    if (i < 0) break;
                    this.addPoint(i, 0, '\u200f');
                    this.insertCnt = this.myBdx.insertPoints.size();
                    break;
                }
                case 8: {
                    pos = this.afterENAN(this.ucb_ix);
                    i = this.beforeENAN(this.ucb_ix);
                    if ((pos >= this.ics_size || this.typeArray[pos][1] == 2 || this.typeArray[pos][1] == 3) && i >= 0 && this.typeArray[i][1] == 2) break;
                    this.addPoint(pos - 1, 65536, '\u200e');
                    this.addPoint(i + 1, 0, '\u200e');
                    break;
                }
                case 9: {
                    if (this.myBdx.insertPoints != null) {
                        this.myBdx.insertPoints.setSize(this.insertCnt);
                    }
                    this.ucb_condPos = -1;
                    break;
                }
                case 10: {
                    if (this.myBdx.insertPoints == null) break;
                    this.insertCnt = this.myBdx.insertPoints.size();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException("invalid action number");
                }
            }
        }
        if ((sCond = this.impTab[newIS][9]) == 0) {
            if (this.ucb_condPos > -1) {
                for (i = this.ucb_condPos; i < this.ucb_ix; ++i) {
                    oldLevel = this.myBdx.propertyMap[i];
                    this.myBdx.propertyMap[i] = newLevel;
                    if (!this.ics_symmetric || !BidiOrder.odd(oldLevel ^ newLevel)) continue;
                    pos = this.impToImpPhase == 2 ? this.myBdx.dstToSrcMap[i] : i;
                    if (this.typeArray[pos][0] == 7) {
                        this.typeArray[pos][0] = -7;
                        continue;
                    }
                    if (this.typeArray[pos][0] != -7) continue;
                    this.typeArray[pos][0] = 7;
                }
                this.ucb_condPos = -1;
            }
        } else if (this.ucb_condPos == -1) {
            this.ucb_condPos = this.ucb_ix;
        }
        this.ucb_impSta = newIS;
        this.ucb_wTarget = this.ucb_xType == 0 ? (byte)0 : newLevel;
    }

    private static byte getChType(char x, boolean wordBreak) {
        if (wordBreak && x == ' ') {
            return 1;
        }
        return BidiOrder.getChType(x);
    }

    private static byte getChType(char x) {
        if (x == '\n' || x == '\r' || x >= '\u001c' && x <= '\u001e' || x == '\u0085' || x == '\u2029') {
            return 0;
        }
        if (x == '\t' || x == '\u000b' || x == '\u001f') {
            return 1;
        }
        if (x >= 'A' && x <= 'Z' || x >= 'a' && x <= 'z' || x >= '\u00c0' && x <= '\u00d6' || x >= '\u00d8' && x <= '\u00f6' || x >= '\u00f8' && x <= '\u058f' || x >= '\u0900' && x <= '\u10ff' || x == '\u200e' || x >= '\u20d0' && x <= '\u20ff' || x >= '\u2160' && x <= '\u2182' || x >= '\u3040' && x <= '\u9fff' || x >= '\uf900' && x <= '\ufb17' || x == '\ufe60' || x == '\ufe6b' || x == '\uff06' || x >= '\uff20' && x <= '\uff3a' || x >= '\uff41' && x <= '\uff5a' || x >= '\uff60' && x <= '\uffdf') {
            return 2;
        }
        if (x >= '\u0591' && x <= '\u05ff' || x == '\u200f' || x >= '\ufb1d' && x <= '\ufb4f') {
            return 3;
        }
        if (x >= '\u0600' && x <= '\u065f' || x >= '\u066e' && x <= '\u06ef' || x >= '\u06fa' && x <= '\u08ff' || x >= '\ufb50' && x <= '\ufdff' || x >= '\ufe70' && x <= '\ufefc') {
            return 9;
        }
        if (x >= '0' && x <= '9' || x >= '\u00b2' && x <= '\u00b3' || x == '\u00b9' || x >= '\u06f0' && x <= '\u06f9' || x == '\u2070' || x >= '\u2074' && x <= '\u2079' || x >= '\u2080' && x <= '\u2089' || x >= '\u2460' && x <= '\u249b' || x == '\u24ea' || x >= '\uff10' && x <= '\uff19') {
            return 4;
        }
        if (x >= '\u0660' && x <= '\u0669' || x >= '\u066b' && x <= '\u066c') {
            return 5;
        }
        if (x >= '#' && x <= '%' || x >= '\u00a2' && x <= '\u00a5' || x >= '\u00b0' && x <= '\u00b1' || x == '\u066a' || x >= '\u09f2' && x <= '\u09f3' || x == '\u0af1' || x == '\u0bf9' || x == '\u0e3f' || x == '\u17db' || x >= '\u2030' && x <= '\u2034' || x >= '\u207a' && x <= '\u207b' || x >= '\u208a' && x <= '\u208b' || x >= '\u20a0' && x <= '\u20b1' || x == '\u212e' || x >= '\u2212' && x <= '\u2213' || x == '\ufb29' || x == '\ufe5f' || x >= '\ufe62' && x <= '\ufe63' || x >= '\ufe69' && x <= '\ufe6a' || x >= '\uff03' && x <= '\uff05' || x == '\uff0b' || x == '\uff0d' || x >= '\uffe0' && x <= '\uffe1' || x >= '\uffe5' && x <= '\uffe6') {
            return 10;
        }
        if (x == '+' || x == '-' || x == '/' || x == '\uff0f') {
            return 11;
        }
        if (x == ',' || x == '.' || x == ':' || x == '\u00a0' || x == '\u060c' || x == '\ufe50' || x == '\ufe52' || x == '\ufe55' || x == '\uff0c' || x == '\uff0e' || x == '\uff1a') {
            return 12;
        }
        if (x == '\f' || x == ' ' || x == '\u1680' || x == '\u180e' || x >= '\u2000' && x <= '\u200a' || x == '\u2028' || x == '\u202f' || x == '\u205f' || x == '\u3000') {
            return 6;
        }
        if (x >= '\u202a' && x <= '\u202e' || x >= '\u206c' && x <= '\u206f') {
            return 8;
        }
        return 7;
    }

    private static int firstStrong(BidiText src) {
        int lim = src.offset + src.count;
        for (int i = src.offset; i < lim; ++i) {
            byte type = BidiOrder.getChType(src.data[i]);
            if (type == 2) {
                return 2;
            }
            if (type != 3 && type != 9) continue;
            return 3;
        }
        return 7;
    }

    private static int lastStrong(BidiText src) {
        int lim = src.offset + src.count;
        for (int i = lim - 1; i >= src.offset; --i) {
            byte type = BidiOrder.getChType(src.data[i]);
            if (type == 2) {
                return 2;
            }
            if (type != 3 && type != 9) continue;
            return 3;
        }
        return 7;
    }

    private void BaseLvl() {
        this.visToVis = false;
        this.ucb_basLev = this.ics_orient_in == BidiFlag.ORIENTATION_RTL ? (byte)1 : 0;
        this.ucb_outLev = this.ics_orient_out == BidiFlag.ORIENTATION_RTL ? (byte)1 : 0;
        this.ucb_curLev = this.ucb_basLev;
        if (this.ucb_basLev == 0 && this.ucb_outLev == 1) {
            this.ucb_curLev = (byte)2;
        }
        if (this.ics_type_in == BidiFlag.TYPE_VISUAL && this.ics_type_out == BidiFlag.TYPE_VISUAL) {
            this.visToVis = true;
        }
        if (this.myBdx.roundTrip) {
            this.impTab = this.ucb_basLev == 1 ? impTab_RTL_r : impTab_LTR_r;
        } else if (this.myBdx.winCompatible) {
            if (this.insertMarkers) {
                this.impTab = this.ucb_basLev == 1 ? impTab_RTL_m : impTab_LTR_wm;
                this.startL2EN = -1;
                this.lastStrongRTL = -1;
                if (this.myBdx.insertPoints != null) {
                    this.myBdx.insertPoints.setSize(0);
                }
            } else {
                this.impTab = this.ucb_basLev == 1 ? impTab_RTL : impTab_LTR_w;
            }
        } else if (this.insertMarkers) {
            this.impTab = this.ucb_basLev == 1 ? impTab_RTL_m : impTab_LTR_m;
            this.startL2EN = -1;
            this.lastStrongRTL = -1;
            if (this.myBdx.insertPoints != null) {
                this.myBdx.insertPoints.setSize(0);
            }
        } else {
            this.impTab = this.ucb_basLev == 1 ? impTab_RTL : impTab_LTR;
        }
        this.insertCnt = 0;
        this.removeCnt = 0;
        this.ucb_impSta = 0;
        this.ucb_condPos = -1;
    }

    private void pass2() {
        byte current_level;
        int i;
        byte lowest_level = 100;
        byte highest_level = 0;
        int flip_from = 0;
        int flip_to = this.ics_size - 1;
        for (i = 0; i < this.ics_size; ++i) {
            if (this.impToImpPhase != 2) {
                this.myBdx.dstToSrcMap[i] = i;
            }
            if ((current_level = this.myBdx.propertyMap[i]) < lowest_level) {
                lowest_level = current_level;
            }
            if (current_level <= highest_level) continue;
            highest_level = current_level;
        }
        if (this.reqImpToImp && this.impToImpOrient == 0) {
            return;
        }
        lowest_level = this.ics_orient_out == BidiFlag.ORIENTATION_RTL ? (byte)(lowest_level + 1 & 0xFFFFFFFE) : (byte)((byte)(lowest_level | 1));
        for (byte work_level = highest_level; work_level >= lowest_level; work_level = (byte)(work_level - 1)) {
            i = 0;
            while (i < this.ics_size) {
                current_level = this.myBdx.propertyMap[i];
                if (current_level < work_level) {
                    ++i;
                    continue;
                }
                flip_from = i;
                for (i = flip_from + 1; i < this.ics_size && this.myBdx.propertyMap[i] >= work_level; ++i) {
                }
                flip_to = i - 1;
                BidiOrder.invertMap(this.myBdx.dstToSrcMap, flip_from, flip_to);
            }
        }
    }

    private void pass3() {
        for (int i = 0; i < this.ics_size; ++i) {
            int logPos = this.myBdx.dstToSrcMap[i];
            char xchar = this.ics_buffer_in[logPos];
            byte xtype = this.typeArray[logPos][0];
            if (xtype == 4) {
                if (this.ics_num_flag == BidiFlag.NUMERALS_NATIONAL || this.ics_num_flag == BidiFlag.NUMERALS_CONTEXTUAL && this.typeArray[logPos][1] == 5) {
                    xchar = (char)(xchar + 1584);
                }
            } else if (xtype == 5) {
                if (this.ics_num_flag == BidiFlag.NUMERALS_NOMINAL) {
                    xchar = (char)(xchar - 1584);
                }
            } else if (xtype == -7) {
                xchar = BidiOrder.UCQSYMM(xchar);
            }
            this.ics_buffer_out[i] = xchar;
        }
    }

    synchronized void order(BidiText src, BidiText dst, BidiTransform bdx) {
        int pos;
        boolean dstToSrcMapRequired;
        int ipos;
        int type1;
        int i = 0;
        boolean j = false;
        if (src.count < 1) {
            if (dst.data == null) {
                dst.data = new char[0];
            }
            bdx.inpCount = 0;
            bdx.outCount = 0;
            return;
        }
        this.myBdx = bdx;
        this.ics_orient_in = src.flags.getOrientation();
        this.ics_orient_out = dst.flags.getOrientation();
        if (this.ics_orient_in == BidiFlag.ORIENTATION_CONTEXT_LTR || this.ics_orient_in == BidiFlag.ORIENTATION_CONTEXT_RTL) {
            type1 = BidiOrder.firstStrong(src);
            switch (type1) {
                case 2: {
                    this.ics_orient_in = BidiFlag.ORIENTATION_LTR;
                    break;
                }
                case 3: {
                    this.ics_orient_in = BidiFlag.ORIENTATION_RTL;
                    break;
                }
                case 7: {
                    this.ics_orient_in = this.ics_orient_in == BidiFlag.ORIENTATION_CONTEXT_RTL ? BidiFlag.ORIENTATION_RTL : BidiFlag.ORIENTATION_LTR;
                }
            }
        }
        if (this.ics_orient_out == BidiFlag.ORIENTATION_CONTEXT_LTR || this.ics_orient_out == BidiFlag.ORIENTATION_CONTEXT_RTL) {
            type1 = BidiOrder.firstStrong(src);
            switch (type1) {
                case 2: {
                    type1 = BidiOrder.lastStrong(src);
                    if (type1 == 3) {
                        this.ics_orient_out = BidiFlag.ORIENTATION_RTL;
                        break;
                    }
                    this.ics_orient_out = BidiFlag.ORIENTATION_LTR;
                    break;
                }
                case 3: {
                    this.ics_orient_out = BidiFlag.ORIENTATION_RTL;
                    break;
                }
                case 7: {
                    this.ics_orient_out = this.ics_orient_out == BidiFlag.ORIENTATION_CONTEXT_RTL ? BidiFlag.ORIENTATION_RTL : BidiFlag.ORIENTATION_LTR;
                }
            }
        }
        this.ics_type_in = src.flags.getType();
        this.ics_type_out = dst.flags.getType();
        boolean bl = this.reqImpToImp = this.ics_type_in == BidiFlag.TYPE_IMPLICIT && this.ics_type_out == BidiFlag.TYPE_IMPLICIT;
        if (this.myBdx.impToImp && this.reqImpToImp && this.ics_orient_in != this.ics_orient_out) {
            this.impToImpOrient = this.ics_orient_in == BidiFlag.ORIENTATION_LTR ? 4 : 8;
        } else {
            this.impToImpPhase = 0;
            this.impToImpOrient = 0;
        }
        this.delim1 = (char)65535;
        if (this.myBdx.delimiters != null && this.myBdx.delimiters.length() > 0) {
            this.delim1 = this.myBdx.delimiters.charAt(0);
            this.delim2 = this.myBdx.delimiters.length() > 1 ? this.myBdx.delimiters.charAt(1) : this.delim1;
        }
        this.insertMarkers = this.myBdx.insertMarkers;
        this.ics_buffer_in = new char[src.count];
        if (this.ics_type_in == BidiFlag.TYPE_VISUAL && this.ics_type_out == BidiFlag.TYPE_IMPLICIT && (this.insertMarkers && this.ics_orient_in == BidiFlag.ORIENTATION_RTL || !this.insertMarkers && this.ics_orient_in != this.ics_orient_out)) {
            this.invertInput = true;
            int ofs = src.offset + src.count - 1;
            for (int k = 0; k < src.count; ++k) {
                this.ics_buffer_in[k] = src.data[ofs - k];
            }
            this.ics_orient_in = this.insertMarkers ? BidiFlag.ORIENTATION_LTR : this.ics_orient_out;
        } else {
            this.invertInput = false;
            System.arraycopy(src.data, src.offset, this.ics_buffer_in, 0, src.count);
        }
        if (this.insertMarkers) {
            if (this.ics_type_in != BidiFlag.TYPE_VISUAL || this.ics_type_out != BidiFlag.TYPE_IMPLICIT || this.myBdx.removeMarkers) {
                this.insertMarkers = false;
            } else if (this.ics_orient_out == BidiFlag.ORIENTATION_RTL) {
                this.ics_orient_in = BidiFlag.ORIENTATION_RTL;
                this.ics_orient_out = BidiFlag.ORIENTATION_LTR;
            }
        }
        this.ics_size = src.count;
        this.ics_num_flag = dst.flags.getNumerals();
        this.ics_symmetric = this.reqImpToImp ? false : dst.flags.getSwap() != src.flags.getSwap();
        this.ics_buffer_out = new char[src.count];
        this.typeArray = new byte[src.count][2];
        if (this.myBdx.propertyMap == null || this.myBdx.propertyMap.length < src.count) {
            this.myBdx.propertyMap = new byte[src.count];
        }
        if (this.myBdx.dstToSrcMap == null || this.myBdx.dstToSrcMap.length < src.count) {
            this.myBdx.dstToSrcMap = new int[src.count];
        }
        if (this.impToImpOrient > 0) {
            this.impToImpPhase = 1;
            BidiFlag orient_save = this.ics_orient_out;
            this.ics_orient_out = BidiFlag.ORIENTATION_LTR;
            this.ics_symmetric = src.flags.getSwap() == BidiFlag.SWAP_YES;
            this.BaseLvl();
            this.fillTypeArray();
            this.ucb_ix = 0;
            while (this.ucb_ix < this.ics_size) {
                this.ucb_xType = this.typeArray[this.ucb_ix][1];
                this.implicitProcessing();
                this.myBdx.propertyMap[this.ucb_ix] = this.ucb_wTarget;
                if (this.typeArray[this.ucb_ix][0] == 7 && this.ics_symmetric && BidiOrder.odd(this.ucb_wTarget)) {
                    this.typeArray[this.ucb_ix][0] = -7;
                }
                ++this.ucb_ix;
            }
            this.ucb_ix = this.ics_size;
            this.ucb_xType = 0;
            this.implicitProcessing();
            this.pass2();
            this.ics_orient_out = orient_save;
            this.impToImpPhase = 2;
            orient_save = this.ics_orient_in;
            if (this.impToImpOrient == 4) {
                this.ics_orient_in = BidiFlag.ORIENTATION_RTL;
                BidiOrder.invertMap(this.myBdx.dstToSrcMap, 0, this.ics_size - 1);
            } else {
                this.ics_orient_in = BidiFlag.ORIENTATION_LTR;
            }
            this.ics_symmetric = dst.flags.getSwap() == BidiFlag.SWAP_YES;
            this.BaseLvl();
            this.fillTypeArray2();
            this.ucb_ix = 0;
            while (this.ucb_ix < this.ics_size) {
                ipos = this.myBdx.dstToSrcMap[this.ucb_ix];
                this.ucb_xType = this.typeArray[ipos][1];
                this.implicitProcessing();
                this.myBdx.propertyMap[this.ucb_ix] = this.ucb_wTarget;
                if (Math.abs(this.typeArray[ipos][0]) == 7 && this.ics_symmetric && BidiOrder.odd(this.ucb_wTarget)) {
                    byte[] byArray = this.typeArray[ipos];
                    byArray[0] = (byte)(byArray[0] * -1);
                }
                ++this.ucb_ix;
            }
            this.ucb_ix = this.ics_size;
            this.ucb_xType = 0;
            this.implicitProcessing();
            this.pass2();
            this.ics_orient_in = orient_save;
            this.ics_symmetric = true;
        } else {
            this.BaseLvl();
            this.fillTypeArray();
            this.ucb_ix = 0;
            while (this.ucb_ix < this.ics_size) {
                this.ucb_xType = this.typeArray[this.ucb_ix][1];
                this.implicitProcessing();
                this.myBdx.propertyMap[this.ucb_ix] = this.ucb_wTarget;
                if (this.typeArray[this.ucb_ix][0] == 7 && this.ics_symmetric && BidiOrder.odd(this.ucb_wTarget)) {
                    this.typeArray[this.ucb_ix][0] = -7;
                }
                ++this.ucb_ix;
            }
            this.ucb_ix = this.ics_size;
            this.ucb_xType = 0;
            this.implicitProcessing();
            this.pass2();
        }
        this.pass3();
        boolean bl2 = dstToSrcMapRequired = this.myBdx.dstToSrcMapRequired || this.myBdx.srcToDstMapRequired;
        if (dstToSrcMapRequired && this.invertInput) {
            for (i = 0; i < src.count; ++i) {
                this.myBdx.dstToSrcMap[i] = src.count - this.myBdx.dstToSrcMap[i] - 1;
            }
        }
        if (this.myBdx.removeMarkers) {
            for (pos = 0; pos < src.count; ++pos) {
                char c = this.ics_buffer_out[pos];
                if (c == '\u200e' || c == '\u200f') {
                    ++this.removeCnt;
                    continue;
                }
                if (this.removeCnt <= 0) continue;
                this.ics_buffer_out[pos - this.removeCnt] = this.ics_buffer_out[pos];
                this.myBdx.dstToSrcMap[pos - this.removeCnt] = this.myBdx.dstToSrcMap[pos];
            }
        }
        dst.count = src.count - this.removeCnt + this.insertCnt;
        if (dst.data == null) {
            dst.data = dst.offset == 0 && this.insertCnt == 0 ? this.ics_buffer_out : new char[dst.offset + dst.count];
        }
        if (dst.offset + dst.count > dst.data.length) {
            char[] temp = new char[dst.offset + dst.count];
            if (dst.offset > 0) {
                System.arraycopy(dst.data, 0, temp, 0, dst.offset);
            }
            dst.data = temp;
            temp = null;
        }
        if (this.insertCnt > 0) {
            char insert;
            int after;
            int[] tempMap = null;
            for (i = 0; i < this.insertCnt; ++i) {
                long iPoint = (Long)this.myBdx.insertPoints.get(i);
                ipos = (int)(iPoint >> 17);
                after = (int)(iPoint & 0x10000L);
                insert = (char)iPoint;
                if (this.ucb_basLev != 1) continue;
                for (pos = 0; pos < src.count; ++pos) {
                    if (ipos != this.myBdx.dstToSrcMap[pos]) continue;
                    ipos = pos;
                    break;
                }
                this.myBdx.insertPoints.setElementAt(Long.valueOf((ipos << 17) + after + insert), i);
            }
            if (this.ucb_basLev == 1) {
                Collections.sort(this.myBdx.insertPoints);
            }
            if (dstToSrcMapRequired) {
                tempMap = new int[dst.count];
            }
            pos = 0;
            for (i = 0; i < this.insertCnt; ++i) {
                long iPoint = (Long)this.myBdx.insertPoints.get(i);
                ipos = (int)(iPoint >> 17);
                after = (int)(iPoint & 0x10000L);
                insert = (char)iPoint;
                System.arraycopy(this.ics_buffer_out, pos, dst.data, dst.offset + pos + i, (ipos += after >> 16) - pos);
                dst.data[dst.offset + ipos + i] = insert;
                if (dstToSrcMapRequired) {
                    System.arraycopy(this.myBdx.dstToSrcMap, pos, tempMap, pos + i, ipos - pos);
                    tempMap[ipos + i] = -1;
                }
                pos = ipos;
            }
            System.arraycopy(this.ics_buffer_out, pos, dst.data, dst.offset + pos + this.insertCnt, dst.count - pos - this.insertCnt);
            if (dstToSrcMapRequired) {
                System.arraycopy(this.myBdx.dstToSrcMap, pos, tempMap, pos + this.insertCnt, dst.count - pos - this.insertCnt);
                this.myBdx.dstToSrcMap = tempMap;
            }
        } else if (dst.data != this.ics_buffer_out) {
            System.arraycopy(this.ics_buffer_out, 0, dst.data, dst.offset, dst.count);
        }
        if (this.myBdx.srcToDstMapRequired) {
            if (this.myBdx.srcToDstMap == null || this.myBdx.srcToDstMap.length < src.count) {
                this.myBdx.srcToDstMap = new int[src.count];
            }
            if (this.removeCnt > 0) {
                Arrays.fill(this.myBdx.srcToDstMap, 0, src.count, -1);
            }
            for (i = 0; i < dst.count; ++i) {
                pos = this.myBdx.dstToSrcMap[i];
                if (pos < 0) continue;
                this.myBdx.srcToDstMap[pos] = i;
            }
        }
        if (this.myBdx.propertyMapRequired) {
            for (i = 0; i < src.count; ++i) {
                if (this.typeArray[i][0] == 13) continue;
                int n = i;
                bdx.propertyMap[n] = (byte)(bdx.propertyMap[n] | 0x80);
            }
            if (this.invertInput) {
                BidiOrder.invertMap(this.myBdx.propertyMap, 0, src.count - 1);
            }
        }
        this.myBdx.inpCount = src.count;
        this.myBdx.outCount = dst.count;
    }
}

