/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.AS400Server;
import com.ibm.as400.access.ClientAccessDataStream;
import com.ibm.as400.access.ConnectionDroppedException;
import com.ibm.as400.access.ConvTableReader;
import com.ibm.as400.access.DataStream;
import com.ibm.as400.access.ExtendedIOException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.IFSDataStream;
import com.ibm.as400.access.IFSFileDescriptorImpl;
import com.ibm.as400.access.IFSFileDescriptorImplRemote;
import com.ibm.as400.access.IFSFileInputStreamImpl;
import com.ibm.as400.access.IFSKey;
import com.ibm.as400.access.IFSListAttrsRep;
import com.ibm.as400.access.IFSListAttrsReq;
import com.ibm.as400.access.IFSOpenRep;
import com.ibm.as400.access.IFSOpenReq;
import com.ibm.as400.access.IFSReturnCodeRep;
import com.ibm.as400.access.InternalErrorException;
import com.ibm.as400.access.Trace;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;

class IFSFileInputStreamImplRemote
extends InputStream
implements IFSFileInputStreamImpl {
    private IFSFileDescriptorImplRemote fd_;
    private transient ConvTableReader reader_;
    private static final boolean DEBUG = false;

    IFSFileInputStreamImplRemote() {
    }

    @Override
    public int available() throws IOException {
        return (int)Math.min(this.availableLong(), Integer.MAX_VALUE);
    }

    private long availableLong() throws IOException {
        this.open();
        return this.getFileSize() - this.fd_.getFileOffset();
    }

    @Override
    public void close() throws IOException {
        this.fd_.close0();
    }

    @Override
    public void connectAndOpen() throws AS400SecurityException, IOException {
        this.fd_.connect();
        this.open();
    }

    protected void finalize() throws Throwable {
        try {
            if (this.fd_ != null) {
                this.fd_.finalize0();
            }
        }
        catch (Throwable e) {
            Trace.log(2, "Error during finalization.", e);
        }
        finally {
            super.finalize();
        }
    }

    private final long getFileSize() throws IOException {
        long size = 0L;
        IFSListAttrsRep reply = null;
        IFSListAttrsReq req = new IFSListAttrsReq(this.fd_.getFileHandle());
        ClientAccessDataStream ds = null;
        try {
            ds = (ClientAccessDataStream)this.fd_.getServer().sendAndReceive(req);
        }
        catch (ConnectionDroppedException e) {
            this.fd_.connectionDropped(e);
        }
        catch (InterruptedException e) {
            Trace.log(2, "Interrupted.", (Throwable)e);
            InterruptedIOException throwException = new InterruptedIOException(e.getMessage());
            throwException.initCause(e);
            throw throwException;
        }
        boolean done = false;
        do {
            if (reply == null && ds instanceof IFSListAttrsRep) {
                reply = (IFSListAttrsRep)ds;
            } else if (ds instanceof IFSReturnCodeRep) {
                int rc = ((IFSReturnCodeRep)ds).getReturnCode();
                if (rc != 18) {
                    Trace.log(2, "IFSReturnCodeRep return code", rc);
                    throw new ExtendedIOException(rc);
                }
            } else {
                Trace.log(2, "Unknown reply data stream", ds.data_);
                throw new InternalErrorException(Integer.toHexString(ds.getReqRepID()), 2);
            }
            done = ((IFSDataStream)ds).isEndOfChain();
            if (done) continue;
            try {
                ds = (ClientAccessDataStream)this.fd_.getServer().receive(req.getCorrelation());
            }
            catch (ConnectionDroppedException e) {
                this.fd_.connectionDropped(e);
            }
            catch (InterruptedException e) {
                Trace.log(2, "Interrupted", (Throwable)e);
                InterruptedIOException throwException = new InterruptedIOException(e.getMessage());
                throwException.initCause(e);
                throw throwException;
            }
        } while (!done);
        if (reply == null) {
            Trace.log(2, "No reply available.");
            throw new InternalErrorException(6);
        }
        size = reply.getSize(this.fd_.serverDatastreamLevel_);
        return size;
    }

    @Override
    public IFSKey lock(long length) throws IOException {
        this.open();
        try {
            return this.fd_.lock(length);
        }
        catch (AS400SecurityException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void open() throws IOException {
        if (this.fd_.isOpen_) {
            return;
        }
        if (!this.fd_.isOpenAllowed_) {
            Trace.log(2, "Attempting to re-open a closed stream.");
            throw new ConnectionDroppedException(3);
        }
        String path = this.fd_.getPath();
        if (path.length() == 0) {
            throw new ExtendedIllegalStateException("path", 4);
        }
        try {
            this.fd_.connect();
        }
        catch (AS400SecurityException e) {
            Trace.log(2, "Access to byte stream server on '" + this.fd_.getSystem().getSystemName() + "' denied.", (Throwable)e);
            throw new ExtendedIOException(5);
        }
        byte[] pathname = this.fd_.getConverter().stringToByteArray(path);
        IFSOpenReq req = new IFSOpenReq(pathname, this.fd_.preferredServerCCSID_, this.fd_.preferredServerCCSID_, 1, ~this.fd_.getShareOption(), 0, 8, this.fd_.serverDatastreamLevel_);
        ClientAccessDataStream ds = null;
        try {
            ds = (ClientAccessDataStream)this.fd_.getServer().sendAndReceive(req);
        }
        catch (ConnectionDroppedException e) {
            this.fd_.connectionDropped(e);
        }
        catch (InterruptedException e) {
            Trace.log(2, "Interrupted", (Throwable)e);
            InterruptedIOException throwException = new InterruptedIOException(e.getMessage());
            throwException.initCause(e);
            throw throwException;
        }
        if (!(ds instanceof IFSOpenRep)) {
            if (ds instanceof IFSReturnCodeRep) {
                int rc = ((IFSReturnCodeRep)ds).getReturnCode();
                if (rc == 2 || rc == 3) {
                    Trace.log(2, this.fd_.getPath() + " not found.");
                    throw new FileNotFoundException(this.fd_.getPath());
                }
                if (rc == 1) {
                    Trace.log(2, "IFSReturnCodeRep return code", rc);
                    throw new ExtendedIOException(32);
                }
                Trace.log(2, "IFSReturnCodeRep return code", rc);
                throw new ExtendedIOException(rc);
            }
            Trace.log(2, "Unknown reply data stream", ds.data_);
            throw new InternalErrorException(Integer.toHexString(ds.getReqRepID()), 2);
        }
        IFSOpenRep rep = (IFSOpenRep)ds;
        this.fd_.setOpen(true, rep.getFileHandle());
        this.fd_.setOpenAllowed(false);
    }

    @Override
    public int read() throws IOException {
        int value;
        byte[] data = new byte[1];
        int rc = this.read(data, 0, 1);
        if (rc == 1) {
            value = data[0];
            value &= 0xFF;
        } else {
            value = -1;
        }
        return value;
    }

    @Override
    public int read(byte[] data, int dataOffset, int length) throws IOException {
        this.open();
        try {
            return this.fd_.read(data, dataOffset, length);
        }
        catch (AS400SecurityException e) {
            throw new IOException(e);
        }
    }

    @Override
    public String readText(int length) throws IOException {
        String data = "";
        this.open();
        if (this.reader_ == null) {
            this.reader_ = new ConvTableReader((InputStream)this, this.fd_.getCCSID());
        }
        if ((data = this.reader_.read(length)) == null) {
            data = "";
        }
        return data;
    }

    @Override
    public void setFD(IFSFileDescriptorImpl fd) {
        this.fd_ = IFSFileDescriptorImplRemote.castImplToImplRemote(fd);
    }

    @Override
    public long skip(long bytesToSkip) throws IOException {
        long bytesSkipped;
        this.open();
        long bytesAvail = this.availableLong();
        if (bytesToSkip > bytesAvail) {
            this.fd_.incrementFileOffset(bytesAvail);
            bytesSkipped = bytesAvail;
        } else {
            this.fd_.incrementFileOffset(bytesToSkip);
            bytesSkipped = bytesToSkip;
        }
        return bytesSkipped;
    }

    @Override
    public void unlock(IFSKey key) throws IOException {
        this.open();
        try {
            this.fd_.unlock(key);
        }
        catch (AS400SecurityException e) {
            throw new IOException(e);
        }
    }

    static {
        AS400Server.addReplyStream((DataStream)new IFSListAttrsRep(), 0);
        AS400Server.addReplyStream((DataStream)new IFSOpenRep(), 0);
        AS400Server.addReplyStream((DataStream)new IFSReturnCodeRep(), 0);
    }
}

