/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.IFSDataStreamReq;

class IFSOpenReq
extends IFSDataStreamReq {
    static final int PROGRAM_LOAD_ACCESS = 4;
    static final int READ_ACCESS = 1;
    static final int WRITE_ACCESS = 2;
    static final int DENY_NONE = 0;
    static final int DENY_READERS = 1;
    static final int DENY_WRITERS = 2;
    static final int NO_CONVERSION = 0;
    static final int CONVERT_TO_CLIENT_CCSID = 1;
    static final int CONVERT_TO_SERVER_CCSID = 2;
    static final int OPEN_OPTION_CREATE_OPEN = 1;
    static final int OPEN_OPTION_CREATE_REPLACE = 2;
    static final int OPEN_OPTION_CREATE_FAIL = 4;
    static final int OPEN_OPTION_FAIL_OPEN = 8;
    static final int OPEN_OPTION_FAIL_REPLACE = 16;
    private static final int HEADER_LENGTH = 20;
    private static final int FILE_NAME_CCSID_OFFSET = 22;
    private static final int WORKING_DIR_HANDLE_OFFSET = 24;
    private static final int FILE_DATA_CCSID_OFFSET = 28;
    private static final int ACCESS_OFFSET = 30;
    private static final int FILE_SHARING_OFFSET = 32;
    private static final int DATA_CONVERSION_OFFSET = 34;
    private static final int DUPLICATE_FILE_OPT_OFFSET = 36;
    private static final int CREATE_SIZE_OFFSET = 38;
    private static final int FIXED_ATTRS_OFFSET = 42;
    private static final int ATTRS_LIST_LEVEL_OFFSET = 46;
    private static final int PRE_READ_OFFSET_OFFSET = 48;
    private static final int PRE_READ_LENGTH_OFFSET = 52;
    private static final int LARGE_CREATE_SIZE_OFFSET = 56;

    IFSOpenReq(byte[] fileName, int fileNameCCSID, int fileDataCCSID, int accessIntent, int fileSharing, int dataConversionOption, int duplicateFileOption, int datastreamLevel) {
        super(20 + IFSOpenReq.getTemplateLength(datastreamLevel) + 6 + fileName.length);
        this.setLength(this.data_.length);
        this.setTemplateLen(IFSOpenReq.getTemplateLength(datastreamLevel));
        this.setReqRepID(2);
        this.set16bit(fileNameCCSID, 22);
        this.set32bit(1, 24);
        this.set16bit(fileDataCCSID, 28);
        this.set16bit(accessIntent, 30);
        this.set16bit(fileSharing, 32);
        this.set16bit(dataConversionOption, 34);
        this.set16bit(duplicateFileOption, 36);
        this.set32bit(0, 42);
        this.set16bit(1, 46);
        this.set32bit(0, 48);
        this.set32bit(0, 52);
        if (datastreamLevel < 16) {
            this.set32bit(0, 38);
        } else {
            this.set32bit(0, 38);
            this.set64bit(0L, 56);
        }
        this.set32bit(fileName.length + 6, IFSOpenReq.getFilenameLLOffset(datastreamLevel));
        this.set16bit(2, IFSOpenReq.getFilenameCPOffset(datastreamLevel));
        System.arraycopy(fileName, 0, this.data_, IFSOpenReq.getFilenameOffset(datastreamLevel), fileName.length);
    }

    private static final int getFilenameLLOffset(int datastreamLevel) {
        return datastreamLevel < 16 ? 56 : 64;
    }

    private static final int getFilenameCPOffset(int datastreamLevel) {
        return datastreamLevel < 16 ? 60 : 68;
    }

    private static final int getFilenameOffset(int datastreamLevel) {
        return datastreamLevel < 16 ? 62 : 70;
    }

    private static final int getTemplateLength(int datastreamLevel) {
        return datastreamLevel < 16 ? 36 : 44;
    }
}

