/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.ProxyClientConnection;
import com.ibm.as400.access.ProxyFactoryImpl;
import com.ibm.as400.access.ProxyReturnValue;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;

class JDInputStreamProxy
extends InputStream
implements ProxyFactoryImpl {
    static final String copyright = "Copyright (C) 1997-2001 International Business Machines Corporation and others.";
    private long pxId_;
    private ProxyClientConnection connection_;
    private static final boolean[] ARGS_TO_RETURN = new boolean[]{true, false, false};

    JDInputStreamProxy() {
    }

    @Override
    public int available() throws IOException {
        try {
            return this.connection_.callMethodReturnsInt(this.pxId_, "available");
        }
        catch (InvocationTargetException e) {
            throw ProxyClientConnection.rethrow1(e);
        }
    }

    @Override
    public void close() throws IOException {
        try {
            this.connection_.callMethod(this.pxId_, "close");
        }
        catch (InvocationTargetException e) {
            throw ProxyClientConnection.rethrow1(e);
        }
    }

    protected void finalize() throws Throwable {
        this.connection_.callFinalize(this.pxId_);
        super.finalize();
    }

    @Override
    public void initialize(long proxyId, ProxyClientConnection connection) {
        this.pxId_ = proxyId;
        this.connection_ = connection;
    }

    @Override
    public void mark(int readLimit) {
        try {
            this.connection_.callMethod(this.pxId_, "mark", new Class[]{Integer.TYPE}, new Object[]{readLimit});
        }
        catch (InvocationTargetException e) {
            throw ProxyClientConnection.rethrow(e);
        }
    }

    @Override
    public boolean markSupported() {
        try {
            return this.connection_.callMethodReturnsBoolean(this.pxId_, "markSupported");
        }
        catch (InvocationTargetException e) {
            throw ProxyClientConnection.rethrow(e);
        }
    }

    @Override
    public int read() throws IOException {
        try {
            return this.connection_.callMethodReturnsInt(this.pxId_, "read");
        }
        catch (InvocationTargetException e) {
            throw ProxyClientConnection.rethrow1(e);
        }
    }

    @Override
    public int read(byte[] data) throws IOException {
        return this.read(data, 0, data.length);
    }

    @Override
    public int read(byte[] data, int start, int length) throws IOException {
        try {
            ProxyReturnValue rv = this.connection_.callMethod(this.pxId_, "read", new Class[]{byte[].class, Integer.TYPE, Integer.TYPE}, new Object[]{data, start, length}, ARGS_TO_RETURN, false);
            byte[] returnDataBuffer = (byte[])rv.getArgument(0);
            System.arraycopy(returnDataBuffer, 0, data, 0, data.length);
            return rv.getReturnValueInt();
        }
        catch (InvocationTargetException e) {
            throw ProxyClientConnection.rethrow1(e);
        }
    }

    @Override
    public void reset() throws IOException {
        try {
            this.connection_.callMethod(this.pxId_, "reset");
        }
        catch (InvocationTargetException e) {
            throw ProxyClientConnection.rethrow1(e);
        }
    }

    @Override
    public long skip(long length) throws IOException {
        try {
            return this.connection_.callMethod(this.pxId_, "skip", new Class[]{Long.TYPE}, new Object[]{length}).getReturnValueLong();
        }
        catch (InvocationTargetException e) {
            throw ProxyClientConnection.rethrow1(e);
        }
    }
}

