/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.DataArea;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.IllegalObjectTypeException;
import com.ibm.as400.access.ObjectAlreadyExistsException;
import com.ibm.as400.access.ObjectDoesNotExistException;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.io.Serializable;

public class LogicalDataArea
extends DataArea
implements Serializable {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    static final long serialVersionUID = 4L;
    static final int DEFAULT_LENGTH = 1;
    private boolean initialValue_ = false;

    public LogicalDataArea() {
        this.length_ = 1;
        this.dataAreaType_ = 4;
    }

    public LogicalDataArea(AS400 system, String path) {
        super(system, path);
        this.length_ = 1;
        this.dataAreaType_ = 4;
    }

    public void clear() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (this.impl_ == null) {
            this.chooseImpl();
        }
        this.impl_.clear();
        this.fireCleared();
    }

    public void create() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectAlreadyExistsException, ObjectDoesNotExistException {
        if (this.impl_ == null) {
            this.chooseImpl();
        }
        this.impl_.create(this.initialValue_, this.textDescription_, this.authority_);
        this.fireCreated();
    }

    public void create(boolean initialValue, String textDescription, String authority) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectAlreadyExistsException, ObjectDoesNotExistException {
        if (textDescription == null) {
            throw new NullPointerException("textDescription");
        }
        if (textDescription.length() > 50) {
            throw new ExtendedIllegalArgumentException("textDescription", 1);
        }
        if (authority == null) {
            throw new NullPointerException("authority");
        }
        if (authority.length() == 0 || authority.length() > 10) {
            throw new ExtendedIllegalArgumentException("authority", 1);
        }
        this.initialValue_ = initialValue;
        this.textDescription_ = textDescription;
        this.authority_ = authority;
        this.create();
    }

    public void delete() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        super.delete0();
    }

    @Override
    public String getPath() {
        return super.getPath();
    }

    public boolean read() throws AS400SecurityException, ErrorCompletingRequestException, IllegalObjectTypeException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (this.impl_ == null) {
            this.chooseImpl();
        }
        boolean data = this.impl_.readBoolean();
        this.fireRead();
        return data;
    }

    @Override
    public void setPath(String path) throws PropertyVetoException {
        super.setPath(path);
    }

    public void write(boolean data) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (this.impl_ == null) {
            this.chooseImpl();
        }
        this.impl_.write(data);
        this.fireWritten();
    }
}

