/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.IllegalPathNameException;
import com.ibm.as400.access.NPCPSelection;
import com.ibm.as400.access.QSYSObjectPathName;
import com.ibm.as400.access.Trace;

class NPCPSelRes
extends NPCPSelection
implements Cloneable {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    static final long serialVersionUID = 4L;
    static final int FNTRSC = 1;
    static final int FORMDF = 2;
    static final int OVL = 4;
    static final int PAGSEG = 8;
    static final int PAGDFN = 16;
    static final int ALLRSC = 31;
    static final String STR_ALL = "%ALL%";
    static final String STR_UNKNOWN = "UNKNOWN";
    static final String PEL240 = "1";
    static final String PEL300 = "2";

    NPCPSelRes(NPCPSelRes cp) {
        super(cp);
    }

    NPCPSelRes() {
    }

    @Override
    protected Object clone() {
        NPCPSelRes cp = new NPCPSelRes(this);
        return cp;
    }

    String getPelDensity() {
        String pelDensity = this.getStringValue(178);
        if (pelDensity == null) {
            return "";
        }
        return pelDensity;
    }

    String getResource() {
        String rscName = this.getStringValue(175);
        if (rscName == null) {
            return "";
        }
        String rscLib = this.getStringValue(174);
        if (rscLib == null) {
            return "";
        }
        String rscType = null;
        Integer i = this.getIntValue(176);
        rscType = i == null ? STR_ALL : NPCPSelRes.intTypeToStringType(i);
        return QSYSObjectPathName.toPath(rscLib, rscName, rscType);
    }

    static String intTypeToStringType(int resourceType) {
        switch (resourceType) {
            case 8: {
                return "PAGSEG";
            }
            case 4: {
                return "OVL";
            }
            case 1: {
                return "FNTRSC";
            }
            case 2: {
                return "FORMDF";
            }
            case 16: {
                return "PAGDFN";
            }
        }
        return STR_UNKNOWN;
    }

    void setResource(String resource) {
        if (resource.length() == 0) {
            this.removeAttribute(-12);
        } else {
            QSYSObjectPathName ifsPath = new QSYSObjectPathName(resource);
            String strRes = ifsPath.getObjectName();
            String strLib = ifsPath.getLibraryName();
            String type = ifsPath.getObjectType();
            if (type.equals(STR_ALL)) {
                this.setResourceType(31);
            } else {
                try {
                    this.setResourceType(NPCPSelRes.stringTypeToIntType(type));
                }
                catch (ExtendedIllegalArgumentException e) {
                    Trace.log(2, "Parameter 'resource' has a invalid object type.");
                    throw new IllegalPathNameException(resource, 1);
                }
            }
            this.setAttrValue(174, strLib);
            this.setAttrValue(175, strRes);
        }
    }

    void setResourceType(int resourceType) {
        this.setAttrValue(176, resourceType);
    }

    void setPelDensity(String pelDensity) {
        if (pelDensity.length() == 0) {
            this.removeAttribute(178);
        } else {
            this.setAttrValue(178, pelDensity);
        }
    }

    static int stringTypeToIntType(String resourceType) {
        int intResourceType = 0;
        if (resourceType.equals("PAGSEG")) {
            intResourceType = 8;
        } else if (resourceType.equals("OVL")) {
            intResourceType = 4;
        } else if (resourceType.equals("FNTRSC")) {
            intResourceType = 1;
        } else if (resourceType.equals("FORMDF")) {
            intResourceType = 2;
        } else if (resourceType.equals("PAGDFN")) {
            intResourceType = 16;
        } else {
            Trace.log(2, "Parameter 'resourceType' has a invalid object type.");
            throw new ExtendedIllegalArgumentException("resourceType (" + resourceType + ")", 2);
        }
        return intResourceType;
    }
}

