/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.ClientAccessDataStream;
import com.ibm.as400.access.ConverterImpl;
import com.ibm.as400.access.NPCodePoint;
import com.ibm.as400.access.Trace;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

class NPDataStream
extends ClientAccessDataStream {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    static final int NP_SERVER_ID = 57347;
    static final int TEMPLATE_LENGTH = 12;
    static final int ACTION_ID_OFFSET = 20;
    static final int FLAGS_OFFSET = 22;
    static final int RC_OFFSET = 26;
    static final int EO_OFFSET = 28;
    static final int LAST_REPLY_MASK = Integer.MIN_VALUE;
    static final int CODE_POINT_OFFSET = 32;
    static final int CREATE = 1;
    static final int OPEN = 2;
    static final int READ = 3;
    static final int WRITE = 4;
    static final int CLOSE = 5;
    static final int HOLD = 6;
    static final int RELEASE = 7;
    static final int START = 8;
    static final int END = 9;
    static final int DELETE = 10;
    static final int MOVE = 11;
    static final int SEND = 12;
    static final int CALL_EXIT_PROGRAM = 13;
    static final int CHANGE_ATTRIBUTES = 14;
    static final int RETRIEVE_ATTRIBUTES = 15;
    static final int RETRIEVE_ATTRIBUTE_INFO = 16;
    static final int RETRIEVE_MESSAGE = 17;
    static final int ANSWER_MESSAGE = 18;
    static final int WATCH = 19;
    static final int CHECK_AUTHORITY = 20;
    static final int PURGE = 21;
    static final int LIST = 22;
    static final int SEEK = 23;
    static final int TELL = 24;
    static final int SELECT_PAGE = 25;
    static final int OPEN_MODIFIED_SPLF = 26;
    static final int COPY = 27;
    static final int RET_OK = 0;
    static final int RET_INV_REQ_STRUCT = 1;
    static final int RET_INV_REQ_ID = 2;
    static final int RET_INV_ACT_ID = 3;
    static final int RET_INV_REQ_ACT = 4;
    static final int RET_INV_CODEPOINT = 5;
    static final int RET_INV_ATTR = 6;
    static final int RET_INV_ATTRVALUE = 7;
    static final int RET_NOT_AUTHORIZED = 8;
    static final int RET_CPF_MESSAGE = 9;
    static final int RET_INV_SPLF_HANDLE = 10;
    static final int RET_SPLF_CREATE_ERR = 11;
    static final int RET_CL_ERROR = 12;
    static final int RET_SPLF_NOT_OPEN = 13;
    static final int RET_SPLF_NO_MESSAGE = 14;
    static final int RET_SPLF_OPEN_FAILED = 15;
    static final int RET_SEEK_OFF_BAD = 16;
    static final int RET_SEEK_FAILED = 17;
    static final int RET_READ_INCOMPLETE = 18;
    static final int RET_READ_EOF = 19;
    static final int RET_EMPTY_LIST = 20;
    static final int RET_FUNCTION_NOT_SUP = 21;
    static final int RET_CANNOT_ACC_PRTF = 22;
    static final int RET_CANNOT_ACC_PRTF_ATTR = 23;
    static final int RET_WRITER_NOT_FOUND = 24;
    static final int RET_RETURN_CP_MISSING = 25;
    static final int RET_NO_EXIT_PGM = 26;
    static final int RET_EXIT_PGM_DENIED = 27;
    static final int RET_NLV_NOT_AVAILABLE = 28;
    static final int RET_INV_BYTE_COUNT = 29;
    static final int RET_SPLF_NOT_FOUND = 30;
    static final int RET_INV_DATA_TYPE = 31;
    static final int RET_READ_OUT_OF_RANGE = 32;
    static final int RET_PAGE_OUT_OF_RANGE = 33;
    private int reqRepID_;
    private int correlation_;
    private int actionID_;
    private ConverterImpl converter_;
    private NPCodePoint[] codePoints_ = new NPCodePoint[17];

    NPDataStream(NPDataStream ds) {
        this.data_ = new byte[ds.data_.length];
        System.arraycopy(ds.data_, 0, this.data_, 0, this.data_.length);
        this.reqRepID_ = ds.reqRepID_;
        this.correlation_ = ds.correlation_;
        this.actionID_ = ds.actionID_;
        this.converter_ = ds.converter_;
        for (int i = 0; i < this.codePoints_.length; ++i) {
            if (ds.codePoints_[i] == null) continue;
            this.codePoints_[i] = (NPCodePoint)ds.codePoints_[i].clone();
        }
    }

    NPDataStream() {
        this.reqRepID_ = 0;
        this.correlation_ = 0;
        this.actionID_ = 0;
        this.converter_ = null;
    }

    NPDataStream(int reqRepID) {
        this.correlation_ = 0;
        this.actionID_ = 0;
        this.converter_ = null;
        this.setObject(reqRepID);
    }

    @Override
    public Object getNewDataStream() {
        return new NPDataStream(this);
    }

    @Override
    public int hashCode() {
        return this.reqRepID_ | 0x8000;
    }

    void setObject(int reqRepID) {
        this.reqRepID_ = reqRepID;
    }

    void setAction(int actionID) {
        this.actionID_ = actionID;
    }

    @Override
    protected void setCorrelation(int correlation) {
        this.correlation_ = correlation;
    }

    int getCorrelationID() {
        return this.correlation_;
    }

    void setConverter(ConverterImpl converter) {
        this.converter_ = converter;
        for (int i = 0; i < this.codePoints_.length; ++i) {
            NPCodePoint cp = this.codePoints_[i];
            if (cp == null) continue;
            cp.setConverter(this.converter_);
        }
    }

    void addCodePoint(NPCodePoint codePoint) {
        int ID = codePoint.getID();
        if (this.validCPID(ID)) {
            this.codePoints_[ID] = codePoint;
        }
    }

    NPCodePoint getCodePoint(int ID) {
        NPCodePoint cp = null;
        if (this.validCPID(ID)) {
            cp = this.codePoints_[ID];
        }
        return cp;
    }

    void resetCodePoints() {
        for (int i = 0; i < this.codePoints_.length; ++i) {
            this.codePoints_[i] = null;
        }
    }

    int getReturnCode() {
        return this.get16bit(26);
    }

    boolean isLastReply() {
        return (this.get32bit(22) & Integer.MIN_VALUE) == 0;
    }

    @Override
    void write(OutputStream out) throws IOException {
        int dsLength = 32;
        for (int i = 0; i < this.codePoints_.length; ++i) {
            NPCodePoint cp = this.codePoints_[i];
            if (cp == null) continue;
            cp.setConverter(this.converter_);
            if (cp.getDataLength() == 0) continue;
            dsLength += cp.getLength();
        }
        this.data_ = new byte[dsLength];
        this.setLength(dsLength);
        this.setHeaderID(0);
        this.setServerID(57347);
        this.setCSInstance(0);
        super.setCorrelation(this.correlation_);
        this.setTemplateLen(12);
        this.setReqRepID(this.reqRepID_);
        this.set16bit(this.actionID_, 20);
        this.set32bit(0, 22);
        this.set16bit(0, 26);
        this.set32bit(0, 28);
        int cpOffset = 32;
        for (int i = 0; i < this.codePoints_.length; ++i) {
            NPCodePoint cp = this.codePoints_[i];
            if (cp == null || cp.getDataLength() == 0) continue;
            int length = cp.getLength();
            this.set32bit(length, cpOffset);
            this.set16bit(cp.getID(), cpOffset + 4);
            byte[] cpData = cp.getDataBuffer();
            int dataOffset = cp.getOffset();
            System.arraycopy(cpData, dataOffset, this.data_, cpOffset += 6, length -= 6);
            cpOffset += length;
        }
        super.write(out);
    }

    @Override
    protected int readAfterHeader(InputStream in) throws IOException {
        int bytesAvailable = this.getLength() - 20;
        int bytesRead = this.readFromStream(in, this.data_, 20, this.getTemplateLen());
        if (0 != this.getReturnCode()) {
            Trace.log(3, " Netprint Datastream Return code was " + this.getReturnCode());
        }
        byte[] llcp = new byte[6];
        byte[] cpData = null;
        NPCodePoint cp = null;
        while (bytesRead < bytesAvailable) {
            int temp = this.readFromStream(in, llcp, 0, llcp.length);
            if (temp != llcp.length) {
                Trace.log(2, "Didn't read 6 bytes that we needed to!");
                throw new IOException(Integer.toString(llcp.length));
            }
            bytesRead += temp;
            int cpDataLength = BinaryConverter.byteArrayToInt(llcp, 0) - llcp.length;
            int cpID = BinaryConverter.byteArrayToUnsignedShort(llcp, 4);
            if (!this.validCPID(cpID) || this.codePoints_[cpID] == null) {
                Trace.log(2, "NPDataStream receiving orphan code point ID =" + cpID);
                cp = new NPCodePoint(cpID);
                if (!this.validCPID(cpID)) {
                    this.codePoints_[0] = cp;
                } else {
                    this.codePoints_[cpID] = cp;
                }
            } else {
                cp = this.codePoints_[cpID];
            }
            cp.setConverter(this.converter_);
            cpData = cp.getDataBuffer(cpDataLength);
            int dataOffset = cp.getOffset();
            temp = this.readFromStream(in, cpData, dataOffset, cpDataLength);
            if (temp != cpDataLength) {
                Trace.log(2, "Didn't read " + cpDataLength + " bytes that we needed!");
                throw new IOException(Integer.toString(cpDataLength));
            }
            bytesRead += temp;
        }
        return bytesRead;
    }

    private boolean validCPID(int ID) {
        return ID > 0 && ID < this.codePoints_.length;
    }
}

