/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.resource;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.QSYSObjectPathName;
import com.ibm.as400.access.Trace;
import com.ibm.as400.data.PcmlException;
import com.ibm.as400.data.ProgramCallDocument;
import com.ibm.as400.resource.BooleanValueMap;
import com.ibm.as400.resource.PresentationLoader;
import com.ibm.as400.resource.ProgramMap;
import com.ibm.as400.resource.RPrinter;
import com.ibm.as400.resource.Resource;
import com.ibm.as400.resource.ResourceException;
import com.ibm.as400.resource.ResourceLevel;
import com.ibm.as400.resource.ResourceMetaDataTable;
import com.ibm.as400.resource.ResourcePool;
import com.ibm.as400.resource.SystemResourceList;
import java.beans.PropertyVetoException;

public class RPrinterList
extends SystemResourceList {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    static final long serialVersionUID = 4L;
    private static final String PRESENTATION_KEY_ = "PRINTER_LIST";
    private static final String ICON_BASE_NAME_ = "RPrinterList";
    private static PresentationLoader presentationLoader_;
    private static ResourceMetaDataTable selections_;
    public static final String PRINTER_NAMES = "PRINTER_NAMES";
    public static final String OUTPUT_QUEUES = "OUTPUT_QUEUES";
    private static ProgramMap openListAttributeMap_;
    private static final String openListProgramName_ = "qgyrprtl";
    private static final String DOCUMENT_NAME_ = "com.ibm.as400.resource.RPrinterList";
    private static ProgramCallDocument staticDocument_;
    private static final String formatName_ = "prtl0200";
    private static final String deviceNameDataName_ = ".receiverVariable.deviceName";

    public RPrinterList() {
        super(presentationLoader_.getPresentationWithIcon(PRESENTATION_KEY_, ICON_BASE_NAME_), RPrinter.attributes_, selections_, null, openListProgramName_, formatName_, null);
    }

    public RPrinterList(AS400 system) {
        this();
        try {
            this.setSystem(system);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    @Override
    protected void establishConnection() throws ResourceException {
        super.establishConnection();
        this.setDocument((ProgramCallDocument)staticDocument_.clone());
    }

    @Override
    void setOpenParameters(ProgramCallDocument document) throws PcmlException, ResourceException {
        super.setOpenParameters(document);
        Object printerNamesSV = this.getSelectionValue(PRINTER_NAMES);
        String[] printerNames = printerNamesSV == null ? new String[]{} : (printerNamesSV instanceof String ? new String[]{(String)printerNamesSV} : (String[])printerNamesSV);
        document.setIntValue("qgyrprtl.filterInformation.numberOfPrinterNames", printerNames.length);
        for (int i = 0; i < printerNames.length; ++i) {
            document.setValue("qgyrprtl.filterInformation.printerName", new int[]{i}, printerNames[i].toUpperCase());
        }
        Object outputQueuesSV = this.getSelectionValue(OUTPUT_QUEUES);
        String[] outputQueues = outputQueuesSV == null ? new String[]{} : (outputQueuesSV instanceof String ? new String[]{(String)outputQueuesSV} : (String[])outputQueuesSV);
        document.setIntValue("qgyrprtl.filterInformation.numberOfOutputQueues", outputQueues.length);
        int i = 0;
        while (i < outputQueues.length) {
            QSYSObjectPathName path = new QSYSObjectPathName(outputQueues[i].toUpperCase());
            document.setValue("qgyrprtl.filterInformation.outputQueue.objectName", new int[]{i}, path.getObjectName());
            document.setValue("qgyrprtl.filterInformation.outputQueue.libraryName", new int[]{i++}, path.getLibraryName());
        }
    }

    @Override
    Resource newResource(String programName, int[] indices) throws PcmlException, ResourceException {
        ProgramCallDocument document = this.getDocument();
        String name = (String)document.getValue(programName + deviceNameDataName_, indices);
        AS400 system = this.getSystem();
        Object resourceKey = RPrinter.computeResourceKey(system, name);
        RPrinter resource = (RPrinter)ResourcePool.GLOBAL_RESOURCE_POOL.getResource(resourceKey);
        if (resource == null) {
            try {
                resource = new RPrinter(system, name);
                resource.setResourceKey(resourceKey);
                resource.freezeProperties();
            }
            catch (Exception e) {
                if (Trace.isTraceOn()) {
                    Trace.log(2, "Exception while creating printer from printer list", (Throwable)e);
                }
                throw new ResourceException(e);
            }
        }
        try {
            Object[] attributeIDs = openListAttributeMap_.getIDs(ResourceLevel.vrmToLevel(system.getVRM()));
            Object[] values = openListAttributeMap_.getValues(attributeIDs, system, document, programName, indices);
            for (int i = 0; i < values.length; ++i) {
                resource.initializeAttributeValue(attributeIDs[i], values[i]);
            }
        }
        catch (Exception e) {
            throw new ResourceException(e);
        }
        return resource;
    }

    static {
        block2: {
            presentationLoader_ = new PresentationLoader("com.ibm.as400.resource.ResourceMRI");
            selections_ = new ResourceMetaDataTable(presentationLoader_, PRESENTATION_KEY_);
            selections_.add(PRINTER_NAMES, String.class, false, null, null, false, true);
            selections_.add(OUTPUT_QUEUES, String.class, false, null, null, false, true);
            openListAttributeMap_ = new ProgramMap();
            BooleanValueMap boolean01Map = new BooleanValueMap("0", "1");
            openListAttributeMap_.add("DEVICE_NAME", null, "receiverVariable.deviceName");
            openListAttributeMap_.add("TEXT_DESCRIPTION", null, "receiverVariable.textDescription");
            openListAttributeMap_.add("OVERALL_STATUS", null, "receiverVariable.overallStatus");
            openListAttributeMap_.add("DEVICE_STATUS", null, "receiverVariable.deviceStatus");
            openListAttributeMap_.add("OUTPUT_QUEUE", null, "receiverVariable.outputQueue");
            openListAttributeMap_.add("OUTPUT_QUEUE_STATUS", null, "receiverVariable.outputQueueStatus");
            openListAttributeMap_.add("WRITER_STATUS", null, "receiverVariable.writerStatus");
            openListAttributeMap_.add((Object)"WRITER_STARTED", null, "receiverVariable.writerStarted", boolean01Map);
            openListAttributeMap_.add("FORM_TYPE", null, "receiverVariable.formType");
            openListAttributeMap_.add("SPOOLED_FILE_NAME", null, "receiverVariable.currentFileName");
            openListAttributeMap_.add("USER_NAME", null, "receiverVariable.currentFileUser");
            openListAttributeMap_.add((Object)"PUBLISHED_STATUS", null, "receiverVariable.publishingStatus", boolean01Map, new ResourceLevel("V5R1M0"));
            staticDocument_ = null;
            try {
                staticDocument_ = new ProgramCallDocument();
                staticDocument_.setDocument(DOCUMENT_NAME_);
            }
            catch (PcmlException e) {
                if (!Trace.isTraceOn()) break block2;
                Trace.log(2, "Error instantiating ProgramCallDocument", (Throwable)e);
            }
        }
    }
}

