/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.storage.v1beta2.stub.readrows;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutureCallback;
import com.google.api.core.ApiFutures;
import com.google.api.gax.retrying.RetryingContext;
import com.google.api.gax.retrying.RetryingFuture;
import com.google.api.gax.retrying.ScheduledRetryingExecutor;
import com.google.api.gax.retrying.ServerStreamingAttemptException;
import com.google.api.gax.retrying.StreamResumptionStrategy;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ResponseObserver;
import com.google.api.gax.rpc.ServerStreamingCallable;
import com.google.cloud.bigquery.storage.v1beta2.ReadRowsRequest;
import com.google.cloud.bigquery.storage.v1beta2.ReadRowsResponse;
import com.google.cloud.bigquery.storage.v1beta2.stub.readrows.ReadRowsAttemptCallable;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;

public final class ReadRowsRetryingCallable
extends ServerStreamingCallable<ReadRowsRequest, ReadRowsResponse> {
    private final ApiCallContext context;
    private final ServerStreamingCallable<ReadRowsRequest, ReadRowsResponse> innerCallable;
    private final ScheduledRetryingExecutor<Void> executor;
    private final StreamResumptionStrategy<ReadRowsRequest, ReadRowsResponse> resumptionStrategyPrototype;

    public ReadRowsRetryingCallable(ApiCallContext context, ServerStreamingCallable<ReadRowsRequest, ReadRowsResponse> innerCallable, ScheduledRetryingExecutor<Void> executor, StreamResumptionStrategy<ReadRowsRequest, ReadRowsResponse> resumptionStrategyPrototype) {
        this.context = context;
        this.innerCallable = innerCallable;
        this.executor = executor;
        this.resumptionStrategyPrototype = resumptionStrategyPrototype;
    }

    public void call(ReadRowsRequest request, final ResponseObserver<ReadRowsResponse> responseObserver, ApiCallContext context) {
        ApiCallContext actualContext = this.context.merge(context);
        ReadRowsAttemptCallable attemptCallable = new ReadRowsAttemptCallable(this.innerCallable, (StreamResumptionStrategy<ReadRowsRequest, ReadRowsResponse>)this.resumptionStrategyPrototype.createNew(), request, actualContext, responseObserver);
        RetryingFuture retryingFuture = this.executor.createFuture((Callable)attemptCallable, (RetryingContext)actualContext);
        attemptCallable.setExternalFuture((RetryingFuture<Void>)retryingFuture);
        attemptCallable.start();
        ApiFutures.addCallback((ApiFuture)retryingFuture, (ApiFutureCallback)new ApiFutureCallback<Void>(){

            public void onFailure(Throwable throwable) {
                if (throwable instanceof ServerStreamingAttemptException) {
                    throwable = throwable.getCause();
                }
                responseObserver.onError(throwable);
            }

            public void onSuccess(Void ignored) {
                responseObserver.onComplete();
            }
        }, (Executor)MoreExecutors.directExecutor());
    }
}

