/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.beam.core.transform;

import javax.annotation.Nullable;
import org.apache.beam.sdk.io.Compression;
import org.apache.beam.sdk.io.TextIO;
import org.apache.beam.sdk.metrics.Counter;
import org.apache.beam.sdk.metrics.Metrics;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.hop.beam.core.BeamHop;
import org.apache.hop.beam.core.HopRow;
import org.apache.hop.beam.core.fn.StringToHopFn;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeamInputTransform
extends PTransform<PBegin, PCollection<HopRow>> {
    private String transformName;
    private String inputLocation;
    private String separator;
    private String rowMetaJson;
    private static final Logger LOG = LoggerFactory.getLogger(BeamInputTransform.class);
    private static final Counter numErrors = Metrics.counter((String)"main", (String)"BeamInputError");

    public BeamInputTransform() {
    }

    public BeamInputTransform(@Nullable String name, String transformName, String inputLocation, String separator, String rowMetaJson) {
        super(name);
        this.transformName = transformName;
        this.inputLocation = inputLocation;
        this.separator = separator;
        this.rowMetaJson = rowMetaJson;
    }

    public PCollection<HopRow> expand(PBegin input) {
        try {
            BeamHop.init();
            TextIO.Read ioRead = TextIO.read().from(this.inputLocation).withCompression(Compression.UNCOMPRESSED);
            StringToHopFn stringToHopFn = new StringToHopFn(this.transformName, this.rowMetaJson, this.separator);
            return (PCollection)((PCollection)input.apply(this.transformName + " READ FILE", (PTransform)ioRead)).apply(this.transformName, (PTransform)ParDo.of((DoFn)stringToHopFn));
        }
        catch (Exception e) {
            numErrors.inc();
            LOG.error("Error in beam input transform", (Throwable)e);
            throw new RuntimeException("Error in beam input transform", e);
        }
    }
}

