/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.beam.engines.direct;

import org.apache.beam.runners.direct.DirectOptions;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.beam.engines.BeamPipelineRunConfiguration;
import org.apache.hop.beam.engines.IBeamPipelineEngineRunConfiguration;
import org.apache.hop.beam.metadata.RunnerType;
import org.apache.hop.core.Const;
import org.apache.hop.core.gui.plugin.GuiElementType;
import org.apache.hop.core.gui.plugin.GuiPlugin;
import org.apache.hop.core.gui.plugin.GuiWidgetElement;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.metadata.api.HopMetadataProperty;

@GuiPlugin
public class BeamDirectPipelineRunConfiguration
extends BeamPipelineRunConfiguration
implements IBeamPipelineEngineRunConfiguration,
IVariables,
Cloneable {
    @GuiWidgetElement(order="20000-direct-options", parentId="PipelineRunConfiguration-PluginSpecific-Options", type=GuiElementType.TEXT, label="Number of workers", toolTip="Controls the amount of target parallelism the DirectRunner will use. Defaults to the greater of the number of available processors and 3. Must be a value greater than zero.")
    @HopMetadataProperty(key="number_of_workers")
    private String numberOfWorkers;

    public BeamDirectPipelineRunConfiguration(String numberOfWorkers) {
        super("BeamDirectPipelineEngine", "direct runner");
        this.numberOfWorkers = numberOfWorkers;
    }

    public BeamDirectPipelineRunConfiguration() {
        super("BeamDirectPipelineEngine", "direct runner");
        this.tempLocation = "file://" + System.getProperty("java.io.tmpdir");
        this.numberOfWorkers = "";
    }

    public BeamDirectPipelineRunConfiguration(BeamDirectPipelineRunConfiguration config) {
        super(config);
        this.numberOfWorkers = config.numberOfWorkers;
    }

    public BeamDirectPipelineRunConfiguration clone() {
        return new BeamDirectPipelineRunConfiguration(this);
    }

    public RunnerType getRunnerType() {
        return RunnerType.Direct;
    }

    public PipelineOptions getPipelineOptions() {
        DirectOptions options = (DirectOptions)PipelineOptionsFactory.as(DirectOptions.class);
        options.setBlockOnRun(!this.isRunningAsynchronous());
        if (StringUtils.isNotEmpty((String)this.numberOfWorkers)) {
            int targetParallelism = Const.toInt((String)this.resolve(this.numberOfWorkers), (int)1);
            options.setTargetParallelism(targetParallelism);
        }
        return options;
    }

    public boolean isRunningAsynchronous() {
        return false;
    }

    public String getNumberOfWorkers() {
        return this.numberOfWorkers;
    }

    public void setNumberOfWorkers(String numberOfWorkers) {
        this.numberOfWorkers = numberOfWorkers;
    }
}

