/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.beam.transforms.kinesis;

import com.amazonaws.regions.Regions;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.beam.sdk.io.kinesis.KinesisIO;
import org.apache.beam.sdk.metrics.Counter;
import org.apache.beam.sdk.metrics.Metrics;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PDone;
import org.apache.hop.beam.core.BeamHop;
import org.apache.hop.beam.core.HopRow;
import org.apache.hop.beam.transforms.kinesis.KinesisConfigOption;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.JsonRowMeta;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeamKinesisProduceTransform
extends PTransform<PCollection<HopRow>, PDone> {
    private String transformName;
    private String rowMetaJson;
    private String accessKey;
    private String secretKey;
    private Regions regions;
    private String streamName;
    private String dataField;
    private String dataType;
    private String partitionKey;
    private List<KinesisConfigOption> configOptions;
    private static final Logger LOG = LoggerFactory.getLogger(BeamKinesisProduceTransform.class);
    private static final Counter numErrors = Metrics.counter((String)"main", (String)"BeamKafkaOutputError");

    public BeamKinesisProduceTransform() {
        this.configOptions = new ArrayList<KinesisConfigOption>();
    }

    public BeamKinesisProduceTransform(String transformName, String rowMetaJson, String accessKey, String secretKey, Regions regions, String streamName, String dataField, String dataType, String partitionKeyField, String[] configOptionParameters, String[] configOptionValues) {
        super(transformName);
        this.transformName = transformName;
        this.rowMetaJson = rowMetaJson;
        this.accessKey = accessKey;
        this.secretKey = secretKey;
        this.regions = regions;
        this.streamName = streamName;
        this.dataField = dataField;
        this.dataType = dataType;
        this.partitionKey = partitionKeyField;
        this.configOptions = new ArrayList<KinesisConfigOption>();
        for (int i = 0; i < configOptionParameters.length; ++i) {
            this.configOptions.add(new KinesisConfigOption(configOptionParameters[i], configOptionValues[i]));
        }
    }

    public PDone expand(PCollection<HopRow> input) {
        try {
            BeamHop.init();
            IRowMeta rowMeta = JsonRowMeta.fromJson((String)this.rowMetaJson);
            int messageIndex = rowMeta.indexOfValue(this.dataField);
            if (messageIndex < 0) {
                throw new HopException("Unable to find message field " + this.dataField + " in input row: " + rowMeta.toString());
            }
            if (!"String".equals(this.dataType)) {
                throw new HopException("For now, only Strings are supported as Kinesis data messages");
            }
            Properties producerProperties = new Properties();
            for (KinesisConfigOption configOption : this.configOptions) {
                producerProperties.put(configOption.getParameter(), configOption.getValue());
            }
            PCollection messages = (PCollection)input.apply((PTransform)ParDo.of((DoFn)new HopRowToMessage(this.transformName, this.rowMetaJson, messageIndex)));
            KinesisIO.Write write = KinesisIO.write().withAWSClientsProvider(this.accessKey, this.secretKey, this.regions).withStreamName(this.streamName).withPartitionKey(this.partitionKey).withProducerProperties(producerProperties);
            return (PDone)messages.apply((PTransform)write);
        }
        catch (Exception e) {
            numErrors.inc();
            LOG.error("Error in Beam Kinesis Produce transform", (Throwable)e);
            throw new RuntimeException("Error in Beam Kinesis Produce transform", e);
        }
    }

    private static class HopRowToMessage
    extends DoFn<HopRow, byte[]> {
        private final int messageIndex;
        private final String transformName;
        private final String rowMetaJson;
        private transient IValueMeta valueMeta;
        private transient Counter outputCounter;
        private transient Counter readCounter;

        public HopRowToMessage(String transformName, String rowMetaJson, int messageIndex) {
            this.transformName = transformName;
            this.rowMetaJson = rowMetaJson;
            this.messageIndex = messageIndex;
        }

        @DoFn.Setup
        public void setUp() {
            try {
                this.outputCounter = Metrics.counter((String)"output", (String)this.transformName);
                this.readCounter = Metrics.counter((String)"read", (String)this.transformName);
                BeamHop.init();
                IRowMeta rowMeta = JsonRowMeta.fromJson((String)this.rowMetaJson);
                this.valueMeta = rowMeta.getValueMeta(this.messageIndex);
                Metrics.counter((String)"init", (String)this.transformName).inc();
            }
            catch (Exception e) {
                LOG.error("Error in setup of HopRow to kinesis message conversion function", (Throwable)e);
                throw new RuntimeException("Error in setup of HopRow to kinesis message conversion function", e);
            }
        }

        @DoFn.ProcessElement
        public void processElement(DoFn.ProcessContext processContext) {
            HopRow hopRow = (HopRow)processContext.element();
            this.readCounter.inc();
            assert (hopRow != null);
            try {
                byte[] message = this.valueMeta.getBinary(hopRow.getRow()[this.messageIndex]);
                processContext.output((Object)message);
                this.outputCounter.inc();
            }
            catch (Exception e) {
                throw new RuntimeException("Error converting message to a binary form, value nr " + this.messageIndex + " (" + this.valueMeta.getName() + ") in the input row", e);
            }
        }
    }
}

