/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.databases.vertica;

import org.apache.hop.core.Const;
import org.apache.hop.core.database.BaseDatabaseMeta;
import org.apache.hop.core.database.DatabaseMetaPlugin;
import org.apache.hop.core.database.IDatabase;
import org.apache.hop.core.gui.plugin.GuiPlugin;
import org.apache.hop.core.row.IValueMeta;

@DatabaseMetaPlugin(type="VERTICA", typeDescription="Vertica", documentationUrl="/database/databases/vertica.html")
@GuiPlugin(id="GUI-VerticaDatabaseMeta")
public class VerticaDatabaseMeta
extends BaseDatabaseMeta
implements IDatabase {
    final int LONG = 65000;

    public int[] getAccessTypeList() {
        return new int[]{0};
    }

    public String getDriverClass() {
        return "com.vertica.Driver";
    }

    public String getURL(String hostname, String port, String databaseName) {
        return "jdbc:vertica://" + hostname + ":" + port + "/" + databaseName;
    }

    public boolean isFetchSizeSupported() {
        return false;
    }

    public boolean isSupportsBitmapIndex() {
        return false;
    }

    public String getAddColumnStatement(String tableName, IValueMeta v, String tk, boolean useAutoinc, String pk, boolean semicolon) {
        return "--NOTE: Table cannot be altered unless all projections are dropped.\nALTER TABLE " + tableName + " ADD " + this.getFieldDefinition(v, tk, pk, useAutoinc, true, false);
    }

    public String getModifyColumnStatement(String tableName, IValueMeta v, String tk, boolean useAutoinc, String pk, boolean semicolon) {
        return "--NOTE: Table cannot be altered unless all projections are dropped.\nALTER TABLE " + tableName + " ALTER COLUMN " + v.getName() + " SET DATA TYPE " + this.getFieldDefinition(v, tk, pk, useAutoinc, false, false);
    }

    public String getFieldDefinition(IValueMeta v, String tk, String pk, boolean useAutoinc, boolean addFieldName, boolean addCr) {
        Object retval = "";
        String fieldname = v.getName();
        int length = v.getLength();
        if (addFieldName) {
            retval = (String)retval + fieldname + " ";
        }
        int type = v.getType();
        switch (type) {
            case 3: 
            case 9: {
                retval = (String)retval + "TIMESTAMP";
                break;
            }
            case 4: {
                retval = (String)retval + "BOOLEAN";
                break;
            }
            case 1: 
            case 6: {
                retval = (String)retval + "FLOAT";
                break;
            }
            case 5: {
                retval = (String)retval + "INTEGER";
                break;
            }
            case 2: {
                if (length < 1) {
                    retval = (String)retval + "VARCHAR";
                    break;
                }
                if (length > 65000) {
                    retval = (String)retval + "LONG VARCHAR(" + length + ")";
                    break;
                }
                retval = (String)retval + "VARCHAR(" + length + ")";
                break;
            }
            case 8: {
                if (length < 1) {
                    retval = (String)retval + "VARBINARY";
                    break;
                }
                if (length > 65000) {
                    retval = (String)retval + "LONG VARBINARY(" + length + ")";
                    break;
                }
                retval = (String)retval + "VARBINARY(" + length + ")";
                break;
            }
            default: {
                retval = (String)retval + " UNKNOWN";
            }
        }
        if (addCr) {
            retval = (String)retval + Const.CR;
        }
        return retval;
    }

    public int getDefaultDatabasePort() {
        return 5433;
    }

    public String getLimitClause(int nrRows) {
        return " LIMIT " + nrRows;
    }

    public int getMaxVARCHARLength() {
        return 4000;
    }

    public String[] getReservedWords() {
        return new String[]{"ABORT", "ABSOLUTE", "ACCESS", "ACTION", "ADD", "AFTER", "AGGREGATE", "ALL", "ALSO", "ALTER", "ANALYSE", "ANALYZE", "AND", "ANY", "ARRAY", "AS", "ASC", "ASSERTION", "ASSIGNMENT", "AT", "AUTHORIZATION", "BACKWARD", "BEFORE", "BEGIN", "BETWEEN", "BIGINT", "BINARY", "BIT", "BLOCK_DICT", "BLOCKDICT_COMP", "BOOLEAN", "BOTH", "BY", "CACHE", "CALLED", "CASCADE", "CASE", "CAST", "CATALOG_PATH", "CHAIN", "CHAR", "CHARACTER", "CHARACTERISTICS", "CHECK", "CHECKPOINT", "CLASS", "CLOSE", "CLUSTER", "COALESCE", "COLLATE", "COLUMN", "COMMENT", "COMMIT", "COMMITTED", "COMMONDELTA_COMP", "CONSTRAINT", "CONSTRAINTS", "CONVERSION", "CONVERT", "COPY", "CORRELATION", "CREATE", "CREATEDB", "CREATEUSER", "CROSS", "CSV", "CURRENT_DATABASE", "CURRENT_DATE", "CURRENT_TIME", "CURRENT_TIMESTAMP", "CURRENT_USER", "CURSOR", "CYCLE", "DATA", "DATABASE", "DATAPATH", "DAY", "DEALLOCATE", "DEC", "DECIMAL", "DECLARE", "DEFAULT", "DEFAULTS", "DEFERRABLE", "DEFERRED", "DEFINER", "DELETE", "DELIMITER", "DELIMITERS", "DELTARANGE_COMP", "DELTARANGE_COMP_SP", "DELTAVAL", "DESC", "DETERMINES", "DIRECT", "DISTINCT", "DISTVALINDEX", "DO", "DOMAIN", "DOUBLE", "DROP", "EACH", "ELSE", "ENCODING", "ENCRYPTED", "END", "EPOCH", "ERROR", "ESCAPE", "EXCEPT", "EXCEPTIONS", "EXCLUDING", "EXCLUSIVE", "EXECUTE", "EXISTS", "EXPLAIN", "EXTERNAL", "EXTRACT", "FALSE", "FETCH", "FIRST", "FLOAT", "FOR", "FORCE", "FOREIGN", "FORWARD", "FREEZE", "FROM", "FULL", "FUNCTION", "GLOBAL", "GRANT", "GROUP", "HANDLER", "HAVING", "HOLD", "HOUR", "ILIKE", "IMMEDIATE", "IMMUTABLE", "IMPLICIT", "IN", "IN_P", "INCLUDING", "INCREMENT", "INDEX", "INHERITS", "INITIALLY", "INNER", "INOUT", "INPUT", "INSENSITIVE", "INSERT", "INSTEAD", "INT", "INTEGER", "INTERSECT", "INTERVAL", "INTO", "INVOKER", "IS", "ISNULL", "ISOLATION", "JOIN", "KEY", "LANCOMPILER", "LANGUAGE", "LARGE", "LAST", "LATEST", "LEADING", "LEFT", "LESS", "LEVEL", "LIKE", "LIMIT", "LISTEN", "LOAD", "LOCAL", "LOCALTIME", "LOCALTIMESTAMP", "LOCATION", "LOCK", "MATCH", "MAXVALUE", "MERGEOUT", "MINUTE", "MINVALUE", "MOBUF", "MODE", "MONTH", "MOVE", "MOVEOUT", "MULTIALGORITHM_COMP", "MULTIALGORITHM_COMP_SP", "NAMES", "NATIONAL", "NATURAL", "NCHAR", "NEW", "NEXT", "NO", "NOCREATEDB", "NOCREATEUSER", "NODE", "NODES", "NONE", "NOT", "NOTHING", "NOTIFY", "NOTNULL", "NOWAIT", "NULL", "NULLIF", "NUMERIC", "OBJECT", "OF", "OFF", "OFFSET", "OIDS", "OLD", "ON", "ONLY", "OPERATOR", "OPTION", "OR", "ORDER", "OUT", "OUTER", "OVERLAPS", "OVERLAY", "OWNER", "PARTIAL", "PARTITION", "PASSWORD", "PLACING", "POSITION", "PRECISION", "PREPARE", "PRESERVE", "PRIMARY", "PRIOR", "PRIVILEGES", "PROCEDURAL", "PROCEDURE", "PROJECTION", "QUOTE", "READ", "REAL", "RECHECK", "RECORD", "RECOVER", "REFERENCES", "REFRESH", "REINDEX", "REJECTED", "RELATIVE", "RELEASE", "RENAME", "REPEATABLE", "REPLACE", "RESET", "RESTART", "RESTRICT", "RETURNS", "REVOKE", "RIGHT", "RLE", "ROLLBACK", "ROW", "ROWS", "RULE", "SAVEPOINT", "SCHEMA", "SCROLL", "SECOND", "SECURITY", "SEGMENTED", "SELECT", "SEQUENCE", "SERIALIZABLE", "SESSION", "SESSION_USER", "SET", "SETOF", "SHARE", "SHOW", "SIMILAR", "SIMPLE", "SMALLINT", "SOME", "SPLIT", "STABLE", "START", "STATEMENT", "STATISTICS", "STDIN", "STDOUT", "STORAGE", "STRICT", "SUBSTRING", "SYSID", "TABLE", "TABLESPACE", "TEMP", "TEMPLATE", "TEMPORARY", "TERMINATOR", "THAN", "THEN", "TIME", "TIMESTAMP", "TIMESTAMPTZ", "TIMETZ", "TO", "TOAST", "TRAILING", "TRANSACTION", "TREAT", "TRIGGER", "TRIM", "TRUE", "TRUE_P", "TRUNCATE", "TRUSTED", "TYPE", "UNCOMMITTED", "UNENCRYPTED", "UNION", "UNIQUE", "UNKNOWN", "UNLISTEN", "UNSEGMENTED", "UNTIL", "UPDATE", "USAGE", "USER", "USING", "VACUUM", "VALID", "VALIDATOR", "VALINDEX", "VALUES", "VARCHAR", "VARYING", "VERBOSE", "VIEW", "VOLATILE", "WHEN", "WHERE", "WITH", "WITHOUT", "WORK", "WRITE", "YEAR", "ZONE"};
    }

    public String getSqlColumnExists(String columnname, String tableName) {
        return super.getSqlColumnExists(columnname, tableName) + this.getLimitClause(1);
    }

    public String getSqlQueryFields(String tableName) {
        return super.getSqlQueryFields(tableName) + this.getLimitClause(1);
    }

    public String getSqlTableExists(String tableName) {
        return super.getSqlTableExists(tableName) + this.getLimitClause(1);
    }

    public String[] getViewTypes() {
        return new String[0];
    }

    public boolean isSupportsAutoInc() {
        return false;
    }

    public boolean isSupportsBooleanDataType() {
        return true;
    }

    public boolean isRequiresCastToVariousForIsNull() {
        return true;
    }

    public String getExtraOptionIndicator() {
        return "?";
    }

    public String getExtraOptionSeparator() {
        return "&";
    }

    public boolean isSupportsSequences() {
        return true;
    }

    public String getSqlSequenceExists(String sequenceName) {
        return "SELECT sequence_name FROM sequences WHERE sequence_name = '" + sequenceName + "'";
    }

    public String getSqlListOfSequences() {
        return "SELECT sequence_name FROM sequences";
    }

    public String getSqlCurrentSequenceValue(String sequenceName) {
        return "SELECT currval('" + sequenceName + "')";
    }

    public String getSqlNextSequenceValue(String sequenceName) {
        return "SELECT nextval('" + sequenceName + "')";
    }

    public boolean isSupportsTimeStampToDateConversion() {
        return false;
    }

    public boolean isSupportsGetBlob() {
        return false;
    }

    public boolean isDisplaySizeTwiceThePrecision() {
        return true;
    }
}

