/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.aws.sns;

import com.amazonaws.AmazonClientException;
import com.amazonaws.regions.Region;
import com.amazonaws.regions.RegionUtils;
import java.util.Arrays;
import java.util.List;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.RowMeta;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transforms.aws.sns.SnsNotifyMeta;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.widget.ColumnInfo;
import org.apache.hop.ui.core.widget.ComboVar;
import org.apache.hop.ui.core.widget.PasswordTextVar;
import org.apache.hop.ui.core.widget.TableView;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class SnsNotifyDialog
extends BaseTransformDialog {
    private static final Class<?> PKG = SnsNotifyMeta.class;
    private SnsNotifyMeta meta;
    private Label lblAWSKey;
    private TextVar tAWSKey;
    private Label lblAWSKeySecret;
    private PasswordTextVar tAWSKeySecret;
    private Label lblAWSRegion;
    private ComboVar tAWSRegion;
    private Combo tnotifyPoint;
    private TextVar tMessageID;
    private ColumnInfo fieldColumn;
    private TableView tTableNotifyProps;
    private ComboVar tAWSCredChain;

    public SnsNotifyDialog(Shell parent, IVariables variables, SnsNotifyMeta transformMeta, PipelineMeta pipelineMeta) {
        super(parent, variables, (ITransformMeta)transformMeta, pipelineMeta);
        this.meta = transformMeta;
    }

    public String open() {
        Shell parent = this.getParent();
        Display display = parent.getDisplay();
        this.shell = new Shell(parent, 3312);
        PropsUi.setLook((Widget)this.shell);
        this.setShellImage(this.shell, (ITransformMeta)this.meta);
        this.changed = this.meta.hasChanged();
        ModifyListener lsMod = e -> this.meta.setChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"SNSNotify.Shell.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = 4;
        this.wlTransformName = new Label((Composite)this.shell, 131072);
        this.wlTransformName.setText(BaseMessages.getString(PKG, (String)"System.TransformName.Label", (String[])new String[0]));
        this.wlTransformName.setToolTipText(BaseMessages.getString(PKG, (String)"System.TransformName.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlTransformName);
        this.fdlTransformName = new FormData();
        this.fdlTransformName.left = new FormAttachment(0, 0);
        this.fdlTransformName.right = new FormAttachment(middle, -margin);
        this.fdlTransformName.top = new FormAttachment(0, margin);
        this.wlTransformName.setLayoutData((Object)this.fdlTransformName);
        this.wTransformName = new Text((Composite)this.shell, 18436);
        this.wTransformName.setText(this.transformName);
        PropsUi.setLook((Widget)this.wTransformName);
        this.wTransformName.addModifyListener(lsMod);
        this.fdTransformName = new FormData();
        this.fdTransformName.left = new FormAttachment(middle, 0);
        this.fdTransformName.top = new FormAttachment(0, margin);
        this.fdTransformName.right = new FormAttachment(100, 0);
        this.wTransformName.setLayoutData((Object)this.fdTransformName);
        CTabFolder tabFolder = new CTabFolder((Composite)this.shell, 2048);
        FormData fdTabFolder = new FormData();
        fdTabFolder.right = new FormAttachment(100, 0);
        fdTabFolder.top = new FormAttachment((Control)this.wTransformName, margin);
        fdTabFolder.left = new FormAttachment(0, 0);
        fdTabFolder.bottom = new FormAttachment(100, -50);
        tabFolder.setLayoutData((Object)fdTabFolder);
        PropsUi.setLook((Widget)tabFolder);
        CTabItem tbtmSettings = new CTabItem(tabFolder, 0);
        tbtmSettings.setText(BaseMessages.getString(PKG, (String)"SNSNotifyTransform.Settings.Title", (String[])new String[0]));
        ScrolledComposite scrlSettingsComp = new ScrolledComposite((Composite)tabFolder, 768);
        scrlSettingsComp.setLayout((Layout)new FillLayout());
        PropsUi.setLook((Widget)scrlSettingsComp);
        Composite settingsComp = new Composite((Composite)scrlSettingsComp, 0);
        PropsUi.setLook((Widget)settingsComp);
        FormLayout settingsLayout = new FormLayout();
        settingsLayout.marginWidth = 3;
        settingsLayout.marginHeight = 3;
        settingsComp.setLayout((Layout)settingsLayout);
        Label lblAWSCredChain = new Label(settingsComp, 131072);
        PropsUi.setLook((Widget)lblAWSCredChain);
        FormData fdLblAWSCredChain = new FormData();
        fdLblAWSCredChain.left = new FormAttachment(0, 0);
        fdLblAWSCredChain.top = new FormAttachment(0, margin);
        fdLblAWSCredChain.right = new FormAttachment(middle, -margin);
        lblAWSCredChain.setLayoutData((Object)fdLblAWSCredChain);
        lblAWSCredChain.setText(BaseMessages.getString(PKG, (String)"SNSNotifyTransform.Settings.AWSCredChain.Label", (String[])new String[0]));
        this.tAWSCredChain = new ComboVar(this.variables, settingsComp, 18436);
        PropsUi.setLook((Widget)this.tAWSCredChain);
        FormData fdTAWSCredChain = new FormData();
        fdTAWSCredChain.top = new FormAttachment(0, margin);
        fdTAWSCredChain.left = new FormAttachment(middle, 0);
        fdTAWSCredChain.right = new FormAttachment(100, 0);
        this.tAWSCredChain.setLayoutData((Object)fdTAWSCredChain);
        this.tAWSCredChain.setToolTipText(BaseMessages.getString(PKG, (String)"SNSNotifyTransform.Settings.AWSCredChain.Tooltip", (String[])new String[0]));
        this.tAWSCredChain.addModifyListener(arg0 -> this.changeCredentialChainSelection());
        this.lblAWSKey = new Label(settingsComp, 131072);
        PropsUi.setLook((Widget)this.lblAWSKey);
        FormData fdLblAWSKey = new FormData();
        fdLblAWSKey.left = new FormAttachment(0, 0);
        fdLblAWSKey.top = new FormAttachment((Control)this.tAWSCredChain, margin);
        fdLblAWSKey.right = new FormAttachment(middle, -margin);
        this.lblAWSKey.setLayoutData((Object)fdLblAWSKey);
        this.lblAWSKey.setText(BaseMessages.getString(PKG, (String)"SNSNotifyTransform.Settings.AWSKey.Label", (String[])new String[0]));
        this.tAWSKey = new TextVar(this.variables, settingsComp, 18436);
        PropsUi.setLook((Widget)this.tAWSKey);
        FormData fdTAWSKey = new FormData();
        fdTAWSKey.top = new FormAttachment((Control)this.tAWSCredChain, margin);
        fdTAWSKey.left = new FormAttachment(middle, 0);
        fdTAWSKey.right = new FormAttachment(100, 0);
        this.tAWSKey.setLayoutData((Object)fdTAWSKey);
        this.tAWSKey.setToolTipText(BaseMessages.getString(PKG, (String)"SNSNotifyTransform.Settings.AWSKey.Tooltip", (String[])new String[0]));
        this.lblAWSKeySecret = new Label(settingsComp, 131072);
        PropsUi.setLook((Widget)this.lblAWSKeySecret);
        FormData fdLblAWSKeySecret = new FormData();
        fdLblAWSKeySecret.left = new FormAttachment(0, 0);
        fdLblAWSKeySecret.top = new FormAttachment((Control)this.tAWSKey, margin);
        fdLblAWSKeySecret.right = new FormAttachment(middle, -margin);
        this.lblAWSKeySecret.setLayoutData((Object)fdLblAWSKeySecret);
        this.lblAWSKeySecret.setText(BaseMessages.getString(PKG, (String)"SNSNotifyTransform.Settings.AWSKeySecret.Label", (String[])new String[0]));
        this.tAWSKeySecret = new PasswordTextVar(this.variables, settingsComp, 18436);
        PropsUi.setLook((Widget)this.tAWSKeySecret);
        FormData fdTAWSKeySecret = new FormData();
        fdTAWSKeySecret.top = new FormAttachment((Control)this.tAWSKey, margin);
        fdTAWSKeySecret.left = new FormAttachment(middle, 0);
        fdTAWSKeySecret.right = new FormAttachment(100, 0);
        this.tAWSKeySecret.setLayoutData((Object)fdTAWSKeySecret);
        this.tAWSKeySecret.setToolTipText(BaseMessages.getString(PKG, (String)"SNSNotifyTransform.Settings.AWSKeySecret.Tooltip", (String[])new String[0]));
        this.lblAWSRegion = new Label(settingsComp, 131072);
        PropsUi.setLook((Widget)this.lblAWSRegion);
        FormData fdLblAWSRegion = new FormData();
        fdLblAWSRegion.left = new FormAttachment(0, 0);
        fdLblAWSRegion.top = new FormAttachment((Control)this.tAWSKeySecret, margin);
        fdLblAWSRegion.right = new FormAttachment(middle, -margin);
        this.lblAWSRegion.setLayoutData((Object)fdLblAWSRegion);
        this.lblAWSRegion.setText(BaseMessages.getString(PKG, (String)"SNSNotifyTransform.Settings.AWSRegion.Label", (String[])new String[0]));
        this.tAWSRegion = new ComboVar(this.variables, settingsComp, 18436);
        PropsUi.setLook((Widget)this.tAWSRegion);
        FormData fdTAWSRegion = new FormData();
        fdTAWSRegion.top = new FormAttachment((Control)this.tAWSKeySecret, margin);
        fdTAWSRegion.left = new FormAttachment(middle, 0);
        fdTAWSRegion.right = new FormAttachment(100, 0);
        this.tAWSRegion.setLayoutData((Object)fdTAWSRegion);
        this.tAWSRegion.setToolTipText(BaseMessages.getString(PKG, (String)"SNSNotifyTransform.Settings.AWSRegion.Tooltip", (String[])new String[0]));
        this.populateAWSRegion(this.tAWSRegion);
        Control[] queueTabList = new Control[]{this.tAWSKey, this.tAWSKeySecret, this.tAWSRegion};
        settingsComp.setTabList(queueTabList);
        settingsComp.pack();
        Rectangle settingsBounds = settingsComp.getBounds();
        scrlSettingsComp.setContent((Control)settingsComp);
        scrlSettingsComp.setExpandHorizontal(true);
        scrlSettingsComp.setExpandVertical(true);
        scrlSettingsComp.setMinWidth(settingsBounds.width);
        scrlSettingsComp.setMinHeight(settingsBounds.height);
        CTabItem tbtmNotifications = new CTabItem(tabFolder, 0);
        tbtmNotifications.setText(BaseMessages.getString(PKG, (String)"SNSNotifyTransform.Notifications.Title", (String[])new String[0]));
        ScrolledComposite scrlNotificationsComp = new ScrolledComposite((Composite)tabFolder, 768);
        scrlNotificationsComp.setLayout((Layout)new FillLayout());
        PropsUi.setLook((Widget)scrlNotificationsComp);
        Composite notificationsComp = new Composite((Composite)scrlNotificationsComp, 0);
        PropsUi.setLook((Widget)notificationsComp);
        FormLayout notificationsLayout = new FormLayout();
        notificationsLayout.marginWidth = 3;
        notificationsLayout.marginHeight = 3;
        notificationsComp.setLayout((Layout)notificationsLayout);
        Label lblnotifyPoint = new Label(notificationsComp, 131072);
        PropsUi.setLook((Widget)lblnotifyPoint);
        FormData fdLblnotifyPoint = new FormData();
        fdLblnotifyPoint.left = new FormAttachment(0, 0);
        fdLblnotifyPoint.top = new FormAttachment(0, margin);
        fdLblnotifyPoint.right = new FormAttachment(middle, -margin);
        lblnotifyPoint.setLayoutData((Object)fdLblnotifyPoint);
        lblnotifyPoint.setText(BaseMessages.getString(PKG, (String)"SNSNotifyTransform.Notifications.notifyPoint.Label", (String[])new String[0]));
        this.tnotifyPoint = new Combo(notificationsComp, 18444);
        PropsUi.setLook((Widget)this.tnotifyPoint);
        FormData fdTnotifyPoint = new FormData();
        fdTnotifyPoint.top = new FormAttachment(0, margin);
        fdTnotifyPoint.left = new FormAttachment(middle, 0);
        fdTnotifyPoint.right = new FormAttachment(100, 0);
        this.tnotifyPoint.setLayoutData((Object)fdTnotifyPoint);
        this.tnotifyPoint.setToolTipText(BaseMessages.getString(PKG, (String)"SNSNotifyTransform.Notifications.notifyPoint.Tooltip", (String[])new String[0]));
        this.tnotifyPoint.setItems(this.meta.getNotifyPointValues());
        Label lblMessageID = new Label(notificationsComp, 131072);
        PropsUi.setLook((Widget)lblMessageID);
        FormData fdLblMessageID = new FormData();
        fdLblMessageID.left = new FormAttachment(0, 0);
        fdLblMessageID.top = new FormAttachment((Control)this.tnotifyPoint, margin);
        fdLblMessageID.right = new FormAttachment(middle, -margin);
        lblMessageID.setLayoutData((Object)fdLblMessageID);
        lblMessageID.setText(BaseMessages.getString(PKG, (String)"SNSNotifyTransform.Notifications.MessageID.Label", (String[])new String[0]));
        this.tMessageID = new TextVar(this.variables, notificationsComp, 18436);
        PropsUi.setLook((Widget)this.tMessageID);
        FormData fdTMessageID = new FormData();
        fdTMessageID.top = new FormAttachment((Control)this.tnotifyPoint, margin);
        fdTMessageID.left = new FormAttachment(middle, 0);
        fdTMessageID.right = new FormAttachment(100, 0);
        this.tMessageID.setLayoutData((Object)fdTMessageID);
        this.tMessageID.setToolTipText(BaseMessages.getString(PKG, (String)"SNSNotifyTransform.Notifications.MessageID.Tooltip", (String[])new String[0]));
        int keyWidgetCols = 4;
        int keyWidgetRows = 3;
        ColumnInfo[] ciNotifyProps = new ColumnInfo[keyWidgetCols];
        ciNotifyProps[0] = new ColumnInfo(BaseMessages.getString(PKG, (String)"SNSNotifyTransform.Notifications.ValueDef.Property.Label", (String[])new String[0]), 1, false);
        ciNotifyProps[1] = new ColumnInfo(BaseMessages.getString(PKG, (String)"SNSNotifyTransform.Notifications.ValueDef.InField.Label", (String[])new String[0]), 2, new String[]{"Y", "N"}, false);
        ciNotifyProps[2] = new ColumnInfo(BaseMessages.getString(PKG, (String)"SNSNotifyTransform.Notifications.ValueDef.Field.Label", (String[])new String[0]), 2, new String[0], false);
        ciNotifyProps[3] = new ColumnInfo(BaseMessages.getString(PKG, (String)"SNSNotifyTransform.Notifications.ValueDef.Value.Label", (String[])new String[0]), 1, false);
        ciNotifyProps[0].setToolTip(BaseMessages.getString(PKG, (String)"SNSNotifyTransform.Notifications.ValueDef.Property.Tooltip", (String[])new String[0]));
        ciNotifyProps[0].setReadOnly(true);
        ciNotifyProps[1].setToolTip(BaseMessages.getString(PKG, (String)"SNSNotifyTransform.Notifications.ValueDef.InField.Tooltip", (String[])new String[0]));
        ciNotifyProps[2].setToolTip(BaseMessages.getString(PKG, (String)"SNSNotifyTransform.Notifications.ValueDef.Field.Tooltip", (String[])new String[0]));
        ciNotifyProps[3].setToolTip(BaseMessages.getString(PKG, (String)"SNSNotifyTransform.Notifications.ValueDef.Value.Tooltip", (String[])new String[0]));
        ciNotifyProps[3].setUsingVariables(true);
        this.fieldColumn = ciNotifyProps[2];
        this.tTableNotifyProps = new TableView(this.variables, notificationsComp, 68354, ciNotifyProps, keyWidgetRows, lsMod, this.props);
        FormData fdTableNotifyProps = new FormData();
        fdTableNotifyProps.left = new FormAttachment(0, 0);
        fdTableNotifyProps.top = new FormAttachment((Control)this.tMessageID, margin);
        fdTableNotifyProps.right = new FormAttachment(100, 0);
        fdTableNotifyProps.bottom = new FormAttachment(100, -margin);
        this.tTableNotifyProps.setLayoutData((Object)fdTableNotifyProps);
        Control[] notificationTabList = new Control[]{this.tnotifyPoint, this.tMessageID, this.tTableNotifyProps};
        notificationsComp.setTabList(notificationTabList);
        notificationsComp.pack();
        Rectangle notificationsBounds = notificationsComp.getBounds();
        scrlNotificationsComp.setContent((Control)notificationsComp);
        scrlNotificationsComp.setExpandHorizontal(true);
        scrlNotificationsComp.setExpandVertical(true);
        scrlNotificationsComp.setMinWidth(notificationsBounds.width);
        scrlNotificationsComp.setMinHeight(notificationsBounds.height);
        scrlSettingsComp.layout();
        tbtmSettings.setControl((Control)scrlSettingsComp);
        scrlNotificationsComp.layout();
        tbtmNotifications.setControl((Control)scrlNotificationsComp);
        tabFolder.setSelection(0);
        this.wOk = new Button((Composite)this.shell, 8);
        this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        BaseTransformDialog.positionBottomButtons((Composite)this.shell, (Button[])new Button[]{this.wOk, this.wCancel}, (int)margin, null);
        this.wOk.addListener(13, c -> this.ok());
        this.wCancel.addListener(13, c -> this.cancel());
        SelectionAdapter lsDef = new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                SnsNotifyDialog.this.ok();
            }
        };
        this.wTransformName.addSelectionListener((SelectionListener)lsDef);
        this.tAWSKey.addSelectionListener(lsDef);
        this.tAWSKeySecret.addSelectionListener(lsDef);
        this.tAWSRegion.addSelectionListener((SelectionListener)lsDef);
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                SnsNotifyDialog.this.cancel();
            }
        });
        this.setSize();
        this.populateYesNoSelection();
        this.populateDialog();
        this.meta.setChanged(this.changed);
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.transformName;
    }

    protected void changeCredentialChainSelection() {
        if (this.tAWSCredChain.getText().equalsIgnoreCase("Y")) {
            this.lblAWSKey.setEnabled(false);
            this.tAWSKey.setEnabled(false);
            this.lblAWSKeySecret.setEnabled(false);
            this.tAWSKeySecret.setEnabled(false);
            this.lblAWSRegion.setEnabled(false);
            this.tAWSRegion.setEnabled(false);
        } else {
            this.lblAWSKey.setEnabled(true);
            this.tAWSKey.setEnabled(true);
            this.lblAWSKeySecret.setEnabled(true);
            this.tAWSKeySecret.setEnabled(true);
            this.lblAWSRegion.setEnabled(true);
            this.tAWSRegion.setEnabled(true);
        }
        this.meta.setChanged();
    }

    private void populateYesNoSelection() {
        this.tAWSCredChain.removeAll();
        this.tAWSCredChain.add("Y");
        this.tAWSCredChain.add("N");
        this.tAWSCredChain.select(0);
    }

    private void setComboValues() {
        Runnable fieldLoader = () -> {
            RowMeta prevFields;
            try {
                prevFields = this.pipelineMeta.getPrevTransformFields(this.variables, this.transformName);
            }
            catch (HopException e) {
                prevFields = new RowMeta();
                this.logError(BaseMessages.getString(PKG, (String)"SNSNotifyTransform.ErrorText.NoPrevFields", (String[])new String[0]));
            }
            Object[] prevTransformFieldNames = prevFields.getFieldNames();
            Arrays.sort(prevTransformFieldNames);
            this.fieldColumn.setComboValues((String[])prevTransformFieldNames);
        };
        new Thread(fieldLoader).start();
    }

    private void populateAWSRegion(ComboVar tAWSRegion2) {
        tAWSRegion2.removeAll();
        try {
            List snsRegions = RegionUtils.getRegionsForService((String)"sns");
            for (Region region : snsRegions) {
                tAWSRegion2.add(region.getName());
            }
        }
        catch (AmazonClientException e) {
            this.logError(BaseMessages.getString(PKG, (String)e.getMessage(), (String[])new String[0]));
        }
    }

    private void populateDialog() {
        this.wTransformName.selectAll();
        this.tAWSCredChain.setText(this.meta.getAwsCredChain());
        this.tAWSKey.setText(this.meta.getAwsKey());
        this.tAWSKeySecret.setText(this.meta.getAwsKeySecret());
        this.tAWSRegion.setText(this.meta.getAwsRegion());
        this.tnotifyPoint.setText(this.meta.getNotifyPoint());
        this.tMessageID.setText(this.meta.getTFldMessageID());
        this.setComboValues();
        this.tTableNotifyProps.setText("topicARN", 1, 0);
        this.tTableNotifyProps.setText(this.meta.getCInputtopicArn(), 2, 0);
        this.tTableNotifyProps.setText(this.meta.getTFldtopicARN(), 3, 0);
        this.tTableNotifyProps.setText(this.meta.getTValuetopicARN(), 4, 0);
        this.tTableNotifyProps.setText("Subject", 1, 1);
        this.tTableNotifyProps.setText(this.meta.getCInputSubject(), 2, 1);
        this.tTableNotifyProps.setText(this.meta.getTFldSubject(), 3, 1);
        this.tTableNotifyProps.setText(this.meta.getTValueSubject(), 4, 1);
        this.tTableNotifyProps.setText("Message", 1, 2);
        this.tTableNotifyProps.setText(this.meta.getCInputMessage(), 2, 2);
        this.tTableNotifyProps.setText(this.meta.getTFldMessage(), 3, 2);
        this.tTableNotifyProps.setText(this.meta.getTValueMessage(), 4, 2);
    }

    private void cancel() {
        this.transformName = null;
        this.meta.setChanged(this.changed);
        this.dispose();
    }

    private void ok() {
        this.transformName = this.wTransformName.getText();
        this.meta.setAwsCredChain(this.tAWSCredChain.getText());
        this.meta.setAwsKey(this.tAWSKey.getText());
        this.meta.setAwsKeySecret(this.tAWSKeySecret.getText());
        this.meta.setAwsRegion(this.tAWSRegion.getText());
        this.meta.setNotifyPoint(this.tnotifyPoint.getText());
        this.meta.setTFldMessageID(this.tMessageID.getText());
        int nrKeys = this.tTableNotifyProps.nrNonEmpty();
        for (int i = 0; i < nrKeys; ++i) {
            TableItem item = this.tTableNotifyProps.getNonEmpty(i);
            if (item.getText(1).equals("topicARN")) {
                this.meta.setCInputtopicArn(item.getText(2).isEmpty() ? "N" : item.getText(2));
                this.meta.setTFldtopicARN(item.getText(3));
                this.meta.setTValuetopicARN(item.getText(4));
            }
            if (item.getText(1).equals("Subject")) {
                this.meta.setCInputSubject(item.getText(2).isEmpty() ? "N" : item.getText(2));
                this.meta.setTFldSubject(item.getText(3));
                this.meta.setTValueSubject(item.getText(4));
            }
            if (!item.getText(1).equals("Message")) continue;
            this.meta.setCInputMessage(item.getText(2).isEmpty() ? "N" : item.getText(2));
            this.meta.setTFldMessage(item.getText(3));
            this.meta.setTValueMessage(item.getText(4));
        }
        this.dispose();
    }
}

