/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.core.dialog;

import java.util.List;
import org.apache.hop.core.Const;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.EnterTextDialog;
import org.apache.hop.ui.core.gui.GuiResource;
import org.apache.hop.ui.core.gui.WindowProperty;
import org.apache.hop.ui.core.widget.ColumnInfo;
import org.apache.hop.ui.core.widget.TableView;
import org.apache.hop.ui.hopgui.HopGui;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;

public class CheckResultDialog
extends Dialog {
    private static final Class<?> PKG = CheckResultDialog.class;
    private static final String STRING_HIDE_SUCESSFUL = BaseMessages.getString(PKG, (String)"CheckResultDialog.HideSuccessful.Label", (String[])new String[0]);
    private static final String STRING_SHOW_SUCESSFUL = BaseMessages.getString(PKG, (String)"CheckResultDialog.ShowSuccessful.Label", (String[])new String[0]);
    private static final String STRING_HIDE_REMARKS = BaseMessages.getString(PKG, (String)"CheckResultDialog.Remarks.Label", (String[])new String[0]);
    private static final String STRING_SHOW_REMARKS = BaseMessages.getString(PKG, (String)"CheckResultDialog.WarningsErrors.Label", (String[])new String[0]);
    private final List<ICheckResult> remarks;
    private Label wlFields;
    private TableView wFields;
    private Button wNoOK;
    private Shell shell;
    private final PropsUi props;
    private Color red;
    private Color green;
    private Color yellow;
    private boolean showSuccessfulResults = false;
    private String transformName;

    public CheckResultDialog(Shell parent, List<ICheckResult> rem) {
        super(parent, 0);
        this.remarks = rem;
        this.props = PropsUi.getInstance();
        this.transformName = null;
    }

    public String open() {
        Shell parent = this.getParent();
        Display display = parent.getDisplay();
        this.red = display.getSystemColor(3);
        this.green = display.getSystemColor(5);
        this.yellow = display.getSystemColor(7);
        this.shell = new Shell(parent, 3184);
        PropsUi.setLook((Widget)this.shell);
        this.shell.setImage(GuiResource.getInstance().getImagePipeline());
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = PropsUi.getFormMargin();
        formLayout.marginHeight = PropsUi.getFormMargin();
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"CheckResultDialog.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = PropsUi.getMargin();
        Button wClose = new Button((Composite)this.shell, 8);
        wClose.setText(BaseMessages.getString(PKG, (String)"System.Button.Close", (String[])new String[0]));
        wClose.addListener(13, e -> this.close());
        Button wView = new Button((Composite)this.shell, 8);
        wView.setText(BaseMessages.getString(PKG, (String)"CheckResultDialog.Button.ViewMessage", (String[])new String[0]));
        wView.addListener(13, e -> this.view());
        Button wEdit = new Button((Composite)this.shell, 8);
        wEdit.setText(BaseMessages.getString(PKG, (String)"CheckResultDialog.Button.EditOriginTransform", (String[])new String[0]));
        wEdit.addListener(13, e -> this.edit());
        BaseTransformDialog.positionBottomButtons((Composite)this.shell, new Button[]{wClose, wView, wEdit}, margin, null);
        this.wNoOK = new Button((Composite)this.shell, 32);
        this.wNoOK.setText(STRING_SHOW_SUCESSFUL);
        PropsUi.setLook((Widget)this.wNoOK);
        FormData fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.bottom = new FormAttachment((Control)wClose, -2 * margin);
        this.wNoOK.setLayoutData((Object)fd);
        this.wNoOK.addListener(13, e -> this.noOK());
        this.wlFields = new Label((Composite)this.shell, 16384);
        this.wlFields.setText(BaseMessages.getString(PKG, (String)"CheckResultDialog.Remarks.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlFields);
        FormData fdlFields = new FormData();
        fdlFields.left = new FormAttachment(0, 0);
        fdlFields.right = new FormAttachment(middle, -margin);
        fdlFields.top = new FormAttachment(0, margin);
        this.wlFields.setLayoutData((Object)fdlFields);
        int nrColumns = 3;
        int nrRows = 1;
        ColumnInfo[] columns = new ColumnInfo[nrColumns];
        columns[0] = new ColumnInfo(BaseMessages.getString(PKG, (String)"CheckResultDialog.TransformName.Label", (String[])new String[0]), 1, false, true);
        columns[1] = new ColumnInfo(BaseMessages.getString(PKG, (String)"CheckResultDialog.Result.Label", (String[])new String[0]), 1, false, true);
        columns[2] = new ColumnInfo(BaseMessages.getString(PKG, (String)"CheckResultDialog.Remark.Label", (String[])new String[0]), 1, false, true);
        this.wFields = new TableView(HopGui.getInstance().getVariables(), (Composite)this.shell, 67586, columns, nrRows, true, null, this.props);
        FormData fdFields = new FormData();
        fdFields.left = new FormAttachment(0, 0);
        fdFields.top = new FormAttachment((Control)this.wlFields, margin);
        fdFields.right = new FormAttachment(100, 0);
        fdFields.bottom = new FormAttachment((Control)this.wNoOK, -2 * margin);
        this.wFields.setLayoutData(fdFields);
        this.shell.addListener(21, e -> this.close());
        this.getData();
        BaseTransformDialog.setSize(this.shell);
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.transformName;
    }

    private void noOK() {
        this.showSuccessfulResults = !this.showSuccessfulResults;
        this.getData();
    }

    public void dispose() {
        this.props.setScreen(new WindowProperty(this.shell));
        this.shell.dispose();
    }

    public void getData() {
        this.wFields.table.removeAll();
        for (int i = 0; i < this.remarks.size(); ++i) {
            ICheckResult cr = this.remarks.get(i);
            if (!this.showSuccessfulResults && cr.getType() == 1) continue;
            TableItem ti = new TableItem(this.wFields.table, 0);
            ICheckResultSource sourceMeta = cr.getSourceInfo();
            if (sourceMeta != null) {
                ti.setText(1, sourceMeta.getName());
            } else {
                ti.setText(1, "<global>");
            }
            ti.setText(2, cr.getType() + " - " + cr.getTypeDesc());
            ti.setText(3, cr.getText());
            Color col = ti.getBackground();
            switch (cr.getType()) {
                case 1: {
                    col = this.green;
                    break;
                }
                case 4: {
                    col = this.red;
                    break;
                }
                case 3: {
                    col = this.yellow;
                    break;
                }
            }
            ti.setBackground(col);
        }
        if (this.wFields.table.getItemCount() == 0) {
            this.wFields.clearAll(false);
        }
        this.wFields.setRowNums();
        this.wFields.optWidth(true);
        if (this.showSuccessfulResults) {
            this.wlFields.setText(STRING_HIDE_REMARKS);
            this.wNoOK.setText(STRING_HIDE_SUCESSFUL);
        } else {
            this.wlFields.setText(STRING_SHOW_REMARKS);
            this.wNoOK.setText(STRING_SHOW_SUCESSFUL);
        }
        this.shell.layout();
    }

    private void view() {
        StringBuilder message = new StringBuilder();
        TableItem[] item = this.wFields.table.getSelection();
        if (item.length == 0) {
            item = this.wFields.table.getItems();
        }
        for (int i = 0; i < item.length; ++i) {
            if (i > 0) {
                message.append("_______________________________________________________________________________").append(Const.CR).append(Const.CR);
            }
            message.append("[").append(item[i].getText(2)).append("] ").append(item[i].getText(1)).append(Const.CR);
            message.append("  ").append(item[i].getText(3)).append(Const.CR).append(Const.CR);
        }
        String subtitle = item.length != 1 ? BaseMessages.getString(PKG, (String)"CheckResultDialog.TextDialog.SubtitlePlural", (String[])new String[0]) : BaseMessages.getString(PKG, (String)"CheckResultDialog.TextDialog.Subtitle", (String[])new String[0]);
        EnterTextDialog etd = new EnterTextDialog(this.shell, BaseMessages.getString(PKG, (String)"CheckResultDialog.TextDialog.Title", (String[])new String[0]), subtitle, message.toString());
        etd.setReadOnly();
        etd.open();
    }

    private void edit() {
        int idx = this.wFields.table.getSelectionIndex();
        if (idx >= 0) {
            this.transformName = this.wFields.table.getItem(idx).getText(1);
            this.dispose();
        }
    }

    private void close() {
        this.dispose();
    }
}

