/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.pipeline.debug;

import java.util.Hashtable;
import java.util.Map;
import org.apache.hop.core.Condition;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.RowMeta;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.debug.PipelineDebugMeta;
import org.apache.hop.pipeline.debug.TransformDebugMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.gui.GuiResource;
import org.apache.hop.ui.core.gui.WindowProperty;
import org.apache.hop.ui.core.widget.ColumnInfo;
import org.apache.hop.ui.core.widget.ConditionEditor;
import org.apache.hop.ui.core.widget.LabelText;
import org.apache.hop.ui.core.widget.TableView;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;

public class PipelineDebugDialog
extends Dialog {
    private static final Class<?> PKG = PipelineDebugDialog.class;
    public static final int DEBUG_CANCEL = 0;
    public static final int DEBUG_LAUNCH = 1;
    public static final int DEBUG_CONFIG = 2;
    private Display display;
    private Shell parent;
    private Shell shell;
    private PropsUi props;
    private int retval;
    private Button wLaunch;
    private TableView wTransforms;
    private final IVariables variables;
    private PipelineDebugMeta pipelineDebugMeta;
    private Composite wComposite;
    private LabelText wRowCount;
    private int margin;
    private int middle;
    private Button wFirstRows;
    private Button wPauseBreakPoint;
    private Condition condition;
    private Map<TransformMeta, TransformDebugMeta> transformDebugMetaMap;
    private int previousIndex;

    public PipelineDebugDialog(Shell parent, IVariables variables, PipelineDebugMeta pipelineDebugMeta) {
        super(parent);
        this.variables = variables;
        this.parent = parent;
        this.pipelineDebugMeta = pipelineDebugMeta;
        this.props = PropsUi.getInstance();
        this.transformDebugMetaMap = new Hashtable<TransformMeta, TransformDebugMeta>();
        this.transformDebugMetaMap.putAll(pipelineDebugMeta.getTransformDebugMetaMap());
        this.previousIndex = -1;
        this.retval = 0;
    }

    public int open() {
        this.display = this.parent.getDisplay();
        this.shell = new Shell(this.parent, 268504304);
        PropsUi.setLook((Widget)this.shell);
        this.shell.setImage(GuiResource.getInstance().getImagePipeline());
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = PropsUi.getFormMargin();
        formLayout.marginHeight = PropsUi.getFormMargin();
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"PipelineDebugDialog.Shell.Title", (String[])new String[0]));
        this.margin = PropsUi.getMargin();
        this.middle = this.props.getMiddlePct();
        Button wOk = new Button((Composite)this.shell, 8);
        wOk.setText(BaseMessages.getString(PKG, (String)"PipelineDebugDialog.Configure.Label", (String[])new String[0]));
        wOk.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PipelineDebugDialog.this.ok(true);
            }
        });
        this.wLaunch = new Button((Composite)this.shell, 8);
        this.wLaunch.setText(BaseMessages.getString(PKG, (String)"PipelineDebugDialog.Launch.Label", (String[])new String[0]));
        this.wLaunch.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PipelineDebugDialog.this.ok(false);
            }
        });
        Button wCancel = new Button((Composite)this.shell, 8);
        wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        wCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PipelineDebugDialog.this.cancel();
            }
        });
        BaseTransformDialog.positionBottomButtons((Composite)this.shell, new Button[]{this.wLaunch, wOk, wCancel}, this.margin, null);
        wOk.setToolTipText(BaseMessages.getString(PKG, (String)"PipelineDebugDialog.Configure.ToolTip", (String[])new String[0]));
        this.wLaunch.setToolTipText(BaseMessages.getString(PKG, (String)"PipelineDebugDialog.Launch.ToolTip", (String[])new String[0]));
        ColumnInfo[] transformColumns = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"PipelineDebugDialog.Column.TransformName", (String[])new String[0]), 1, false, true)};
        int nrTransforms = this.pipelineDebugMeta.getPipelineMeta().nrTransforms();
        this.wTransforms = new TableView(this.variables, (Composite)this.shell, 67588, transformColumns, nrTransforms, true, null, this.props);
        FormData fdTransform = new FormData();
        fdTransform.left = new FormAttachment(0, 0);
        fdTransform.right = new FormAttachment(this.middle, -this.margin);
        fdTransform.top = new FormAttachment(0, this.margin);
        fdTransform.bottom = new FormAttachment((Control)wOk, -this.margin * 2);
        this.wTransforms.setLayoutData(fdTransform);
        this.wTransforms.table.setHeaderVisible(false);
        this.wTransforms.table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PipelineDebugDialog.this.getTransformDebugMeta();
                PipelineDebugDialog.this.showTransformDebugInformation();
            }
        });
        this.wTransforms.table.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.character == '\r') {
                    PipelineDebugDialog.this.wLaunch.notifyListeners(13, new Event());
                }
            }
        });
        this.wComposite = new Composite((Composite)this.shell, 2048);
        PropsUi.setLook((Widget)this.wComposite);
        FormData fdComposite = new FormData();
        fdComposite.left = new FormAttachment(this.middle, 0);
        fdComposite.right = new FormAttachment(100, 0);
        fdComposite.top = new FormAttachment(0, this.margin);
        fdComposite.bottom = new FormAttachment((Control)wOk, -this.margin * 2);
        this.wComposite.setLayoutData((Object)fdComposite);
        FormLayout compositeLayout = new FormLayout();
        compositeLayout.marginWidth = PropsUi.getFormMargin();
        compositeLayout.marginHeight = PropsUi.getFormMargin();
        this.wComposite.setLayout((Layout)compositeLayout);
        this.getData();
        this.wLaunch.setFocus();
        this.shell.setDefaultButton(this.wLaunch);
        BaseDialog.defaultShellHandling(this.shell, c -> this.ok(true), c -> this.cancel());
        return this.retval;
    }

    private void getData() {
        this.getTransformDebugMeta();
        this.refreshTransformList();
    }

    private void refreshTransformList() {
        GuiResource resource = GuiResource.getInstance();
        int maxIconSize = 0;
        int indexSelected = -1;
        this.wTransforms.table.removeAll();
        for (int i = 0; i < this.pipelineDebugMeta.getPipelineMeta().getTransforms().size(); ++i) {
            TransformDebugMeta transformDebugMeta;
            TransformMeta transformMeta = this.pipelineDebugMeta.getPipelineMeta().getTransform(i);
            TableItem item = new TableItem(this.wTransforms.table, 0);
            Image image = resource.getSwtImageTransform(transformMeta.getTransformPluginId()).getAsBitmapForSize((Device)this.display, 32, 32);
            item.setImage(0, image);
            item.setText(0, "");
            item.setText(1, transformMeta.getName());
            if (image.getBounds().width > maxIconSize) {
                maxIconSize = image.getBounds().width;
            }
            if ((transformDebugMeta = this.transformDebugMetaMap.get(transformMeta)) == null) continue;
            item.setBackground(resource.getColorLight());
            if (indexSelected >= 0) continue;
            indexSelected = i;
        }
        this.wTransforms.removeEmptyRows();
        this.wTransforms.optWidth(false);
        this.wTransforms.table.getColumn(0).setWidth(maxIconSize + 10);
        this.wTransforms.table.getColumn(0).setAlignment(0x1000000);
        if (indexSelected >= 0) {
            this.wTransforms.table.setSelection(indexSelected);
            this.showTransformDebugInformation();
        }
    }

    private void getTransformDebugMeta() {
        int index = this.wTransforms.getSelectionIndex();
        if (this.previousIndex >= 0) {
            if (this.wComposite.getChildren().length == 0) {
                return;
            }
            TransformMeta transformMeta = this.pipelineDebugMeta.getPipelineMeta().getTransform(this.previousIndex);
            TransformDebugMeta transformDebugMeta = new TransformDebugMeta(transformMeta);
            transformDebugMeta.setCondition(this.condition);
            transformDebugMeta.setPausingOnBreakPoint(this.wPauseBreakPoint.getSelection());
            transformDebugMeta.setReadingFirstRows(this.wFirstRows.getSelection());
            transformDebugMeta.setRowCount(Const.toInt((String)this.wRowCount.getText(), (int)-1));
            this.transformDebugMetaMap.put(transformMeta, transformDebugMeta);
        }
        this.previousIndex = index;
    }

    private void getInfo(PipelineDebugMeta meta) {
        meta.getTransformDebugMetaMap().clear();
        meta.getTransformDebugMetaMap().putAll(this.transformDebugMetaMap);
    }

    private void ok(boolean config) {
        this.retval = config ? 2 : 1;
        this.getTransformDebugMeta();
        this.getInfo(this.pipelineDebugMeta);
        this.dispose();
    }

    private void dispose() {
        this.props.setScreen(new WindowProperty(this.shell));
        this.shell.dispose();
    }

    private void cancel() {
        this.retval = 0;
        this.dispose();
    }

    private void showTransformDebugInformation() {
        RowMeta transformInputFields;
        for (Control control : this.wComposite.getChildren()) {
            control.dispose();
        }
        this.wComposite.layout(true, true);
        int[] selectionIndices = this.wTransforms.table.getSelectionIndices();
        if (selectionIndices == null || selectionIndices.length != 1) {
            return;
        }
        this.previousIndex = selectionIndices[0];
        final TransformMeta transformMeta = this.pipelineDebugMeta.getPipelineMeta().getTransform(selectionIndices[0]);
        TransformDebugMeta transformDebugMeta = this.transformDebugMetaMap.get(transformMeta);
        this.wRowCount = new LabelText(this.wComposite, BaseMessages.getString(PKG, (String)"PipelineDebugDialog.RowCount.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"PipelineDebugDialog.RowCount.ToolTip", (String[])new String[0]));
        FormData fdRowCount = new FormData();
        fdRowCount.left = new FormAttachment(0, 0);
        fdRowCount.right = new FormAttachment(100, 0);
        fdRowCount.top = new FormAttachment(0, 0);
        this.wRowCount.setLayoutData(fdRowCount);
        this.wRowCount.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent arg0) {
                PipelineDebugDialog.this.ok(false);
            }
        });
        this.wFirstRows = new Button(this.wComposite, 32);
        PropsUi.setLook((Widget)this.wFirstRows);
        this.wFirstRows.setText(BaseMessages.getString(PKG, (String)"PipelineDebugDialog.FirstRows.Label", (String[])new String[0]));
        this.wFirstRows.setToolTipText(BaseMessages.getString(PKG, (String)"PipelineDebugDialog.FirstRows.ToolTip", (String[])new String[0]));
        FormData fdFirstRows = new FormData();
        fdFirstRows.left = new FormAttachment(this.middle, 0);
        fdFirstRows.right = new FormAttachment(100, 0);
        fdFirstRows.top = new FormAttachment((Control)this.wRowCount, this.margin);
        this.wFirstRows.setLayoutData((Object)fdFirstRows);
        this.wPauseBreakPoint = new Button(this.wComposite, 32);
        PropsUi.setLook((Widget)this.wPauseBreakPoint);
        this.wPauseBreakPoint.setText(BaseMessages.getString(PKG, (String)"PipelineDebugDialog.PauseBreakPoint.Label", (String[])new String[0]));
        this.wPauseBreakPoint.setToolTipText(BaseMessages.getString(PKG, (String)"PipelineDebugDialog.PauseBreakPoint.ToolTip", (String[])new String[0]));
        FormData fdPauseBreakPoint = new FormData();
        fdPauseBreakPoint.left = new FormAttachment(this.middle, 0);
        fdPauseBreakPoint.right = new FormAttachment(100, 0);
        fdPauseBreakPoint.top = new FormAttachment((Control)this.wFirstRows, this.margin);
        this.wPauseBreakPoint.setLayoutData((Object)fdPauseBreakPoint);
        this.condition = null;
        if (transformDebugMeta != null) {
            this.condition = transformDebugMeta.getCondition();
        }
        if (this.condition == null) {
            this.condition = new Condition();
        }
        try {
            transformInputFields = this.pipelineDebugMeta.getPipelineMeta().getTransformFields(this.variables, transformMeta);
        }
        catch (HopTransformException e) {
            transformInputFields = new RowMeta();
        }
        Label wlCondition = new Label(this.wComposite, 131072);
        PropsUi.setLook((Widget)wlCondition);
        wlCondition.setText(BaseMessages.getString(PKG, (String)"PipelineDebugDialog.Condition.Label", (String[])new String[0]));
        wlCondition.setToolTipText(BaseMessages.getString(PKG, (String)"PipelineDebugDialog.Condition.ToolTip", (String[])new String[0]));
        FormData fdlCondition = new FormData();
        fdlCondition.left = new FormAttachment(0, 0);
        fdlCondition.right = new FormAttachment(this.middle, -this.margin);
        fdlCondition.top = new FormAttachment((Control)this.wPauseBreakPoint, this.margin);
        wlCondition.setLayoutData((Object)fdlCondition);
        ConditionEditor wCondition = new ConditionEditor(this.wComposite, 2048, this.condition, (IRowMeta)transformInputFields);
        FormData fdCondition = new FormData();
        fdCondition.left = new FormAttachment(this.middle, 0);
        fdCondition.right = new FormAttachment(100, 0);
        fdCondition.top = new FormAttachment((Control)this.wPauseBreakPoint, this.margin);
        fdCondition.bottom = new FormAttachment(100, 0);
        wCondition.setLayoutData(fdCondition);
        this.getTransformDebugData(transformDebugMeta);
        Button wClear = new Button(this.wComposite, 8);
        PropsUi.setLook((Widget)wClear);
        wClear.setText(BaseMessages.getString(PKG, (String)"PipelineDebugDialog.Clear.Label", (String[])new String[0]));
        wClear.setToolTipText(BaseMessages.getString(PKG, (String)"PipelineDebugDialog.Clear.ToolTip", (String[])new String[0]));
        FormData fdClear = new FormData();
        fdClear.left = new FormAttachment(0, 0);
        fdClear.bottom = new FormAttachment(100, 0);
        wClear.setLayoutData((Object)fdClear);
        wClear.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                PipelineDebugDialog.this.transformDebugMetaMap.remove(transformMeta);
                PipelineDebugDialog.this.wTransforms.table.setSelection(new int[0]);
                PipelineDebugDialog.this.previousIndex = -1;
                PipelineDebugDialog.this.refreshTransformList();
                PipelineDebugDialog.this.showTransformDebugInformation();
            }
        });
        this.wComposite.layout(true, true);
    }

    private void getTransformDebugData(TransformDebugMeta transformDebugMeta) {
        if (transformDebugMeta == null) {
            return;
        }
        if (transformDebugMeta.getRowCount() > 0) {
            this.wRowCount.setText(Integer.toString(transformDebugMeta.getRowCount()));
        } else {
            this.wRowCount.setText("");
        }
        this.wFirstRows.setSelection(transformDebugMeta.isReadingFirstRows());
        this.wPauseBreakPoint.setSelection(transformDebugMeta.isPausingOnBreakPoint());
    }
}

