/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.flink.translation.functions;

import java.util.Collections;
import java.util.Objects;
import org.apache.beam.runners.core.SideInputReader;
import org.apache.beam.runners.flink.translation.functions.AbstractFlinkCombineRunner;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.PaneInfo;
import org.apache.beam.sdk.transforms.windowing.TimestampCombiner;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.WindowingStrategy;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Iterables;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Iterators;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.PeekingIterator;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.util.Collector;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Instant;

public class SingleWindowFlinkCombineRunner<@UnknownKeyFor K, @UnknownKeyFor InputT, @UnknownKeyFor AccumT, @UnknownKeyFor OutputT, @UnknownKeyFor W extends @UnknownKeyFor @NonNull @Initialized BoundedWindow>
extends AbstractFlinkCombineRunner<K, InputT, AccumT, OutputT, W> {
    @Override
    public void combine(@UnknownKeyFor @NonNull @Initialized AbstractFlinkCombineRunner.FlinkCombiner<K, InputT, AccumT, OutputT> flinkCombiner, @UnknownKeyFor @NonNull @Initialized WindowingStrategy<@UnknownKeyFor @NonNull @Initialized Object, W> windowingStrategy, @UnknownKeyFor @NonNull @Initialized SideInputReader sideInputReader, @UnknownKeyFor @NonNull @Initialized PipelineOptions options, @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @NonNull @Initialized KV<K, InputT>>> elements, @UnknownKeyFor @NonNull @Initialized Collector<@UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @NonNull @Initialized KV<K, OutputT>>> out) {
        TimestampCombiner timestampCombiner = windowingStrategy.getTimestampCombiner();
        PeekingIterator iterator = Iterators.peekingIterator(elements.iterator());
        BoundedWindow currentWindow = (BoundedWindow)Iterables.getOnlyElement((Iterable)((WindowedValue)iterator.peek()).getWindows());
        Object key = ((KV)((WindowedValue)iterator.peek()).getValue()).getKey();
        Tuple2 combinedState = null;
        while (iterator.hasNext()) {
            WindowedValue currentValue = (WindowedValue)iterator.next();
            Preconditions.checkState((boolean)currentWindow.equals(Iterables.getOnlyElement((Iterable)currentValue.getWindows())), (Object)"Incompatible windows.");
            if (combinedState == null) {
                AccumT accumT = flinkCombiner.firstInput(key, ((KV)currentValue.getValue()).getValue(), options, sideInputReader, Collections.singleton(currentWindow));
                Instant windowTimestamp = timestampCombiner.assign(currentWindow, currentValue.getTimestamp());
                combinedState = new Tuple2(accumT, (Object)windowTimestamp);
                continue;
            }
            combinedState.f0 = flinkCombiner.addInput(key, combinedState.f0, ((KV)currentValue.getValue()).getValue(), options, sideInputReader, Collections.singleton(currentWindow));
            combinedState.f1 = timestampCombiner.combine(new Instant[]{(Instant)combinedState.f1, timestampCombiner.assign(currentWindow, currentValue.getTimestamp())});
        }
        Objects.requireNonNull(combinedState);
        Object accumulator = combinedState.f0;
        Instant windowTimestamp = (Instant)combinedState.f1;
        out.collect((Object)WindowedValue.of((Object)KV.of((Object)key, flinkCombiner.extractOutput(key, accumulator, options, sideInputReader, Collections.singleton(currentWindow))), (Instant)windowTimestamp, (BoundedWindow)currentWindow, (PaneInfo)PaneInfo.NO_FIRING));
    }
}

