/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.cache.affinity.rendezvous;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.UUID;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.affinity.AffinityFunction;
import org.apache.ignite.cache.affinity.AffinityFunctionContext;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.failure.FailureContext;
import org.apache.ignite.failure.FailureType;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.cache.GridCacheUtils;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.internal.util.typedef.internal.LT;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiPredicate;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.resources.IgniteInstanceResource;
import org.apache.ignite.resources.LoggerResource;
import org.jetbrains.annotations.Nullable;

public class RendezvousAffinityFunction
implements AffinityFunction,
Serializable {
    private static final long serialVersionUID = 0L;
    public static final int DFLT_PARTITION_COUNT = 1024;
    private static final Comparator<IgniteBiTuple<Long, ClusterNode>> COMPARATOR = new HashComparator();
    private int parts;
    private int mask = -1;
    private boolean exclNeighbors;
    private transient boolean exclNeighborsWarn;
    private IgniteBiPredicate<ClusterNode, ClusterNode> backupFilter;
    private IgniteBiPredicate<ClusterNode, List<ClusterNode>> affinityBackupFilter;
    @LoggerResource
    private transient IgniteLogger log;
    @GridToStringExclude
    @IgniteInstanceResource
    private transient IgniteEx ignite;

    public static int calculateMask(int parts) {
        return (parts & parts - 1) == 0 ? parts - 1 : -1;
    }

    public static int calculatePartition(Object key, int mask, int parts) {
        if (mask >= 0) {
            int h = key.hashCode();
            return (h ^ h >>> 16) & mask;
        }
        return U.safeAbs(key.hashCode() % parts);
    }

    public RendezvousAffinityFunction() {
        this(false);
    }

    public RendezvousAffinityFunction(boolean exclNeighbors) {
        this(exclNeighbors, 1024);
    }

    public RendezvousAffinityFunction(boolean exclNeighbors, int parts) {
        this(exclNeighbors, parts, null);
    }

    public RendezvousAffinityFunction(int parts, @Nullable IgniteBiPredicate<ClusterNode, ClusterNode> backupFilter) {
        this(false, parts, backupFilter);
    }

    private RendezvousAffinityFunction(boolean exclNeighbors, int parts, IgniteBiPredicate<ClusterNode, ClusterNode> backupFilter) {
        A.ensure(parts > 0, "parts > 0");
        this.exclNeighbors = exclNeighbors;
        this.setPartitions(parts);
        this.backupFilter = backupFilter;
    }

    public int getPartitions() {
        return this.parts;
    }

    public RendezvousAffinityFunction setPartitions(int parts) {
        A.ensure(parts <= 65000, "parts <= 65000");
        A.ensure(parts > 0, "parts > 0");
        this.parts = parts;
        this.mask = RendezvousAffinityFunction.calculateMask(parts);
        return this;
    }

    @Nullable
    public IgniteBiPredicate<ClusterNode, ClusterNode> getBackupFilter() {
        return this.backupFilter;
    }

    @Deprecated
    public RendezvousAffinityFunction setBackupFilter(@Nullable IgniteBiPredicate<ClusterNode, ClusterNode> backupFilter) {
        this.backupFilter = backupFilter;
        return this;
    }

    @Nullable
    public IgniteBiPredicate<ClusterNode, List<ClusterNode>> getAffinityBackupFilter() {
        return this.affinityBackupFilter;
    }

    public RendezvousAffinityFunction setAffinityBackupFilter(@Nullable IgniteBiPredicate<ClusterNode, List<ClusterNode>> affinityBackupFilter) {
        this.affinityBackupFilter = affinityBackupFilter;
        return this;
    }

    public boolean isExcludeNeighbors() {
        return this.exclNeighbors;
    }

    public RendezvousAffinityFunction setExcludeNeighbors(boolean exclNeighbors) {
        this.exclNeighbors = exclNeighbors;
        return this;
    }

    public Object resolveNodeHash(ClusterNode node) {
        return node.consistentId();
    }

    public List<ClusterNode> assignPartition(int part, List<ClusterNode> nodes, int backups, @Nullable Map<UUID, Collection<ClusterNode>> neighborhoodCache) {
        ClusterNode node;
        if (nodes.size() <= 1) {
            return nodes;
        }
        IgniteBiTuple[] hashArr = new IgniteBiTuple[nodes.size()];
        for (int i = 0; i < nodes.size(); ++i) {
            ClusterNode node2 = nodes.get(i);
            Object nodeHash = this.resolveNodeHash(node2);
            long hash = RendezvousAffinityFunction.hash(nodeHash.hashCode(), part);
            hashArr[i] = F.t(hash, node2);
        }
        int primaryAndBackups = backups == Integer.MAX_VALUE ? nodes.size() : Math.min(backups + 1, nodes.size());
        LazyLinearSortedContainer sortedNodes = new LazyLinearSortedContainer(hashArr, primaryAndBackups);
        if (backups == Integer.MAX_VALUE) {
            return this.replicatedAssign(nodes, sortedNodes);
        }
        Iterator it = sortedNodes.iterator();
        ArrayList<ClusterNode> res = new ArrayList<ClusterNode>(primaryAndBackups);
        HashSet<ClusterNode> allNeighbors = new HashSet<ClusterNode>();
        ClusterNode primary = (ClusterNode)it.next();
        res.add(primary);
        if (this.exclNeighbors) {
            allNeighbors.addAll(neighborhoodCache.get(primary.id()));
        }
        if (backups > 0) {
            while (it.hasNext() && res.size() < primaryAndBackups) {
                node = (ClusterNode)it.next();
                try {
                    if (!(this.backupFilter != null && this.backupFilter.apply(primary, node) || this.affinityBackupFilter != null && this.affinityBackupFilter.apply(node, res)) && (this.affinityBackupFilter != null || this.backupFilter != null)) continue;
                    if (this.exclNeighbors) {
                        if (allNeighbors.contains(node)) continue;
                        res.add(node);
                        allNeighbors.addAll(neighborhoodCache.get(node.id()));
                        continue;
                    }
                    res.add(node);
                }
                catch (Exception ex) {
                    this.ignite.context().failure().process(new FailureContext(FailureType.CRITICAL_ERROR, ex));
                }
            }
        }
        if (res.size() < primaryAndBackups && nodes.size() >= primaryAndBackups && this.exclNeighbors) {
            it = sortedNodes.iterator();
            it.next();
            while (it.hasNext() && res.size() < primaryAndBackups) {
                node = (ClusterNode)it.next();
                if (res.contains(node)) continue;
                res.add(node);
            }
            if (!this.exclNeighborsWarn) {
                LT.warn(this.log, "Affinity function excludeNeighbors property is ignored because topology has no enough nodes to assign backups.");
                this.exclNeighborsWarn = true;
            }
        }
        assert (res.size() <= primaryAndBackups);
        return res;
    }

    private List<ClusterNode> replicatedAssign(List<ClusterNode> nodes, Iterable<ClusterNode> sortedNodes) {
        ClusterNode primary = sortedNodes.iterator().next();
        ArrayList<ClusterNode> res = new ArrayList<ClusterNode>(nodes.size());
        res.add(primary);
        for (ClusterNode n : nodes) {
            if (n.equals(primary)) continue;
            res.add(n);
        }
        assert (res.size() == nodes.size()) : "Not enough backups: " + res.size();
        return res;
    }

    private static long hash(int key0, int key1) {
        long key = (long)key0 & 0xFFFFFFFFL | ((long)key1 & 0xFFFFFFFFL) << 32;
        key = (key ^ 0xFFFFFFFFFFFFFFFFL) + (key << 21);
        key ^= key >>> 24;
        key += (key << 3) + (key << 8);
        key ^= key >>> 14;
        key += (key << 2) + (key << 4);
        key ^= key >>> 28;
        key += key << 31;
        return key;
    }

    @Override
    public void reset() {
    }

    @Override
    public int partitions() {
        return this.parts;
    }

    @Override
    public int partition(Object key) {
        if (key == null) {
            throw new IllegalArgumentException("Null key is passed for a partition calculation. Make sure that an affinity key that is used is initialized properly.");
        }
        return RendezvousAffinityFunction.calculatePartition(key, this.mask, this.parts);
    }

    @Override
    public List<List<ClusterNode>> assignPartitions(AffinityFunctionContext affCtx) {
        ArrayList<List<ClusterNode>> assignments = new ArrayList<List<ClusterNode>>(this.parts);
        Map<UUID, Collection<ClusterNode>> neighborhoodCache = this.exclNeighbors ? GridCacheUtils.neighbors(affCtx.currentTopologySnapshot()) : null;
        List<ClusterNode> nodes = affCtx.currentTopologySnapshot();
        for (int i = 0; i < this.parts; ++i) {
            List<ClusterNode> partAssignment = this.assignPartition(i, nodes, affCtx.backups(), neighborhoodCache);
            assignments.add(partAssignment);
        }
        return assignments;
    }

    @Override
    public void removeNode(UUID nodeId) {
    }

    public String toString() {
        return S.toString(RendezvousAffinityFunction.class, this);
    }

    private static class LazyLinearSortedContainer
    implements Iterable<ClusterNode> {
        private final IgniteBiTuple<Long, ClusterNode>[] arr;
        private int sorted;

        LazyLinearSortedContainer(IgniteBiTuple<Long, ClusterNode>[] arr, int needFirstSortedCnt) {
            this.arr = arr;
            if (needFirstSortedCnt > (int)Math.log(arr.length)) {
                Arrays.sort(arr, COMPARATOR);
                this.sorted = arr.length;
            }
        }

        @Override
        public Iterator<ClusterNode> iterator() {
            return new SortIterator();
        }

        private class SortIterator
        implements Iterator<ClusterNode> {
            private int cur;

            private SortIterator() {
            }

            @Override
            public boolean hasNext() {
                return this.cur < LazyLinearSortedContainer.this.arr.length;
            }

            @Override
            public ClusterNode next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                if (this.cur < LazyLinearSortedContainer.this.sorted) {
                    return LazyLinearSortedContainer.this.arr[this.cur++].get2();
                }
                IgniteBiTuple<Long, ClusterNode> min = LazyLinearSortedContainer.this.arr[this.cur];
                int minIdx = this.cur;
                for (int i = this.cur + 1; i < LazyLinearSortedContainer.this.arr.length; ++i) {
                    if (COMPARATOR.compare(LazyLinearSortedContainer.this.arr[i], min) >= 0) continue;
                    minIdx = i;
                    min = LazyLinearSortedContainer.this.arr[i];
                }
                if (minIdx != this.cur) {
                    LazyLinearSortedContainer.this.arr[minIdx] = LazyLinearSortedContainer.this.arr[this.cur];
                    LazyLinearSortedContainer.this.arr[this.cur] = min;
                }
                LazyLinearSortedContainer.this.sorted = this.cur++;
                return min.get2();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Remove doesn't supported");
            }
        }
    }

    private static class HashComparator
    implements Comparator<IgniteBiTuple<Long, ClusterNode>>,
    Serializable {
        private static final long serialVersionUID = 0L;

        private HashComparator() {
        }

        @Override
        public int compare(IgniteBiTuple<Long, ClusterNode> o1, IgniteBiTuple<Long, ClusterNode> o2) {
            return o1.get1() < o2.get1() ? -1 : (o1.get1() > o2.get1() ? 1 : o1.get2().id().compareTo(o2.get2().id()));
        }
    }
}

