/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.worker;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.failure.FailureType;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.util.worker.GridWorker;
import org.apache.ignite.internal.util.worker.GridWorkerListener;
import org.apache.ignite.lang.IgniteBiInClosure;
import org.jetbrains.annotations.NotNull;

public class WorkersRegistry
implements GridWorkerListener {
    private static final long DFLT_CHECK_INTERVAL = 3000L;
    private final ConcurrentMap<String, GridWorker> registeredWorkers = new ConcurrentHashMap<String, GridWorker>();
    private volatile boolean livenessCheckEnabled = true;
    private volatile Iterator<Map.Entry<String, GridWorker>> checkIter = this.registeredWorkers.entrySet().iterator();
    private long lastCheckTs = U.currentTimeMillis();
    private final AtomicReference<Thread> lastChecker = new AtomicReference<Thread>(Thread.currentThread());
    private final IgniteBiInClosure<GridWorker, FailureType> workerFailedHnd;
    private volatile long sysWorkerBlockedTimeout;
    private final long checkInterval;
    private final IgniteLogger log;

    public WorkersRegistry(@NotNull IgniteBiInClosure<GridWorker, FailureType> workerFailedHnd, long sysWorkerBlockedTimeout, IgniteLogger log) {
        this.workerFailedHnd = workerFailedHnd;
        this.sysWorkerBlockedTimeout = U.ensurePositive(sysWorkerBlockedTimeout, Long.MAX_VALUE);
        this.checkInterval = Math.min(3000L, sysWorkerBlockedTimeout);
        this.log = log;
    }

    public void register(GridWorker w) {
        if (this.registeredWorkers.putIfAbsent(w.runner().getName(), w) != null) {
            throw new IllegalStateException("Worker is already registered [worker=" + w + "]");
        }
        this.checkIter = this.registeredWorkers.entrySet().iterator();
    }

    public void unregister(String name) {
        this.registeredWorkers.remove(name);
        this.checkIter = this.registeredWorkers.entrySet().iterator();
    }

    public Collection<String> names() {
        return this.registeredWorkers.keySet();
    }

    public GridWorker worker(String name) {
        return (GridWorker)this.registeredWorkers.get(name);
    }

    public boolean livenessCheckEnabled() {
        return this.livenessCheckEnabled;
    }

    public void livenessCheckEnabled(boolean val) {
        this.livenessCheckEnabled = val;
    }

    public long getSystemWorkerBlockedTimeout() {
        return this.sysWorkerBlockedTimeout == Long.MAX_VALUE ? 0L : this.sysWorkerBlockedTimeout;
    }

    public void setSystemWorkerBlockedTimeout(long val) {
        this.sysWorkerBlockedTimeout = U.ensurePositive(val, Long.MAX_VALUE);
    }

    @Override
    public void onStarted(GridWorker w) {
        this.register(w);
    }

    @Override
    public void onStopped(GridWorker w) {
        if (!w.isCancelled()) {
            this.workerFailedHnd.apply(w, FailureType.SYSTEM_WORKER_TERMINATION);
        }
        this.unregister(w.runner().getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onIdle(GridWorker w) {
        if (!this.livenessCheckEnabled) {
            return;
        }
        Thread prevCheckerThread = this.lastChecker.get();
        if (prevCheckerThread == null || this.registeredWorkers.size() < 2 || U.currentTimeMillis() - this.lastCheckTs <= this.checkInterval || !this.lastChecker.compareAndSet(prevCheckerThread, null)) {
            return;
        }
        try {
            this.lastCheckTs = U.currentTimeMillis();
            long workersToCheck = Math.max((long)this.registeredWorkers.size() * this.checkInterval / this.sysWorkerBlockedTimeout, 1L);
            int workersChecked = 0;
            while ((long)workersChecked < workersToCheck) {
                GridWorker worker;
                if (!this.checkIter.hasNext()) {
                    this.checkIter = this.registeredWorkers.entrySet().iterator();
                }
                try {
                    worker = this.checkIter.next().getValue();
                }
                catch (NoSuchElementException e) {
                    boolean set = this.lastChecker.compareAndSet(null, Thread.currentThread());
                    assert (set);
                    return;
                }
                Thread runner = worker.runner();
                if (runner != null && runner != Thread.currentThread() && !worker.isCancelled()) {
                    GridWorker worker0;
                    long heartbeatDelay;
                    GridWorker worker02;
                    if (!runner.isAlive() && (worker02 = (GridWorker)this.registeredWorkers.get(runner.getName())) != null && worker02 == worker) {
                        this.workerFailedHnd.apply(worker, FailureType.SYSTEM_WORKER_TERMINATION);
                    }
                    if ((heartbeatDelay = U.currentTimeMillis() - worker.heartbeatTs()) > this.sysWorkerBlockedTimeout && (worker0 = (GridWorker)this.registeredWorkers.get(runner.getName())) != null && worker0 == worker) {
                        this.log.error("Blocked system-critical thread has been detected. This can lead to cluster-wide undefined behaviour [workerName=" + worker.name() + ", threadName=" + runner.getName() + ", blockedFor=" + heartbeatDelay / 1000L + "s]");
                        this.workerFailedHnd.apply(worker, FailureType.SYSTEM_WORKER_BLOCKED);
                    }
                }
                if (runner == Thread.currentThread()) continue;
                ++workersChecked;
            }
        }
        finally {
            boolean set = this.lastChecker.compareAndSet(null, Thread.currentThread());
            assert (set);
        }
    }
}

