/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.exec.tracker;

import java.util.List;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.ignite.internal.metric.IoStatisticsHolder;
import org.apache.ignite.internal.metric.IoStatisticsQueryHelper;
import org.apache.ignite.internal.processors.cache.query.GridCacheQueryType;
import org.apache.ignite.internal.processors.performancestatistics.PerformanceStatisticsProcessor;
import org.apache.ignite.internal.processors.query.calcite.exec.tracker.IoTracker;
import org.apache.ignite.internal.util.typedef.T2;

public class PerformanceStatisticsIoTracker
implements IoTracker {
    private final PerformanceStatisticsProcessor perfStatProc;
    private final UUID originatingNodeId;
    private final long originatingQryId;
    private final AtomicLong logicalReads = new AtomicLong();
    private final AtomicLong physicalReads = new AtomicLong();
    private final AtomicBoolean started = new AtomicBoolean();
    private final List<T2<String, AtomicLong>> cntrs = new CopyOnWriteArrayList<T2<String, AtomicLong>>();

    public PerformanceStatisticsIoTracker(PerformanceStatisticsProcessor perfStatProc, UUID originatingNodeId, long originatingQryId) {
        this.perfStatProc = perfStatProc;
        this.originatingNodeId = originatingNodeId;
        this.originatingQryId = originatingQryId;
    }

    @Override
    public boolean startTracking() {
        if (this.started.compareAndSet(false, true)) {
            IoStatisticsQueryHelper.startGatheringQueryStatistics();
            return true;
        }
        return false;
    }

    @Override
    public void stopTracking() {
        IoStatisticsHolder stat = IoStatisticsQueryHelper.finishGatheringQueryStatistics();
        this.logicalReads.addAndGet(stat.logicalReads());
        this.physicalReads.addAndGet(stat.physicalReads());
        this.started.compareAndSet(true, false);
    }

    @Override
    public AtomicLong processedRowsCounter(String action) {
        AtomicLong cntr = new AtomicLong();
        this.cntrs.add((T2<String, AtomicLong>)new T2((Object)action, (Object)cntr));
        return cntr;
    }

    @Override
    public void flush() {
        long logicalReads = this.logicalReads.getAndSet(0L);
        long physicalReads = this.physicalReads.getAndSet(0L);
        if (logicalReads > 0L || physicalReads > 0L) {
            this.perfStatProc.queryReads(GridCacheQueryType.SQL_FIELDS, this.originatingNodeId, this.originatingQryId, logicalReads, physicalReads);
        }
        for (T2<String, AtomicLong> cntr : this.cntrs) {
            long rowsCnt = ((AtomicLong)cntr.get2()).getAndSet(0L);
            if (rowsCnt <= 0L) continue;
            this.perfStatProc.queryRowsProcessed(GridCacheQueryType.SQL_FIELDS, this.originatingNodeId, this.originatingQryId, (String)cntr.get1(), rowsCnt);
        }
    }
}

