/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.hint;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.rel.hint.HintPredicate;
import org.apache.calcite.rel.hint.HintPredicates;
import org.apache.calcite.rel.rules.CoreRules;
import org.apache.calcite.rel.rules.JoinPushThroughJoinRule;
import org.apache.ignite.internal.processors.query.calcite.hint.HintOptionsChecker;
import org.apache.ignite.internal.processors.query.calcite.hint.HintsConfig;

public enum HintDefinition {
    QUERY_ENGINE,
    DISABLE_RULE,
    EXPAND_DISTINCT_AGG{

        @Override
        public HintPredicate predicate() {
            return HintPredicates.AGGREGATE;
        }

        @Override
        public HintOptionsChecker optionsChecker() {
            return HintsConfig.OPTS_CHECK_EMPTY;
        }
    }
    ,
    ENFORCE_JOIN_ORDER{

        @Override
        public HintPredicate predicate() {
            return HintPredicates.JOIN;
        }

        @Override
        public HintOptionsChecker optionsChecker() {
            return HintsConfig.OPTS_CHECK_EMPTY;
        }

        @Override
        public Collection<RelOptRule> disabledRules() {
            return Arrays.asList(CoreRules.JOIN_COMMUTE, JoinPushThroughJoinRule.LEFT, JoinPushThroughJoinRule.RIGHT);
        }
    }
    ,
    NO_INDEX{

        @Override
        public HintPredicate predicate() {
            return HintPredicates.TABLE_SCAN;
        }

        @Override
        public HintOptionsChecker optionsChecker() {
            return HintsConfig.OPTS_CHECK_NO_KV;
        }
    }
    ,
    FORCE_INDEX{

        @Override
        public HintPredicate predicate() {
            return NO_INDEX.predicate();
        }

        @Override
        public HintOptionsChecker optionsChecker() {
            return NO_INDEX.optionsChecker();
        }
    }
    ,
    MERGE_JOIN{

        @Override
        public HintPredicate predicate() {
            return HintDefinition.joinHintPredicate();
        }

        @Override
        public HintOptionsChecker optionsChecker() {
            return HintsConfig.OPTS_CHECK_NO_KV;
        }
    }
    ,
    NO_MERGE_JOIN{

        @Override
        public HintPredicate predicate() {
            return MERGE_JOIN.predicate();
        }

        @Override
        public HintOptionsChecker optionsChecker() {
            return MERGE_JOIN.optionsChecker();
        }
    }
    ,
    NL_JOIN{

        @Override
        public HintPredicate predicate() {
            return HintDefinition.joinHintPredicate();
        }

        @Override
        public HintOptionsChecker optionsChecker() {
            return HintsConfig.OPTS_CHECK_NO_KV;
        }
    }
    ,
    NO_NL_JOIN{

        @Override
        public HintPredicate predicate() {
            return NL_JOIN.predicate();
        }

        @Override
        public HintOptionsChecker optionsChecker() {
            return NL_JOIN.optionsChecker();
        }
    }
    ,
    CNL_JOIN{

        @Override
        public HintPredicate predicate() {
            return HintDefinition.joinHintPredicate();
        }

        @Override
        public HintOptionsChecker optionsChecker() {
            return HintsConfig.OPTS_CHECK_NO_KV;
        }
    }
    ,
    NO_CNL_JOIN{

        @Override
        public HintPredicate predicate() {
            return CNL_JOIN.predicate();
        }

        @Override
        public HintOptionsChecker optionsChecker() {
            return CNL_JOIN.optionsChecker();
        }
    };


    private static HintPredicate joinHintPredicate() {
        return HintPredicates.or((HintPredicate[])new HintPredicate[]{HintPredicates.JOIN, HintPredicates.TABLE_SCAN});
    }

    HintPredicate predicate() {
        return HintPredicates.SET_VAR;
    }

    HintOptionsChecker optionsChecker() {
        return HintsConfig.OPTS_CHECK_PLAIN;
    }

    public Collection<RelOptRule> disabledRules() {
        return Collections.emptyList();
    }
}

