/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.rel;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelCollations;
import org.apache.calcite.rel.RelInput;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.CorrelationId;
import org.apache.calcite.rel.core.SetOp;
import org.apache.calcite.rel.core.Union;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.util.Pair;
import org.apache.ignite.internal.processors.query.calcite.rel.IgniteConvention;
import org.apache.ignite.internal.processors.query.calcite.rel.IgniteRel;
import org.apache.ignite.internal.processors.query.calcite.rel.IgniteRelVisitor;
import org.apache.ignite.internal.processors.query.calcite.trait.CorrelationTrait;
import org.apache.ignite.internal.processors.query.calcite.trait.IgniteDistribution;
import org.apache.ignite.internal.processors.query.calcite.trait.RewindabilityTrait;
import org.apache.ignite.internal.processors.query.calcite.trait.TraitUtils;
import org.apache.ignite.internal.processors.query.calcite.trait.TraitsAwareIgniteRel;
import org.apache.ignite.internal.processors.query.calcite.util.Commons;

public class IgniteUnionAll
extends Union
implements TraitsAwareIgniteRel {
    public IgniteUnionAll(RelOptCluster cluster, RelTraitSet traits, List<RelNode> inputs) {
        super(cluster, traits, inputs, true);
    }

    public IgniteUnionAll(RelInput input) {
        this(input.getCluster(), input.getTraitSet().replace((RelTrait)IgniteConvention.INSTANCE), input.getInputs());
    }

    public SetOp copy(RelTraitSet traitSet, List<RelNode> inputs, boolean all) {
        assert (all);
        return new IgniteUnionAll(this.getCluster(), traitSet, inputs);
    }

    @Override
    public <T> T accept(IgniteRelVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public Pair<RelTraitSet, List<RelTraitSet>> passThroughCollation(RelTraitSet nodeTraits, List<RelTraitSet> inputTraits) {
        return Pair.of((Object)nodeTraits.replace((RelTrait)RelCollations.EMPTY), Commons.transform(inputTraits, t -> t.replace((RelTrait)RelCollations.EMPTY)));
    }

    @Override
    public List<Pair<RelTraitSet, List<RelTraitSet>>> deriveRewindability(RelTraitSet nodeTraits, List<RelTraitSet> inputTraits) {
        boolean rewindable = inputTraits.stream().map(TraitUtils::rewindability).allMatch(RewindabilityTrait::rewindable);
        if (rewindable) {
            return ImmutableList.of((Object)Pair.of((Object)nodeTraits.replace((RelTrait)RewindabilityTrait.REWINDABLE), inputTraits));
        }
        return ImmutableList.of((Object)Pair.of((Object)nodeTraits.replace((RelTrait)RewindabilityTrait.ONE_WAY), Commons.transform(inputTraits, t -> t.replace((RelTrait)RewindabilityTrait.ONE_WAY))));
    }

    @Override
    public List<Pair<RelTraitSet, List<RelTraitSet>>> deriveDistribution(RelTraitSet nodeTraits, List<RelTraitSet> inputTraits) {
        Set distributions = inputTraits.stream().map(TraitUtils::distribution).collect(Collectors.toSet());
        ImmutableList.Builder b = ImmutableList.builder();
        for (IgniteDistribution distribution : distributions) {
            b.add((Object)Pair.of((Object)nodeTraits.replace((RelTrait)distribution), Commons.transform(inputTraits, t -> t.replace((RelTrait)distribution))));
        }
        return b.build();
    }

    @Override
    public List<Pair<RelTraitSet, List<RelTraitSet>>> deriveCollation(RelTraitSet nodeTraits, List<RelTraitSet> inputTraits) {
        return ImmutableList.of((Object)Pair.of((Object)nodeTraits.replace((RelTrait)RelCollations.EMPTY), Commons.transform(inputTraits, t -> t.replace((RelTrait)RelCollations.EMPTY))));
    }

    @Override
    public List<Pair<RelTraitSet, List<RelTraitSet>>> deriveCorrelation(RelTraitSet nodeTraits, List<RelTraitSet> inTraits) {
        Set<CorrelationId> correlationIds = inTraits.stream().map(TraitUtils::correlation).flatMap(corrTr -> corrTr.correlationIds().stream()).collect(Collectors.toSet());
        return ImmutableList.of((Object)Pair.of((Object)nodeTraits.replace((RelTrait)CorrelationTrait.correlations(correlationIds)), inTraits));
    }

    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        double rows = mq.getRowCount((RelNode)this);
        return planner.getCostFactory().makeCost(rows, rows * 1.0, 0.0);
    }

    @Override
    public IgniteRel clone(RelOptCluster cluster, List<IgniteRel> inputs) {
        return new IgniteUnionAll(cluster, this.getTraitSet(), Commons.cast(inputs));
    }
}

