/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.rule;

import java.util.List;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelRule;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelCollations;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.core.Spool;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlKind;
import org.apache.ignite.internal.processors.query.calcite.prepare.bounds.ExactBounds;
import org.apache.ignite.internal.processors.query.calcite.prepare.bounds.SearchBounds;
import org.apache.ignite.internal.processors.query.calcite.rel.IgniteFilter;
import org.apache.ignite.internal.processors.query.calcite.rel.IgniteHashIndexSpool;
import org.apache.ignite.internal.processors.query.calcite.rel.IgniteTableSpool;
import org.apache.ignite.internal.processors.query.calcite.rule.ImmutableFilterSpoolMergeToHashIndexSpoolRule;
import org.apache.ignite.internal.processors.query.calcite.trait.CorrelationTrait;
import org.apache.ignite.internal.processors.query.calcite.trait.TraitUtils;
import org.apache.ignite.internal.processors.query.calcite.util.Commons;
import org.apache.ignite.internal.processors.query.calcite.util.RexUtils;
import org.apache.ignite.internal.util.typedef.F;
import org.immutables.value.Value;

@Value.Enclosing
public class FilterSpoolMergeToHashIndexSpoolRule
extends RelRule<Config> {
    public static final RelOptRule INSTANCE = Config.DEFAULT.toRule();

    private FilterSpoolMergeToHashIndexSpoolRule(Config cfg) {
        super((RelRule.Config)cfg);
    }

    public void onMatch(RelOptRuleCall call) {
        IgniteFilter filter = (IgniteFilter)call.rel(0);
        IgniteTableSpool spool = (IgniteTableSpool)call.rel(1);
        RelOptCluster cluster = spool.getCluster();
        RelTraitSet trait = spool.getTraitSet();
        CorrelationTrait filterCorr = TraitUtils.correlation((RelNode)filter);
        if (filterCorr.correlated()) {
            trait = trait.replace((RelTrait)filterCorr);
        }
        RelNode input = spool.getInput();
        List<SearchBounds> searchBounds = RexUtils.buildHashSearchBounds(cluster, filter.getCondition(), spool.getRowType(), null, false);
        if (F.isEmpty(searchBounds)) {
            return;
        }
        List<RexNode> searchRow = Commons.transform(searchBounds, b -> {
            assert (b == null || b instanceof ExactBounds) : b;
            return b == null ? null : ((ExactBounds)b).bound();
        });
        IgniteHashIndexSpool res = new IgniteHashIndexSpool(cluster, trait.replace((RelTrait)RelCollations.EMPTY), input, searchRow, filter.getCondition(), searchBounds.stream().anyMatch(b -> b != null && b.condition().getKind() == SqlKind.IS_NOT_DISTINCT_FROM));
        call.transformTo((RelNode)res);
    }

    @Value.Immutable
    public static interface Config
    extends RelRule.Config {
        public static final Config DEFAULT = ImmutableFilterSpoolMergeToHashIndexSpoolRule.Config.of().withDescription("FilterSpoolMergeToHashIndexSpoolRule").withOperandFor(IgniteFilter.class, IgniteTableSpool.class);

        default public Config withOperandFor(Class<? extends Filter> filterClass, Class<? extends Spool> spoolClass) {
            return (Config)this.withOperandSupplier(o0 -> o0.operand(filterClass).oneInput(o1 -> o1.operand(spoolClass).anyInputs())).as(Config.class);
        }

        default public FilterSpoolMergeToHashIndexSpoolRule toRule() {
            return new FilterSpoolMergeToHashIndexSpoolRule(this);
        }
    }
}

