/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.schema;

import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.hint.RelHint;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.schema.Statistic;
import org.apache.calcite.schema.impl.AbstractTable;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.ignite.internal.processors.query.calcite.exec.ExecutionContext;
import org.apache.ignite.internal.processors.query.calcite.exec.SystemViewScan;
import org.apache.ignite.internal.processors.query.calcite.metadata.ColocationGroup;
import org.apache.ignite.internal.processors.query.calcite.prepare.MappingQueryContext;
import org.apache.ignite.internal.processors.query.calcite.rel.logical.IgniteLogicalTableScan;
import org.apache.ignite.internal.processors.query.calcite.schema.IgniteIndex;
import org.apache.ignite.internal.processors.query.calcite.schema.IgniteTable;
import org.apache.ignite.internal.processors.query.calcite.schema.SystemViewIndexImpl;
import org.apache.ignite.internal.processors.query.calcite.schema.SystemViewTableDescriptorImpl;
import org.apache.ignite.internal.processors.query.calcite.trait.IgniteDistribution;
import org.apache.ignite.internal.processors.query.calcite.type.IgniteTypeFactory;
import org.jetbrains.annotations.Nullable;

public class SystemViewTableImpl
extends AbstractTable
implements IgniteTable {
    private static final Double DEFAULT_ROW_COUNT_APPROXIMATION = 1000.0;
    private final SystemViewTableDescriptorImpl<?> desc;
    private final Map<String, IgniteIndex> indexes;
    private final Statistic statistic;

    public SystemViewTableImpl(SystemViewTableDescriptorImpl<?> desc) {
        this.desc = desc;
        this.statistic = new StatisticsImpl();
        if (desc.isFiltrable()) {
            SystemViewIndexImpl idx = new SystemViewIndexImpl(this);
            this.indexes = Collections.singletonMap(idx.name(), idx);
        } else {
            this.indexes = Collections.emptyMap();
        }
    }

    @Override
    public RelDataType getRowType(RelDataTypeFactory typeFactory, ImmutableBitSet requiredColumns) {
        return this.desc.rowType((IgniteTypeFactory)typeFactory, requiredColumns);
    }

    public Statistic getStatistic() {
        return this.statistic;
    }

    public SystemViewTableDescriptorImpl<?> descriptor() {
        return this.desc;
    }

    @Override
    public IgniteLogicalTableScan toRel(RelOptCluster cluster, RelOptTable relOptTbl, @Nullable List<RexNode> proj, @Nullable RexNode cond, @Nullable ImmutableBitSet requiredColumns, @Nullable List<RelHint> hints) {
        return IgniteLogicalTableScan.create(cluster, cluster.traitSet(), relOptTbl, hints, proj, cond, requiredColumns);
    }

    @Override
    public <Row> Iterable<Row> scan(ExecutionContext<Row> execCtx, ColocationGroup grp, @Nullable ImmutableBitSet usedColumns) {
        return new SystemViewScan(execCtx, this.desc, null, usedColumns);
    }

    @Override
    public ColocationGroup colocationGroup(MappingQueryContext ctx) {
        return this.desc.colocationGroup(ctx);
    }

    @Override
    public IgniteDistribution distribution() {
        return this.desc.distribution();
    }

    @Override
    public Map<String, IgniteIndex> indexes() {
        return this.indexes;
    }

    @Override
    public void addIndex(IgniteIndex idxTbl) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IgniteIndex getIndex(String idxName) {
        return this.indexes.get(idxName);
    }

    @Override
    public void removeIndex(String idxName) {
        throw new UnsupportedOperationException();
    }

    public <C> C unwrap(Class<C> aCls) {
        if (aCls.isInstance(this.desc)) {
            return aCls.cast(this.desc);
        }
        return (C)super.unwrap(aCls);
    }

    @Override
    public boolean isModifiable() {
        return false;
    }

    @Override
    public void markIndexRebuildInProgress(boolean mark) {
        throw new AssertionError((Object)"Index rebuild in progress was marked for system view");
    }

    @Override
    public boolean isIndexRebuildInProgress() {
        return false;
    }

    @Override
    public String name() {
        return this.desc.name();
    }

    @Override
    public void authorize(IgniteTable.Operation op) {
    }

    private static class StatisticsImpl
    implements Statistic {
        private StatisticsImpl() {
        }

        public Double getRowCount() {
            return DEFAULT_ROW_COUNT_APPROXIMATION;
        }

        public List<RelCollation> getCollations() {
            return ImmutableList.of();
        }
    }
}

